/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import org.cfeclipse.cfml.snippets.views.snips.SnipWriter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnipFileDialog
extends Dialog {
    private static String dialogTitle = "New Snippet";
    private static String snippetNameLabel = "Snippet name: ";
    private static String snippetKeyComboLabel = "Trigger text: ";
    private static String snippetDescriptionLabel = "Snippet description: ";
    private static String snippetCodeStartLabel = "Snippet starting block: ";
    private static String snippetCodeEndLabel = "Snippet closing block: ";
    private static String useSnippetAsTemplateLabel = "Use this snippet as a file template";
    private static String templateExtensionLabel = "Template extension:";
    private TreeViewer treeView;
    private Text snippetNameText;
    private Text snippetKeyComboText;
    private Text snippetDescriptionText;
    private Text snippetStartText;
    private Text snippetEndText;
    private Text templateExtensionText;
    private String snippetNameValue = "";
    private String snippetKeyComboValue = "";
    private String snippetDescriptionValue = "";
    private String snippetStartValue = "";
    private String snippetEndValue = "";
    private boolean useAsTemplate = false;
    private String templateExtensionValue = "cfm";
    private SnipWriter writer;
    private String originalFileName = null;
    private Button useAsTemplateButton;
    private Button okButton;
    private Label errorMessageLabel;

    public SnipFileDialog(Shell parent, SnipWriter fileWriter, TreeViewer treeView, String snippetNameInitialValue, String snippetKeyComboInitialValue, String snippetDescriptionInitialValue, String startTextInitialValue, String endTextInitialValue, boolean useAsTemplateInitialValue, String templateExtensionInitialValue) {
        super(parent);
        if (snippetNameInitialValue != null) {
            this.snippetNameValue = this.originalFileName = snippetNameInitialValue;
        }
        if (snippetKeyComboInitialValue != null) {
            this.snippetKeyComboValue = snippetKeyComboInitialValue;
        }
        if (snippetDescriptionInitialValue != null) {
            this.snippetDescriptionValue = snippetDescriptionInitialValue;
        }
        if (startTextInitialValue != null) {
            this.snippetStartValue = startTextInitialValue;
        }
        if (endTextInitialValue != null) {
            this.snippetEndValue = endTextInitialValue;
        }
        this.useAsTemplate = useAsTemplateInitialValue;
        if (templateExtensionInitialValue != null) {
            this.templateExtensionValue = templateExtensionInitialValue;
        }
        this.treeView = treeView;
        this.writer = fileWriter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(snippetNameLabel);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.snippetNameText = new Text(composite, 2052);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.snippetNameText.setLayoutData((Object)data);
        this.snippetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.snippetNameText.setFont(parent.getFont());
        label = new Label(composite, 64);
        label.setText(snippetKeyComboLabel);
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.snippetKeyComboText = new Text(composite, 2052);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.snippetKeyComboText.setLayoutData((Object)data);
        this.snippetKeyComboText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.snippetKeyComboText.setFont(parent.getFont());
        label = new Label(composite, 64);
        label.setText(snippetDescriptionLabel);
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.snippetDescriptionText = new Text(composite, 2116);
        this.snippetDescriptionText.setLayoutData((Object)new GridData(768));
        this.snippetDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.snippetDescriptionText.setFont(parent.getFont());
        label = new Label(composite, 64);
        label.setText(snippetCodeStartLabel);
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.snippetStartText = new Text(composite, 2818);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(6);
        this.snippetStartText.setLayoutData((Object)data);
        this.snippetStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.snippetStartText.setFont(parent.getFont());
        label = new Label(composite, 64);
        label.setText(snippetCodeEndLabel);
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.snippetEndText = new Text(composite, 2818);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(6);
        this.snippetEndText.setLayoutData((Object)data);
        this.snippetEndText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.snippetEndText.setFont(parent.getFont());
        this.useAsTemplateButton = new Button(composite, 32);
        this.useAsTemplateButton.setText(useSnippetAsTemplateLabel);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(35);
        this.useAsTemplateButton.setLayoutData((Object)data);
        this.useAsTemplateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnipFileDialog.this.useAsTemplate = SnipFileDialog.this.useAsTemplateButton.getSelection();
                SnipFileDialog.this.templateExtensionText.setEnabled(SnipFileDialog.this.useAsTemplateButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useAsTemplateButton.setFont(parent.getFont());
        label = new Label(composite, 64);
        label.setText(templateExtensionLabel);
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.templateExtensionText = new Text(composite, 2052);
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.templateExtensionText.setEnabled(false);
        this.templateExtensionText.setLayoutData((Object)data);
        this.templateExtensionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnipFileDialog.this.validateInput();
            }
        });
        this.templateExtensionText.setFont(parent.getFont());
        this.errorMessageLabel = new Label(composite, 64);
        data = new GridData(1796);
        data.heightHint = this.convertHeightInCharsToPixels(2);
        this.errorMessageLabel.setLayoutData((Object)data);
        this.errorMessageLabel.setFont(parent.getFont());
        Color color = new Color((Device)Display.getCurrent(), 255, 0, 0);
        this.errorMessageLabel.setForeground(color);
        return composite;
    }

    protected void okPressed() {
        if (this.useAsTemplateButton.getSelection() && this.templateExtensionText.getText().trim().equals("")) {
            this.templateExtensionText.setText("cfm");
        }
        this.writer.writeSnippet(this.snippetNameText.getText(), this.snippetKeyComboText.getText(), this.snippetDescriptionText.getText(), this.snippetStartText.getText(), this.snippetEndText.getText(), this.useAsTemplateButton.getSelection(), this.templateExtensionText.getText(), this.originalFileName);
        this.close();
        this.treeView.refresh();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.snippetNameValue = this.snippetNameText.getText();
            this.snippetKeyComboValue = this.snippetKeyComboText.getText();
            this.snippetDescriptionValue = this.snippetDescriptionText.getText();
            this.snippetStartValue = this.snippetStartText.getText();
            this.snippetEndValue = this.snippetEndText.getText();
            this.useAsTemplate = this.useAsTemplateButton.getSelection();
            this.templateExtensionValue = this.templateExtensionText.getText();
        } else {
            this.snippetNameValue = null;
            this.snippetKeyComboValue = null;
            this.snippetDescriptionValue = null;
            this.snippetStartValue = null;
            this.snippetEndValue = null;
            this.useAsTemplate = false;
            this.templateExtensionValue = "cfm";
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (dialogTitle != null) {
            shell.setText(dialogTitle);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.snippetNameText.setFocus();
        if (this.snippetNameValue != null) {
            this.snippetNameText.setText(this.snippetNameValue);
            this.snippetNameText.selectAll();
        }
        if (this.snippetKeyComboValue != null) {
            this.snippetKeyComboText.setText(this.snippetKeyComboValue);
        }
        if (this.snippetDescriptionValue != null) {
            this.snippetDescriptionText.setText(this.snippetDescriptionValue);
        }
        if (this.snippetStartValue != null) {
            this.snippetStartText.setText(this.snippetStartValue);
        }
        if (this.snippetEndValue != null) {
            this.snippetEndText.setText(this.snippetEndValue);
        }
        this.useAsTemplateButton.setSelection(this.useAsTemplate);
        this.templateExtensionText.setEnabled(this.useAsTemplate);
        this.templateExtensionText.setText(this.templateExtensionValue);
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected void validateInput() {
        String errorMessage = null;
        this.snippetNameText.getText();
        if (!this.snippetNameText.getText().matches("[0-9a-zA-Z _-]+")) {
            errorMessage = "The snippet name can only contain numbers, alphabetic characters, space underscore and dash.";
        } else if (this.snippetKeyComboText.getText().length() > 0 && !this.snippetKeyComboText.getText().matches("[0-9a-zA-Z_-]+")) {
            errorMessage = "The trigger text can only contain numbers, alphabetic characters, underscore and dash.";
        } else if (!this.templateExtensionText.getText().matches("[0-9a-zA-Z_.]+")) {
            errorMessage = "The template extension can only contain numbers, alphabetic characters, periods and underscores";
        }
        this.errorMessageLabel.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageLabel.getParent().update();
    }
}

