/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.wizards.snipex.ExportApplicationWizard;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnipExExportBean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectAppPage
extends WizardPage {
    private Combo applicationList;
    private Combo serverList;
    private SnipExExportBean exportBean;
    private Log logger = LogFactory.getLog(SelectAppPage.class);

    protected SelectAppPage(String pageName, SnipExExportBean exportBean) {
        super(pageName);
        this.exportBean = exportBean;
        this.setDescription("Select the Project and the SnipEx server you want to export to.");
        this.setTitle("Export Project to SnipEx Server");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        GridData comboGD = new GridData();
        comboGD.widthHint = 200;
        Label lblProject = new Label(container, 0);
        lblProject.setText("Project:");
        this.applicationList = new Combo(container, 8);
        this.applicationList.setLayoutData((Object)comboGD);
        this.applicationList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.fillProjects(this.applicationList);
        Label lblServer = new Label(container, 0);
        lblServer.setText("SnipEx Server:");
        this.serverList = new Combo(container, 8);
        this.serverList.setLayoutData((Object)comboGD);
        this.serverList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.fillServers(this.serverList);
        this.setControl((Control)container);
    }

    private void setState() {
        ((ExportApplicationWizard)this.getWizard()).setFinished(false);
        this.getWizard().getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setState();
        }
    }

    private void fillServers(Combo serverList2) {
        IPreferenceStore preferenceStore = SnippetPlugin.getDefault().getPreferenceStore();
        String url1 = preferenceStore.getString("snipExURL1");
        String url2 = preferenceStore.getString("snipExURL2");
        String url3 = preferenceStore.getString("snipExURL3");
        String url4 = preferenceStore.getString("snipExURL4");
        String url5 = preferenceStore.getString("snipExURL5");
        String url6 = preferenceStore.getString("snipExURL6");
        String url7 = preferenceStore.getString("snipExURL7");
        String url8 = preferenceStore.getString("snipExURL8");
        if (url1.length() > 0 && this.canSubmit(url1)) {
            serverList2.add(url1);
        }
        if (url2.length() > 0 && this.canSubmit(url2)) {
            serverList2.add(url2);
        }
        if (url3.length() > 0 && this.canSubmit(url3)) {
            serverList2.add(url3);
        }
        if (url4.length() > 0 && this.canSubmit(url4)) {
            serverList2.add(url4);
        }
        if (url5.length() > 0 && this.canSubmit(url5)) {
            serverList2.add(url5);
        }
        if (url6.length() > 0 && this.canSubmit(url6)) {
            serverList2.add(url6);
        }
        if (url7.length() > 0 && this.canSubmit(url7)) {
            serverList2.add(url7);
        }
        if (url8.length() > 0 && this.canSubmit(url8)) {
            serverList2.add(url8);
        }
    }

    private boolean canSubmit(String url1) {
        try {
            URL snipexServer = new URL(String.valueOf(url1) + "?method=canSubmit");
            Object response = snipexServer.getContent();
            this.logger.debug(response);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean canFinish() {
        return false;
    }

    private void fillProjects(Combo applicationList2) {
        IProject[] projects = this.getProjects();
        int selectedItem = 0;
        int proj = 0;
        while (proj < projects.length) {
            IProject project = projects[proj];
            if (project.equals((Object)this.exportBean.getProject())) {
                selectedItem = proj;
            }
            applicationList2.add(project.getName());
            ++proj;
        }
        applicationList2.select(selectedItem);
    }

    private IProject[] getProjects() {
        IWorkspace workspace = SnippetPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        return projects;
    }

    public IProject getSelectedProject() {
        IWorkspace workspace = SnippetPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.applicationList.getText());
        return project;
    }

    public String getServer() {
        return this.serverList.getText();
    }

    private boolean isValidState() {
        if (this.applicationList.getText() == null || this.applicationList.getText().equals("")) {
            this.setErrorMessage("Please select the project to export");
            return false;
        }
        if (this.serverList.getText() == null || this.serverList.getText().equals("")) {
            this.setErrorMessage("Please select the SnipEx server to export the project to");
            return false;
        }
        return true;
    }
}

