/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.tpk.page;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.ui.multi.MultiCheckStateListener;

public class ReferencedProjectPackagePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private final int REFERENCED_PROJECT_NAME_COL_NUM = 0;
    private final int REFERENCED_PROJECT_LIBRARY_NAME_COL_NUM = 1;
    private final int REFERENCED_PROJECT_PACKAGE_PATH_COL_NUM = 2;
    private final String[] DEFAULT_LIBRARY_PATH = new String[]{"lib", "shared"};
    private static final String DEFUALT_PACKAGE_DIR = "lib";
    private Table table = null;
    private IProject project = null;
    private List<InputData> inputDataList;
    private CheckboxTableViewer tableViewer;

    public ReferencedProjectPackagePage() {
    }

    public ReferencedProjectPackagePage(IProject project, List<IProject> libraryProjectList) {
        this.project = project;
        this.inputDataList = new ArrayList<InputData>();
        for (IProject libraryProject : libraryProjectList) {
            this.inputDataList.add(new InputData(libraryProject));
        }
    }

    protected Control createContents(Composite parent) {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.createReferencedProjectTable(parent);
        return parent;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tv, String title, int bound, int align) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tv, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        column.setAlignment(align);
        return viewerColumn;
    }

    public List<InputData> getSelectedData() {
        ArrayList<InputData> inputDataList = new ArrayList<InputData>();
        Object[] objectArray = this.tableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            inputDataList.add((InputData)obj);
            ++n2;
        }
        return inputDataList;
    }

    public void createReferencedProjectTable(Composite parent) {
        Label descriptionLabel = new Label(parent, 0);
        String description = String.format("Configure the library path of %s project. \nReferenced project's library will be included in the library path you specify.\n", this.project.getName());
        descriptionLabel.setText(description);
        this.table = new Table(parent, 68128);
        this.table.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(false);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.addCheckStateListener((ICheckStateListener)new MultiCheckStateListener(this.tableViewer, true));
        TableViewerColumn refColumn = this.createTableViewerColumn((TableViewer)this.tableViewer, "Referenced Project", 150, 16384);
        refColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InputData data = (InputData)element;
                return data.project.getName();
            }
        });
        TableViewerColumn libColumn = this.createTableViewerColumn((TableViewer)this.tableViewer, "Library", 120, 16384);
        libColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InputData data = (InputData)element;
                return ProjectUtil.getBinaryName((IProject)data.project);
            }
        });
        TableViewerColumn pathColumn = this.createTableViewerColumn((TableViewer)this.tableViewer, "Library Path", 350, 16384);
        pathColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InputData data = (InputData)element;
                if (data.libraryPath == "") {
                    data.libraryPath = ReferencedProjectPackagePage.this.getProjectPath(data.project.getName());
                }
                return data.libraryPath;
            }
        });
        pathColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object arg0) {
                return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
            }

            protected Object getValue(Object arg0) {
                return "";
            }

            protected void setValue(Object element, Object arg1) {
                InputData data = (InputData)element;
                data.libraryPath = this.getRelativePackagePath((String)arg1);
                this.getViewer().update(element, null);
            }

            private String getRelativePackagePath(String path) {
                if (path == null || path.isEmpty()) {
                    return "";
                }
                path = path.replace('\\', '/');
                Path p = new Path(path);
                String firstDir = p.segment(0);
                String[] stringArray = ReferencedProjectPackagePage.this.DEFAULT_LIBRARY_PATH;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String defaultLibPath = stringArray[n2];
                    if (firstDir.equals(defaultLibPath)) {
                        return p.toOSString();
                    }
                    ++n2;
                }
                Path libPath = new Path(ReferencedProjectPackagePage.DEFUALT_PACKAGE_DIR);
                return libPath.append((IPath)p).toOSString();
            }
        });
        this.tableViewer.setInput(this.inputDataList);
        this.initCheck(this.inputDataList, this.tableViewer);
    }

    private void initCheck(List<InputData> dataList, CheckboxTableViewer viewer) {
        TizenProjectDescription desc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)this.project);
        Set subProjectList = desc.getReferencedLibraryProjectMap().keySet();
        for (InputData inputData : dataList) {
            for (String subProject : subProjectList) {
                if (!inputData.project.getName().equals(subProject)) continue;
                viewer.setChecked((Object)inputData, true);
            }
        }
    }

    private void createTableItem() {
        this.table.removeAll();
        IProject[] referencedProjects = null;
        try {
            referencedProjects = this.project.getReferencedProjects();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        if (referencedProjects == null) {
            return;
        }
        IProject[] iProjectArray = referencedProjects;
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (ProjectUtil.isLibraryProject((IProject)refProject)) {
                this.fillTableInfo(refProject);
            }
            ++n2;
        }
    }

    public void createTableItem(List<IProject> projectList) {
        for (IProject project : projectList) {
            this.fillTableInfo(project);
        }
    }

    private void fillTableInfo(IProject project) {
        TableItem item = new TableItem(this.table, 0);
        String projectName = project.getName();
        item.setText(0, projectName);
        item.setText(1, ProjectUtil.getBinaryName((IProject)project));
        item.setText(2, this.getProjectPath(projectName));
    }

    private String getProjectPath(String projectName) {
        String projectPath = CommonConfigurationManager.getReferencedProjectPath((IProject)this.project, (String)projectName);
        if (projectPath == null || projectPath.isEmpty()) {
            return ReferencedProjectPackagePage.getDefaultLocation();
        }
        return projectPath;
    }

    public void performApply() {
        this.saveReferencedProject();
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void performDefaults() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tItem = tableItemArray[n2];
            tItem.setText(2, ReferencedProjectPackagePage.getDefaultLocation());
            ++n2;
        }
        super.performDefaults();
    }

    private static String getDefaultLocation() {
        return DEFUALT_PACKAGE_DIR + File.separator;
    }

    public void saveReferencedProject() {
        TizenProjectDescription desc = this.makeDescription();
        TprojectHandler handler = new TprojectHandler(this.project);
        handler.marshal(desc);
    }

    private TizenProjectDescription makeDescription() {
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project);
        TizenProjectDescription desc = tProject.getDescription();
        desc.clearReferencedProjectList();
        for (InputData data : this.getSelectedData()) {
            desc.addReferencedLibraryProject(data.getProject().getName(), data.libraryPath.replace('\\', '/'));
        }
        return desc;
    }

    public static final class InputData {
        IProject project;
        String libraryPath = "";

        public InputData(IProject project) {
            this.project = project;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

