/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativecommon.po.editor.Messages;
import org.tizen.nativecommon.po.editor.POEditor;
import org.tizen.nativecommon.po.editor.POEditorInstances;

public class POEditorLauncher
implements IEditorLauncher {
    private static final Logger logger = LoggerFactory.getLogger(POEditorLauncher.class);

    public void open(IPath filepath) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filepath);
            IPath path = file.getProjectRelativePath();
            String poFilename = path.lastSegment();
            IPath poPath = new Path("res/po").append(poFilename);
            if (!poPath.equals((Object)path)) {
                String msg = String.format(Messages.POFileEditorOpenError_PathInvalid, path.toOSString());
                DialogUtil.openMessageDialog((Shell)DialogUtil.getActiveShell(), (String)Messages.POFileEditorOpen_Title, (String)msg);
                return;
            }
            IProject project = file.getProject();
            if (POEditorInstances.get(project) != null) {
                String filename = filepath.lastSegment();
                String langId = this.getCodeFromFileName(filename);
                POEditor editor = POEditorInstances.get(project);
                this.bringEditorToTop(editor);
                POEditorInstances.get(project).showLanguage(langId);
            } else {
                String lastSeg = filepath.lastSegment();
                lastSeg = lastSeg.replace(".po", ".pm");
                filepath = filepath.removeLastSegments(1);
                filepath = filepath.append(lastSeg);
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filepath.lastSegment());
                page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            }
        }
        catch (PartInitException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getCodeFromFileName(String name) {
        return name.substring(0, name.length() - 3);
    }

    private void bringEditorToTop(POEditor editor) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow active = workbench.getActiveWorkbenchWindow();
        if (active != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = active.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage p = iWorkbenchPageArray[n2];
                if (p != null) {
                    IEditorReference[] editorRefs;
                    IEditorReference[] iEditorReferenceArray = editorRefs = p.getEditorReferences();
                    int n3 = editorRefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference f = iEditorReferenceArray[n4];
                        if (f.getEditorInput() == editor.getEditorInput()) {
                            p.bringToTop(f.getPart(true));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }
}

