/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CFPluginImages {
    protected static URL iconBaseURL;
    protected static final ImageRegistry IMAGE_REGISTRY;
    public static final String ICON_SNIP = "snip.gif";
    public static final String ICON_SNIP_EXPORT = "export_wiz.gif";
    public static final String ICON_SNIP_IMPORT = "import_wiz.gif";
    public static final String ICON_REFRESH = "refresh.gif";
    public static final String ICON_PACKAGE = "package.gif";
    public static final String ICON_PACKAGE_OFF = "package_off.gif";
    public static final String ICON_PACKAGE_SNIPEX = "package_sx.png";
    public static final String ICON_ADD = "add.gif";
    public static final String ICON_EDIT = "edit.gif";
    public static final String ICON_REMOVE = "remove.gif";
    public static final String ICON_DELETE = "delete.gif";
    public static final String ICON_TEMPLATE_SNIP = "insertsnip.gif";
    public static final String ICON_INSERT_SNIP = "insertsnip.gif";
    public static final String ICON_DW = "dw.gif";
    public static final String ICON_SNIPEX = "snipex.png";
    public static final String MODEL_OBJECTS = "obj16";
    public static final String TOOLBAR = "ctool16";
    public static final String EDITORTOOLBAR = "toolbars";

    static {
        IMAGE_REGISTRY = SnippetPlugin.getDefault().getImageRegistry();
    }

    private CFPluginImages() {
    }

    public static void initCFPluginImages() {
        if (iconBaseURL == null) {
            String pathSuffix = "icons/";
            try {
                iconBaseURL = new URL(SnippetPlugin.getDefault().getBundle().getEntry("/"), pathSuffix);
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
            }
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_SNIP);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, "insertsnip.gif");
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_DW);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_PACKAGE);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_PACKAGE_SNIPEX);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_PACKAGE_OFF);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_SNIP_EXPORT);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_SNIP_IMPORT);
            CFPluginImages.addImageToRegistry(MODEL_OBJECTS, ICON_SNIPEX);
            CFPluginImages.addImageToRegistry(TOOLBAR, ICON_ADD);
            CFPluginImages.addImageToRegistry(TOOLBAR, ICON_EDIT);
            CFPluginImages.addImageToRegistry(TOOLBAR, ICON_REMOVE);
            CFPluginImages.addImageToRegistry(TOOLBAR, ICON_DELETE);
            CFPluginImages.addImageToRegistry(TOOLBAR, ICON_REFRESH);
            CFPluginImages.addImageToRegistry(TOOLBAR, "insertsnip.gif");
        }
    }

    public static Image get(String key) {
        return IMAGE_REGISTRY.get(key);
    }

    public static ImageRegistry getImageRegistry() {
        return IMAGE_REGISTRY;
    }

    public static ImageDescriptor getImageDescriptor(String offset, String imageid) {
        return CFPluginImages.createDescriptor(offset, imageid);
    }

    protected static ImageDescriptor addImageToRegistry(String offset, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)CFPluginImages.createIconFileURL(offset, name));
            IMAGE_REGISTRY.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected static ImageDescriptor createDescriptor(String offset, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CFPluginImages.createIconFileURL(offset, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected static URL createIconFileURL(String offset, String name) throws MalformedURLException {
        if (iconBaseURL == null) {
            throw new MalformedURLException();
        }
        if (offset != null) {
            StringBuffer buffer = new StringBuffer(offset);
            buffer.append('/');
            buffer.append(name);
            return new URL(iconBaseURL, buffer.toString());
        }
        return new URL(iconBaseURL, name);
    }

    public static Image addOverlay(Image image, RGB color) {
        int transColor;
        int pixelColor;
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        int overlayColor = palette.getPixel(color);
        ImageData fullImageData = image.getImageData();
        ImageData transparency = fullImageData.getTransparencyMask();
        int width = fullImageData.width;
        int height = fullImageData.height;
        int midX = Math.round((float)width / 2.0f);
        int midY = Math.round((float)height / 2.0f);
        int i = width - 1;
        while (i >= 0) {
            pixelColor = fullImageData.getPixel(i, midX);
            if (pixelColor != (transColor = transparency.getPixel(i, midY))) {
                width = i;
                break;
            }
            --i;
        }
        i = height - 1;
        while (i >= 0) {
            pixelColor = fullImageData.getPixel(midX, i);
            if (pixelColor != (transColor = transparency.getPixel(midY, i))) {
                height = i;
                break;
            }
            --i;
        }
        int minX = width - 10;
        int maxX = width - 1;
        int minY = height - 10;
        int maxY = height - 1;
        int i2 = minX;
        while (i2 <= maxX) {
            int j = minY;
            while (j <= maxY) {
                boolean repaint = true;
                if (i2 == minX || i2 == maxX) {
                    if (j == minY) {
                        repaint = false;
                    } else if (j == maxY) {
                        repaint = false;
                    }
                }
                if (repaint) {
                    fullImageData.setPixel(i2, j, overlayColor);
                }
                ++j;
            }
            ++i2;
        }
        Image fullImage = new Image((Device)Display.getCurrent(), fullImageData);
        return fullImage;
    }
}

