/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.util.ArrayList;
import java.util.Iterator;
import org.cfeclipse.cfml.snippets.views.snips.ComboModifyListener;
import org.cfeclipse.cfml.snippets.views.snips.SnipVarItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnipDialog
extends Dialog {
    protected String title;
    private ArrayList itemList;
    private Combo combo;
    private Text text;
    private ComboViewer comboViewer;
    private int selectedID;

    public SnipDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        container.setLayout((Layout)gl);
        FontData labelFontData = new FontData();
        labelFontData.setStyle(1);
        container.getFont().getFontData();
        Font labelFont = new Font((Device)parent.getDisplay(), labelFontData);
        for (SnipVarItem item : this.itemList) {
            Label label = new Label(container, 256);
            label.setText(String.valueOf(item.getName()) + ":");
            label.setFont(labelFont);
            GridData gridData = new GridData(256);
            gridData.widthHint = 200;
            if (item.getValues().length > 1) {
                this.addComboField(container, item, gridData);
                continue;
            }
            this.addTextField(container, item, gridData);
        }
        return container;
    }

    private void addComboField(Composite parent, SnipVarItem item, GridData gridData) {
        String[] items = item.getValues();
        this.combo = new Combo(parent, 4);
        this.combo.setLayoutData((Object)gridData);
        ComboModifyListener modifyListener = new ComboModifyListener(this.combo);
        this.combo.addModifyListener((ModifyListener)modifyListener);
        this.combo.addKeyListener((KeyListener)modifyListener);
        item.setCombo(this.combo);
        this.combo.setItems(items);
        this.combo.select(0);
        Label invLabel = new Label(parent, 0);
        invLabel.setText("");
    }

    private void addTextField(Composite parent, SnipVarItem item, GridData gridData) {
        String[] items = item.getValues();
        final Text text = new Text(parent, 2048);
        text.setLayoutData((Object)gridData);
        item.setText(text);
        text.setText(items[0]);
        final Button button = new Button(parent, 2);
        button.setText(">");
        button.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (button.getText().equals(">")) {
                    System.out.println(text.getSize());
                    text.setSize(text.getSize().x, text.getSize().y + 40);
                    button.setText("V");
                } else {
                    text.setSize(text.getSize().x, text.getSize().y - 40);
                    button.setText(">");
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setSize(370, 230);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Iterator i = this.itemList.iterator();
            while (i.hasNext()) {
                ((SnipVarItem)i.next()).setReplacement();
            }
        }
        super.buttonPressed(buttonId);
    }

    public void setItemList(ArrayList itemList) {
        this.itemList = itemList;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

