/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.editors.actions.GenericEncloserAction;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceManager;
import org.cfeclipse.cfml.snippets.preferences.SnipExPreferencePage;
import org.cfeclipse.cfml.snippets.properties.CFMLPropertyManager;
import org.cfeclipse.cfml.snippets.util.CFPluginImages;
import org.cfeclipse.cfml.snippets.views.snips.SnipDoubleClickListener;
import org.cfeclipse.cfml.snippets.views.snips.SnipFileDialog;
import org.cfeclipse.cfml.snippets.views.snips.SnipFolderDialog;
import org.cfeclipse.cfml.snippets.views.snips.SnipKeyCombos;
import org.cfeclipse.cfml.snippets.views.snips.SnipReader;
import org.cfeclipse.cfml.snippets.views.snips.SnipTreeViewContentProvider;
import org.cfeclipse.cfml.snippets.views.snips.SnipTreeViewLabelProvider;
import org.cfeclipse.cfml.snippets.views.snips.SnipVarParser;
import org.cfeclipse.cfml.snippets.views.snips.SnipWriter;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnippetToSnipExWizard;
import org.cfeclipse.snippet.snipex.Library;
import org.cfeclipse.snippet.snipex.SnipEx;
import org.cfeclipse.snippet.snipex.Snippet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SnipTreeView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID_SNIPVIEWTREE = "org.cfeclipse.cfml.snippets.views.snips.sniptreeview";
    public static final String DREAMWEAVER_SNIP_TYPE = "Dreamweaver";
    public static final String HOMESITE_SNIP_TYPE = "Homesite";
    public static final String CFECLIPSE_SNIP_TYPE = "CFEclipse";
    public static final String UNKNOWN_SNIP_TYPE = "Unknown";
    public static final String DW_SNIP_EXT = "csn";
    public static final String CFE_SNIP_EXT = "xml";
    private final String SNIPPETS_HELP_CONTEXT = "org.tizen.ide.native.snippets_context";
    private Composite parent;
    protected TreeViewer treeViewer;
    protected Text text;
    protected Text preview;
    protected Label previewLabel;
    protected LabelProvider labelProvider;
    protected static IPath snipBase;
    private static GenericEncloserAction tmpAction;
    private static SnipReader snipReader;
    private String snippetType = "CFEclipse";
    MenuManager menuMgr;
    protected Action insertAction;
    protected Action createFolderAction;
    protected Action createSnippetAction;
    protected Action editSnippetAction;
    protected Action refreshSnippetsAction;
    protected Action deleteSnippetAction;
    protected Action deleteFolderAction;
    protected Action refreshSnipEx;
    protected Action exportToSnipEx;
    protected Action openSnipExPage;
    protected File root;
    private CFMLPropertyManager propertyManager = SnippetPlugin.getDefault().getPropertyManager();

    public SnipTreeView() {
        SnippetPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.propertyManager.addPropertyChangeListener(this);
        snipBase = new Path(this.propertyManager.getSnippetsPath());
        if (tmpAction == null) {
            tmpAction = new GenericEncloserAction();
        }
        if (snipReader == null) {
            snipReader = new SnipReader();
        }
    }

    public void createPartControl(Composite p) {
        this.parent = p;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent, "org.tizen.ide.native.snippets_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        this.parent.setLayout((Layout)layout);
        this.text = new Text(this.parent, 2060);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.text.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(this.parent, 4);
        this.treeViewer.setContentProvider((IContentProvider)new SnipTreeViewContentProvider(this.getRootInput()));
        this.labelProvider = new SnipTreeViewLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider, null, null));
        this.treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.previewLabel = new Label(this.parent, 64);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.previewLabel.setLayoutData((Object)gridData);
        this.previewLabel.setText("Preview");
        this.preview = new Text(this.parent, 2826);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.heightHint = 100;
        layoutData.horizontalAlignment = 4;
        this.preview.setLayoutData((Object)layoutData);
        this.createActions();
        this.createMenus();
        this.createToolbar();
        this.createContextMenu();
        this.hookListeners();
        this.treeViewer.setInput((Object)this.getRootInput());
    }

    public static Object[] getSnipExURLs() {
        String[] prefKeys = new String[]{"snipExURL1", "snipExURL2", "snipExURL3", "snipExURL4", "snipExURL5", "snipExURL6", "snipExURL7", "snipExURL8"};
        Object[] snipex = new Object[]{};
        CFMLPreferenceManager pm = SnippetPlugin.getDefault().getPreferenceManager();
        int i = 0;
        while (i < prefKeys.length) {
            String url = pm.getStringPref(prefKeys[i]);
            if (url.trim().length() > 0) {
                try {
                    Object[] temp = new Object[]{new SnipEx(new URL(url), false)};
                    snipex = SnipTreeView.appendArrays(snipex, temp);
                }
                catch (MalformedURLException e) {
                    System.err.println("Snipex URL failed:" + e);
                }
                catch (Exception e) {
                    System.err.println("Snipex failed to load:" + e);
                }
            }
            ++i;
        }
        return snipex;
    }

    public static Object[] appendArrays(Object[] array1, Object[] array2) {
        Object[] newArray = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    protected void hookListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    SnipTreeView.this.text.setText("");
                    SnipTreeView.this.preview.setText("");
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer("");
                    StringBuffer toPreview = new StringBuffer("");
                    Object element = selection.getFirstElement();
                    SnipTreeView.this.text.setText("");
                    SnipTreeView.this.preview.setText("");
                    if (element instanceof File) {
                        File selectedfile = (File)selection.getFirstElement();
                        if (selectedfile.isDirectory()) {
                            return;
                        }
                        String f = selectedfile.getAbsolutePath();
                        try {
                            snipReader.read(f);
                            toShow.append(snipReader.getSnipDescription());
                            toPreview.append(String.valueOf(snipReader.getSnipStartBlock()) + snipReader.getSnipEndBlock());
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        SnipTreeView.this.preview.setText(toPreview.toString());
                    } else if (element instanceof SnipEx) {
                        SnipEx sx = (SnipEx)element;
                        SnipTreeView.this.text.setText(sx.toString());
                        SnipTreeView.this.preview.setText(sx.getSource().toString());
                    } else if (element instanceof Library) {
                        Library lib = (Library)element;
                        SnipTreeView.this.text.setText(lib.getName());
                        SnipTreeView.this.preview.setText(lib.getDescription());
                    } else if (element instanceof Snippet) {
                        Snippet snip = (Snippet)element;
                        SnipTreeView.this.text.setText(snip.getDescription());
                        SnipTreeView.this.preview.setText(String.valueOf(snip.getStartText()) + snip.getEndText());
                    }
                }
            }
        });
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new SnipDoubleClickListener(this));
    }

    protected void createActions() {
        this.openSnipExPage = new Action("Edit SnipEx Servers", CFPluginImages.getImageRegistry().getDescriptor("snipex.png")){

            public void run() {
                SnipExPreferencePage page = new SnipExPreferencePage();
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(SnipTreeView.this.getSite().getShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }
        };
        this.refreshSnipEx = new Action("Refresh SnipEx Server", CFPluginImages.getImageRegistry().getDescriptor("refresh.gif")){

            public void run() {
                System.out.println("Refreshing the snipex server");
            }
        };
        this.insertAction = new Action("Insert", CFPluginImages.getImageRegistry().getDescriptor("snip.gif")){

            public void run() {
                SnipTreeView.this.insertItem();
            }
        };
        this.insertAction.setToolTipText("Insert the selected snip into the document");
        this.createFolderAction = new Action("Create Folder", CFPluginImages.getImageRegistry().getDescriptor("package.gif")){

            public void run() {
                SnipTreeView.this.createSnipFolder();
            }
        };
        this.createFolderAction.setToolTipText("Create a new snip package");
        this.createSnippetAction = new Action("Create Snippet", CFPluginImages.getImageRegistry().getDescriptor("add.gif")){

            public void run() {
                SnipTreeView.this.createSnippet();
            }
        };
        this.createSnippetAction.setToolTipText("Create a new snip");
        this.editSnippetAction = new Action("Edit Snippet", CFPluginImages.getImageRegistry().getDescriptor("edit.gif")){

            public void run() {
                SnipTreeView.this.editSnippet();
            }
        };
        this.editSnippetAction.setToolTipText("Edit the selected snip");
        this.refreshSnippetsAction = new Action("Refresh Snippets", CFPluginImages.getImageRegistry().getDescriptor("refresh.gif")){

            public void run() {
                SnipTreeView.this.reloadSnippets();
            }
        };
        this.refreshSnippetsAction.setToolTipText("Refresh snip view");
        this.deleteSnippetAction = new Action("Delete Snippet", CFPluginImages.getImageRegistry().getDescriptor("remove.gif")){

            public void run() {
                SnipTreeView.this.deleteSnippet();
            }
        };
        this.deleteSnippetAction.setToolTipText("Delete selected snip");
        this.deleteFolderAction = new Action("Delete Folder", CFPluginImages.getImageRegistry().getDescriptor("delete.gif")){

            public void run() {
                SnipTreeView.this.deleteSnipFolder();
            }
        };
        this.deleteFolderAction.setToolTipText("Delete selected snip package (must be empty)");
        this.exportToSnipEx = new Action("Export to SnipEx server", CFPluginImages.getImageRegistry().getDescriptor("export_wiz.gif")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)SnipTreeView.this.treeViewer.getSelection();
                File selectedfile = (File)selection.getFirstElement();
                Shell shell = SnipTreeView.this.getSite().getShell();
                SnippetToSnipExWizard wizard = new SnippetToSnipExWizard(selectedfile);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        this.exportToSnipEx.setToolTipText("Export the selected snippet to a SnipX Server");
    }

    protected void createMenus() {
        IMenuManager rootMenuManager = this.getViewSite().getActionBars().getMenuManager();
        rootMenuManager.add((IAction)this.refreshSnippetsAction);
        rootMenuManager.add((IAction)this.insertAction);
        rootMenuManager.add((IAction)this.createSnippetAction);
        rootMenuManager.add((IAction)this.editSnippetAction);
        rootMenuManager.add((IAction)this.deleteSnippetAction);
        rootMenuManager.add((IAction)this.createFolderAction);
        rootMenuManager.add((IAction)this.deleteFolderAction);
        rootMenuManager.add((IAction)this.openSnipExPage);
    }

    private void createContextMenu() {
        this.menuMgr = new MenuManager();
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SnipTreeView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        File selectedFile = this.getSelectedFile();
        if (selectedFile.isDirectory()) {
            mgr.add((IAction)this.createFolderAction);
            mgr.add((IAction)this.createSnippetAction);
            String[] files = selectedFile.list();
            if (files.length == 0) {
                mgr.add((IAction)this.deleteFolderAction);
            }
        } else {
            mgr.add((IAction)this.insertAction);
            mgr.add((IAction)this.editSnippetAction);
            mgr.add((IAction)this.deleteSnippetAction);
            mgr.add((IAction)this.exportToSnipEx);
        }
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void createToolbar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.refreshSnippetsAction);
        toolbarManager.add((IAction)this.insertAction);
        toolbarManager.add((IAction)this.createSnippetAction);
        toolbarManager.add((IAction)this.editSnippetAction);
        toolbarManager.add((IAction)this.deleteSnippetAction);
        toolbarManager.add((IAction)this.createFolderAction);
        toolbarManager.add((IAction)this.deleteFolderAction);
    }

    public File getRootInput() {
        return snipBase.toFile();
    }

    protected void insertItem() {
        IEditorPart iep = this.getViewSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (iep == null) {
            return;
        }
        tmpAction.setActiveEditor(null, iep);
        Object element = null;
        String startBlock = null;
        String endBlock = null;
        if (this.treeViewer.getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        element = selection.getFirstElement();
        if (element instanceof File) {
            File selectedfile = (File)element;
            if (selectedfile.isDirectory()) {
                return;
            }
            snipReader.read(selectedfile.getAbsolutePath());
            try {
                IFile activeFile = null;
                if (iep.getEditorInput() instanceof IFileEditorInput) {
                    activeFile = ((IFileEditorInput)iep.getEditorInput()).getFile();
                }
                startBlock = SnipVarParser.parse(snipReader.getSnipStartBlock(), activeFile, this.getViewSite().getShell());
                endBlock = SnipVarParser.parse(snipReader.getSnipEndBlock(), activeFile, this.getViewSite().getShell());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else if (element instanceof Snippet) {
            IFile activeFile = null;
            if (iep.getEditorInput() instanceof IFileEditorInput) {
                activeFile = ((IFileEditorInput)iep.getEditorInput()).getFile();
            }
            Snippet snip = (Snippet)element;
            startBlock = SnipVarParser.parse(snip.getStartText(), activeFile, this.getViewSite().getShell());
            endBlock = SnipVarParser.parse(snip.getEndText(), activeFile, this.getViewSite().getShell());
        }
        if (startBlock != null && endBlock != null) {
            tmpAction.setEnclosingStrings(startBlock, endBlock);
            tmpAction.run(null);
            iep.setFocus();
        }
    }

    private File getSelectedFile() {
        File selectedfile = null;
        if (this.treeViewer.getSelection().isEmpty()) {
            selectedfile = this.getRootInput();
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            selectedfile = (File)selection.getFirstElement();
            this.treeViewer.setExpandedState(selection.getFirstElement(), true);
        }
        return selectedfile;
    }

    protected void reloadSnippets() {
        String dir;
        File cacheFolder;
        MessageBox warndialog = new MessageBox(this.getViewSite().getShell(), 200);
        warndialog.setMessage("Also delete SnipEx cached snippets?");
        int response = warndialog.open();
        if (response == 64 && (cacheFolder = new File(dir = String.valueOf(SnippetPlugin.getDefault().getStateLocation().toString()) + "/snipex")).exists() && cacheFolder.isDirectory()) {
            String[] list = cacheFolder.list();
            int i = 0;
            while (i < list.length) {
                File cacheFile = new File(String.valueOf(dir) + File.separatorChar + list[i]);
                boolean delete = cacheFile.delete();
                System.out.println("deleting " + cacheFile + " " + delete);
                ++i;
            }
        }
        snipBase = new Path(this.propertyManager.getSnippetsPath());
        this.treeViewer.setInput((Object)this.getRootInput());
    }

    protected void createSnipFolder() {
        File selectedfile = this.getSelectedFile();
        if (!selectedfile.isDirectory()) {
            selectedfile = selectedfile.getParentFile();
        }
        SnipWriter writer = new SnipWriter(selectedfile, this.snippetType, snipBase);
        SnipFolderDialog folderDialog = new SnipFolderDialog(this.getViewSite().getShell(), writer, this.treeViewer);
        folderDialog.open();
    }

    protected void deleteSnipFolder() {
        File selectedfile = this.getSelectedFile();
        if (!selectedfile.isDirectory()) {
            selectedfile = selectedfile.getParentFile();
        }
        MessageBox deleteDialog = new MessageBox(this.getViewSite().getShell(), 192);
        if (selectedfile.listFiles().length > 0) {
            MessageBox warndialog = new MessageBox(this.getViewSite().getShell(), 8);
            warndialog.setMessage("You must delete the snippets in this folder first");
        } else {
            deleteDialog.setMessage("Are you sure you want to delete this folder?");
            if (deleteDialog.open() == 64) {
                selectedfile.delete();
                this.reloadSnippets();
            }
        }
    }

    protected void createSnippet() {
        File selectedfile = this.getSelectedFile();
        if (!selectedfile.isDirectory()) {
            selectedfile = selectedfile.getParentFile();
        }
        this.snippetType = CFECLIPSE_SNIP_TYPE;
        SnipWriter writer = new SnipWriter(selectedfile, this.snippetType, snipBase);
        SnipFileDialog snippetDialog = new SnipFileDialog(this.getViewSite().getShell(), writer, this.treeViewer, "", "", "", "", "", false, "cfm");
        snippetDialog.open();
    }

    protected void deleteSnippet() {
        File selectedfile = this.getSelectedFile();
        if (selectedfile.isDirectory()) {
            return;
        }
        MessageBox deleteDialog = new MessageBox(this.getViewSite().getShell(), 192);
        deleteDialog.setMessage("Are you sure you want to delete this snippet?");
        if (deleteDialog.open() == 64) {
            selectedfile.delete();
            this.reloadSnippets();
        }
    }

    protected void editSnippet() {
        File selectedfile = this.getSelectedFile();
        if (selectedfile.isDirectory()) {
            return;
        }
        File parentDirectory = selectedfile.getParentFile();
        String f = selectedfile.getAbsolutePath().toLowerCase();
        this.snippetType = f.endsWith(DW_SNIP_EXT) ? DREAMWEAVER_SNIP_TYPE : CFECLIPSE_SNIP_TYPE;
        snipReader.read(f);
        SnipKeyCombos keyCombos = new SnipKeyCombos();
        String filepath = selectedfile.getAbsolutePath().replaceAll("\\\\", "/");
        String basePath = snipBase.toString();
        String relativePath = filepath.replaceFirst(basePath, "");
        String snippetName = selectedfile.getName().substring(0, selectedfile.getName().length() - 4);
        String snippetKeyCombo = keyCombos.getSequence(relativePath);
        String snippetDescription = snipReader.getSnipDescription();
        String snippetStartText = snipReader.getSnipStartBlock();
        String snippetEndText = snipReader.getSnipEndBlock();
        boolean isTemplate = snipReader.isFileTemplate();
        String templateExtension = snipReader.getTemplateExtension();
        SnipWriter writer = new SnipWriter(parentDirectory, this.snippetType, snipBase);
        SnipFileDialog snippetDialog = new SnipFileDialog(this.getViewSite().getShell(), writer, this.treeViewer, snippetName, snippetKeyCombo, snippetDescription, snippetStartText, snippetEndText, isTemplate, templateExtension);
        snippetDialog.open();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("_snippetsPath")) {
            snipBase = new Path(event.getNewValue().toString());
            this.treeViewer.setInput((Object)this.getRootInput());
        }
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }
}

