/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.File;
import java.io.FileFilter;
import org.cfeclipse.cfml.snippets.views.snips.SnipTreeView;
import org.cfeclipse.cfml.snippets.views.snips.SnippetFileFilter;
import org.cfeclipse.snippet.snipex.Library;
import org.cfeclipse.snippet.snipex.SnipEx;
import org.cfeclipse.snippet.snipex.Snippet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SnipTreeViewContentProvider
implements ITreeContentProvider {
    protected static Object[] EMPTY_ARRAY = new Object[0];
    protected static FileFilter snippetfilter = new SnippetFileFilter();
    protected TreeViewer viewer;
    protected File rootdir;

    public SnipTreeViewContentProvider(File root) {
        this.rootdir = root;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof File) {
            if (((File)parentElement).isDirectory()) {
                if (parentElement.equals(this.rootdir)) {
                    Object[] files = ((File)parentElement).listFiles(snippetfilter);
                    Object[] snipex = SnipTreeView.getSnipExURLs();
                    if (files.length == 0 && snipex.length == 0) {
                        System.out.println("Found " + files.length + " snippets in " + this.rootdir);
                    }
                    System.out.println("Found " + files.length + " snippets in root");
                    return SnipTreeView.appendArrays(files, snipex);
                }
                Object[] files = ((File)parentElement).listFiles(snippetfilter);
                return files;
            }
        } else if (parentElement instanceof Library || parentElement instanceof SnipEx) {
            Library lib = (Library)parentElement;
            return SnipTreeView.appendArrays(lib.getLibraries().toArray(), lib.getSnippets().toArray());
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof File && !element.equals(this.rootdir)) {
            return ((File)element).getParentFile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SnipEx || element instanceof Library) {
            return true;
        }
        if (element instanceof Snippet) {
            return false;
        }
        Object[] children = this.getChildren(element);
        if (children != null) {
            return children.length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }
}

