/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.cfml.snippets.net.ClientHttpRequest;
import org.cfeclipse.cfml.snippets.util.ResourceUtils;
import org.cfeclipse.cfml.snippets.views.snips.SnipReader;
import org.cfeclipse.cfml.snippets.views.snips.SnippetObject;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnippetToSnipExCategoryPage;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnippetToSnipExDescriptionPage;
import org.cfeclipse.snippet.snipex.Library;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SnippetToSnipExWizard
extends Wizard
implements IExportWizard {
    private Log logger = LogFactory.getLog(SnippetToSnipExWizard.class);
    private File snippetFile;
    private SnippetToSnipExDescriptionPage descriptionPage;
    private SnippetToSnipExCategoryPage categoryPage;
    private SnippetObject snippet;

    public SnippetToSnipExWizard(File selectedfile) {
        this.snippetFile = selectedfile;
        SnipReader reader = new SnipReader();
        reader.read(this.snippetFile.getAbsolutePath());
        this.snippet = reader.getSnippet();
        this.logger.debug((Object)("The snippet is: " + this.snippet));
    }

    public void addPages() {
        this.descriptionPage = new SnippetToSnipExDescriptionPage("Select the SnipEx server", this.snippet);
        this.addPage((IWizardPage)this.descriptionPage);
        this.categoryPage = new SnippetToSnipExCategoryPage("Select a category to export your snippet to");
        this.addPage((IWizardPage)this.categoryPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        selection.getFirstElement();
    }

    public boolean performFinish() {
        this.logger.debug((Object)"Performing the finish");
        ITreeSelection selection = (ITreeSelection)this.categoryPage.getCategoryTree().getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof Library) {
            Library cfr_ignored_0 = (Library)firstElement;
            String username = this.descriptionPage.getUserName();
            String useremail = this.descriptionPage.getUserEmail();
            String snippetName = this.descriptionPage.getSnippetName();
            String snippetDescription = this.descriptionPage.getSnippetDescription();
            String snippetStartBlock = this.snippet.getStartBlock();
            String snippetEndBlock = this.snippet.getEndBlock();
            String snipExServer = String.valueOf(this.descriptionPage.getServerList().getText()) + "?method=submitSnippet";
            String libraryID = this.categoryPage.getCategoryID();
            HashMap<String, String> postMap = new HashMap<String, String>();
            postMap.put("username", username);
            postMap.put("useremail", useremail);
            postMap.put("snippetname", snippetName);
            postMap.put("snippetdescription", snippetDescription);
            postMap.put("snippetstartblock", snippetStartBlock);
            postMap.put("snippetendblock", snippetEndBlock);
            postMap.put("libraryid", libraryID);
            String message = "";
            try {
                String stringFromInputStream;
                ClientHttpRequest request = new ClientHttpRequest(snipExServer);
                InputStream stream = request.post(postMap);
                message = stringFromInputStream = ResourceUtils.getStringFromInputStream(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
                message = e.getMessage();
            }
            MessageBox msg = new MessageBox(this.getShell());
            msg.setMessage(message.trim());
            msg.setText("Export Snippet to SnipEx server:");
            msg.open();
        }
        return true;
    }

    public SnippetToSnipExDescriptionPage getDescriptionPage() {
        return this.descriptionPage;
    }
}

