/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.HTMLPrinter;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.cdt.ui.text.IHoverHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.tizen.nativecommon.apihover.FunctionSummary;
import org.tizen.nativecommon.apihover.IndexFinder;
import org.tizen.nativecommon.apihover.InformationControlCreator;
import org.tizen.nativecommon.apihover.Item;
import org.tizen.nativecommon.apihover.doxygen.DoxygenHandler;

public class NativeLibHover
extends AbstractCEditorTextHover
implements ICHelpProvider {
    private IEditorPart fEditor;
    private IndexFinder indexFinder = IndexFinder.getInstance();

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion region) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new InformationControlCreator();
    }

    public String getHoverInfo2(ITextViewer viewer, IRegion region) {
        IASTName node;
        String expression;
        block22: {
            block21: {
                if (this.getEditor() == null) {
                    return "";
                }
                expression = null;
                try {
                    expression = viewer.getDocument().get(region.getOffset(), region.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return "";
                }
                expression = expression.trim();
                if (expression.length() == 0) {
                    return "";
                }
                IEditorInput editorInput = this.getEditor().getEditorInput();
                IWorkingCopy translationUnit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
                try {
                    ICElement icElement = translationUnit.getElement(expression);
                    if (icElement != null) {
                        return null;
                    }
                }
                catch (CModelException cModelException) {
                    return "";
                }
                try {
                    IASTTranslationUnit astUnit = translationUnit.getAST(null, 6);
                    IASTNodeSelector nodeSelector = astUnit.getNodeSelector(astUnit.getFilePath());
                    node = nodeSelector.findName(region.getOffset(), region.getLength());
                    if (node != null) break block21;
                    return "";
                }
                catch (CoreException coreException) {
                    return "";
                }
            }
            if (!(node.getParent() instanceof CASTDeclarator) && !(node.getParent() instanceof CPPASTDeclarator)) break block22;
            return "";
        }
        if (node.getParent() instanceof CASTFieldReference || node.getParent() instanceof CPPASTFieldReference) {
            return "";
        }
        Item item = this.indexFinder.getItem(expression);
        if (item != null) {
            return String.valueOf(this.indexFinder.getPathEntry(item)) + item.getUrl();
        }
        IRegion hoverRegion = region;
        HoverHelpInvocationContext context = new HoverHelpInvocationContext(hoverRegion);
        IFunctionSummary fs = CHelpProviderManager.getDefault().getFunctionInfo((ICHelpInvocationContext)context, expression);
        if (fs != null) {
            IRequiredInclude[] incs;
            StringBuilder buffer = new StringBuilder();
            buffer.append("<html>\n");
            buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/xhtml;charset=UTF-8\"/>\n");
            buffer.append("<link href=\"file://" + DoxygenHandler.getCSSParentPath() + "/tabs.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
            buffer.append("<link href=\"file://" + DoxygenHandler.getCSSParentPath() + "/doxygen.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
            buffer.append("\n");
            buffer.append("<body>\n");
            buffer.append("<div class=\"memitem\">\n");
            buffer.append("<div class=\"memproto\">\n");
            buffer.append("      <table class=\"memname\">\n");
            buffer.append("        <tr>\n");
            IFunctionSummary.IFunctionPrototypeSummary prototype = fs.getPrototype();
            if (prototype != null) {
                buffer.append("          <td class=\"memname\">" + HTMLPrinter.convertToHTMLContent((String)prototype.getPrototypeString(false)) + "</td>");
            }
            buffer.append("       </tr>\n");
            buffer.append("      </table>\n");
            buffer.append("</div>\n");
            buffer.append("<div class=\"memdoc\">\n");
            if (fs.getDescription() != null) {
                buffer.append("<p>" + fs.getDescription() + "</p>");
            }
            if ((incs = fs.getIncludes()) != null && incs.length > 0) {
                buffer.append("<dl class=\"see\"><dt><b>Header files:</b></dt><dd>");
                int count = 0;
                IRequiredInclude[] iRequiredIncludeArray = incs;
                int n = incs.length;
                int n2 = 0;
                while (n2 < n) {
                    IRequiredInclude inc = iRequiredIncludeArray[n2];
                    buffer.append(inc.getIncludeName());
                    if (count < incs.length - 1) {
                        buffer.append(",");
                    }
                    if (count++ > 4) {
                        buffer.append(".....");
                        break;
                    }
                    ++n2;
                }
                buffer.append("</dd></dl>");
            }
            buffer.append("</div>\n");
            buffer.append("</div>\n");
            buffer.append("</body>\n");
            buffer.append("</html>\n");
            if (buffer.length() > 0) {
                return buffer.toString();
            }
        }
        return null;
    }

    public void initialize() {
    }

    public ICHelpBook[] getCHelpBooks() {
        ArrayList<ICHelpBook> helpBooks = this.indexFinder.getHelpBooks();
        ICHelpBook[] chelpbooks = new ICHelpBook[helpBooks.size()];
        return helpBooks.toArray(chelpbooks);
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        Item item;
        if (context instanceof HoverHelpInvocationContext && (item = this.indexFinder.getItem(name)) != null) {
            FunctionSummary f = new FunctionSummary();
            f.setReturnType(item.getReturnType());
            f.setPrototype(item.getPrototype());
            if (item.getNamespace() != null && !item.getNamespace().endsWith(".c")) {
                f.addIncludeFile(item.getNamespace());
            }
            f.setName(item.getName());
            return f;
        }
        return null;
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        return null;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String prefix) {
        return this.indexFinder.getItemsWithPrefix(prefix);
    }

    public Boolean isSLPHover() {
        return true;
    }

    class HoverHelpInvocationContext
    implements IHoverHelpInvocationContext {
        IRegion hoverRegion;

        public HoverHelpInvocationContext(IRegion hoverRegion) {
            this.hoverRegion = hoverRegion;
        }

        public IProject getProject() {
            ITranslationUnit unit = this.getTranslationUnit();
            if (unit != null) {
                return unit.getCProject().getProject();
            }
            return null;
        }

        public ITranslationUnit getTranslationUnit() {
            IEditorInput editorInput = NativeLibHover.this.getEditor().getEditorInput();
            return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }

        public IRegion getHoverRegion() {
            return this.hoverRegion;
        }
    }
}

