/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBCDIDebugger2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ui.TizenRemoteFileDialog;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

@Deprecated
public class TizenCoredumpDelegate
extends TizenLaunchDelegate {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String DEFAULT_CORE_DIR = TizenPlatformConstants.DEBUG_COREFILE_PATH;
    private FileEntry coreDir = null;

    @Override
    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        wc.doSave();
    }

    @Override
    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 10);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.launchApplicationWithGDBClient(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
    }

    private FileEntry getExecutable(IDevice device) {
        String oldExecutable = "/usr/bin/launchpad_preloading_preinitializing_daemon";
        String newExecutable = "/usr/bin/launchpad-loader";
        FileEntry executableFileEntry = this.currentDevice.getFileEntry(newExecutable);
        if (FileEntryType.Unknown == executableFileEntry.getType()) {
            this.logger.error("Failed to search for " + newExecutable + " , Device: " + device);
            executableFileEntry = this.currentDevice.getFileEntry(oldExecutable);
        }
        return executableFileEntry;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void launchApplicationWithGDBClient(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException {
        workingCopy = null;
        daemonPath = null;
        wasRoot = this.currentDevice.isRoot();
        try {
            monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBCLIENT, 2);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBCLIENT);
            debugConfiguration = this.getDebugConfig(config);
            strPath = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
            if (strPath != null && strPath.length() != 0) ** GOTO lbl56
            project = ProjectUtil.getProject(config);
            remotePath = this.promptForCoreFilePath(project, debugConfiguration);
            if (remotePath == null) {
                monitor.setCanceled(true);
                return;
            }
            try {
                programPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                programPath = programPath.removeLastSegments(1);
                projectPath = programPath.toPortableString();
                coreFilePath = String.valueOf(projectPath) + "/core." + project.getName();
                isSuccess = false;
                try {
                    isSuccess = this.downloadCoreFile(remotePath, coreFilePath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (IOException e) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_FIND_CORE_FILE, e);
                }
                if (!isSuccess) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_FIND_CORE_FILE, null);
                }
                coreFile = new File(coreFilePath.toString());
                corePath = new Path(coreFilePath.toString());
                cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
                core = this.verifyBinary(cproject, (IPath)corePath);
                if (!coreFile.canRead() || core == null || core.getType() != 16) {
                    this.newCoreException(TizenLaunchMessages.INVALID_CORE_FILE, null);
                }
                this.currentDevice.becomeSuperUser(true);
                executableFileEntry = this.getExecutable(this.currentDevice);
                daemonPath = String.valueOf(project.getLocation().toOSString()) + File.separator + "launchpad_daemon";
                try {
                    isSuccess = this.downloadLaunchpadDaemon(executableFileEntry, daemonPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (IOException e) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, e);
                }
                if (!isSuccess) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, null);
                }
                binaryPath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config).toOSString();
                targetDir = new Path(String.valueOf(project.getLocation().toOSString()) + File.separator + ProjectUtil.getDefaultConfiguration(project).getName());
                installPath = this.currentDevice.getAppInstallPath();
                targetDirFile = (targetDir = targetDir.append(installPath)).toFile();
                if (!targetDirFile.exists() && !(mkRet = targetDirFile.mkdirs())) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, null);
                }
                FileUtil.copyTo((String)binaryPath, (String)(String.valueOf(targetDir.toOSString()) + File.separator + ProjectUtil.getBinaryName(project)));
                workingCopy = config.getWorkingCopy();
                workingCopy.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", coreFilePath);
                workingCopy.doSave();
lbl56:
                // 2 sources

                if (daemonPath == null) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, null);
                }
                programPath = new Path(daemonPath);
                cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
                exeFile = null;
                if (programPath != null) {
                    exeFile = this.verifyBinary(cproject, (IPath)programPath);
                }
                if (exeFile == null) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, null);
                }
                debugger = new GDBCDIDebugger2();
                this.debugSession = debugger.createSession(launch, exeFile.getPath().toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.debugSession == null) {
                    this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, null);
                }
                targetArray = this.debugSession.getTargets();
                i = 0;
                while (i < targetArray.length) {
                    targetArray[i].getProcess();
                    project = ProjectUtil.getProject(config);
                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project, (ICDITarget)targetArray[i], (String)"Tizen debugger", null, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)"false", (boolean)true);
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (Exception e) {
                monitor.done();
                monitor.setCanceled(true);
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, e);
            }
        }
        finally {
            if (workingCopy != null) {
                workingCopy.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", "");
                workingCopy.doSave();
            }
            try {
                this.currentDevice.becomeSuperUser(wasRoot);
            }
            catch (Exception e) {
                this.logger.error("Failed to change permission of device: " + this.currentDevice + " , wasRoot: " + wasRoot, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadLaunchpadDaemon(FileEntry daemonDir, String destFilePath, IProgressMonitor monitor) throws Exception {
        if (daemonDir == null) {
            return false;
        }
        if (FileEntryType.Unknown == daemonDir.getType()) {
            this.logger.error("Failed to download " + daemonDir + " . The file doesn't exist on device" + daemonDir.getDevice());
            return false;
        }
        if (destFilePath != null) {
            SyncService syncService;
            FileOutputStream fileOut;
            block5: {
                fileOut = null;
                syncService = null;
                try {
                    fileOut = new FileOutputStream(destFilePath);
                    syncService = this.currentDevice.getSyncService();
                    SyncResult result = syncService.doPull(daemonDir, (OutputStream)fileOut, null, -1);
                    if (!result.isOk()) break block5;
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{fileOut});
                    IOUtil.tryClose((Object[])new Object[]{syncService});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{fileOut});
                IOUtil.tryClose((Object[])new Object[]{syncService});
                return true;
            }
            IOUtil.tryClose((Object[])new Object[]{fileOut});
            IOUtil.tryClose((Object[])new Object[]{syncService});
        }
        return false;
    }

    private FileEntry promptForCoreFilePath(IProject project, ICDebugConfiguration debugConfig) throws CoreException {
        Shell shell;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        if ((shell = window.getShell()) != null) {
            final String dirPath = this.getCoreFileDir();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TizenRemoteFileDialog dlg = new TizenRemoteFileDialog(shell, "Select Coredump", TizenCoredumpDelegate.this.currentDevice, false, dirPath, false);
                    if (dlg.open() == TizenRemoteFileDialog.TizenRemoteFileDialogResult.OK) {
                        TizenCoredumpDelegate.this.coreDir = dlg.getSelectedFileEntry();
                    } else {
                        TizenCoredumpDelegate.this.coreDir = null;
                    }
                }
            });
        }
        return this.coreDir;
    }

    private String getCoreFileDir() {
        String coreFileDir = null;
        try {
            coreFileDir = this.currentDevice.getEnvironmentValue("TZ_SYS_CRASH");
        }
        catch (Exception e) {
            this.logger.error("Failed to get directory in which coredump file exists", (Throwable)e);
        }
        if (coreFileDir == null) {
            coreFileDir = DEFAULT_CORE_DIR;
        }
        return coreFileDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadCoreFile(FileEntry coreDir, String destFilePath, IProgressMonitor monitor) throws Exception {
        String selectedFilePath;
        String corefilePath;
        if (coreDir == null) {
            return false;
        }
        if ("gz".equals(FilenameUtil.getExtension((String)coreDir.getName())) && (corefilePath = this.extractCoreFile(selectedFilePath = coreDir.getFullPath())) != null) {
            SyncService syncService;
            FileOutputStream fileOut;
            block4: {
                FileEntry file = this.currentDevice.getFileEntry(corefilePath);
                fileOut = null;
                syncService = null;
                try {
                    fileOut = new FileOutputStream(destFilePath);
                    syncService = this.currentDevice.getSyncService();
                    SyncResult result = syncService.doPull(file, (OutputStream)fileOut, null, -1);
                    this.removeCoreFile(corefilePath);
                    if (!result.isOk()) break block4;
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{fileOut});
                    IOUtil.tryClose((Object[])new Object[]{syncService});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{fileOut});
                IOUtil.tryClose((Object[])new Object[]{syncService});
                return true;
            }
            IOUtil.tryClose((Object[])new Object[]{fileOut});
            IOUtil.tryClose((Object[])new Object[]{syncService});
        }
        return false;
    }

    protected void verifyDeployableCoredump() throws CoreException {
        if (this.currentDevice != null && !this.currentDevice.isEmulator()) {
            LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_DEBUG_COREFILE_TO_TARGET, null);
        }
    }

    private String extractCoreFile(String gzArchivePath) throws Exception {
        String saveDir = TizenPlatformConstants.DEBUG_COREFILE_EXTRACT_TEMP_PATH;
        String coreGzFileName = String.valueOf(saveDir) + "/" + new Path(gzArchivePath).lastSegment();
        String coreFileName = FileUtil.getFileNameWithoutExtension((String)coreGzFileName);
        TizenLaunchCommand cmdLauncher = new TizenLaunchCommand(this.currentDevice);
        String cmd = String.format("cp %s %s;cd %s;gunzip -f %s; ls %s", gzArchivePath, saveDir, saveDir, coreGzFileName, coreFileName);
        cmdLauncher.run(cmd, null);
        String coreFile = cmdLauncher.getEndLine();
        if (coreFile != null && coreFile.endsWith(coreFileName)) {
            return coreFileName;
        }
        this.logger.error("Fail to get corefile due to: " + cmdLauncher.getCommandOutstream());
        return null;
    }

    private void removeCoreFile(String filePath) throws Exception {
        TizenLaunchCommand cmdLauncher = new TizenLaunchCommand(this.currentDevice);
        String cmd = "rm -r " + filePath;
        cmdLauncher.run(cmd, null);
    }
}

