/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.properties;

import java.util.ArrayList;
import java.util.HashMap;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ProjectPropertyStore
implements IPreferenceStore {
    private IProject project = null;
    private ArrayList listeners = new ArrayList();
    private HashMap props = new HashMap();
    private IPreferenceStore globalPrefs;

    public ProjectPropertyStore(IProject srcProject) {
        this();
        if (srcProject == null) {
            throw new IllegalArgumentException("ProjectPropertyStore::ProjectPropertyStore()");
        }
        this.project = srcProject;
        this.listeners = new ArrayList();
        this.props = new HashMap();
        this.globalPrefs = SnippetPlugin.getDefault().getPreferenceStore();
    }

    public ProjectPropertyStore() {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject srcProject) {
        if (srcProject == null) {
            return;
        }
        this.project = srcProject;
        for (String propName : this.props.keySet()) {
            this.putValueHandled(propName, (String)this.props.get(propName));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean contains(String name) {
        String retVal = null;
        try {
            retVal = this.project != null ? this.project.getPersistentProperty(ProjectPropertyStore.getQName(name)) : (String)this.props.get(name);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
        return retVal != null;
    }

    public static QualifiedName getQName(String name) {
        return new QualifiedName("org.cfeclipse.cfml.", name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object srcObj = this.project != null ? this.project : this.props;
        PropertyChangeEvent event = new PropertyChangeEvent(srcObj, name, oldValue, newValue);
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    private String getProperty(QualifiedName qName) {
        String retVal = null;
        try {
            retVal = this.project != null ? this.project.getPersistentProperty(qName) : (String)this.props.get(qName.getLocalName());
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public boolean getBoolean(String name) {
        if (!this.contains(name)) {
            return this.getDefaultBoolean(name);
        }
        String strVal = this.getProperty(ProjectPropertyStore.getQName(name));
        return strVal == null ? false : strVal.equals("true");
    }

    private String getDefault(String name) {
        return this.globalPrefs.getDefaultString(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.globalPrefs.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.globalPrefs.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.globalPrefs.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.globalPrefs.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.globalPrefs.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.globalPrefs.getDefaultString(name);
    }

    public double getDouble(String name) {
        if (!this.contains(name)) {
            return this.getDefaultDouble(name);
        }
        double retVal = 0.0;
        try {
            retVal = Double.parseDouble(this.getString(name));
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    public float getFloat(String name) {
        if (!this.contains(name)) {
            return this.getDefaultFloat(name);
        }
        float retVal = 0.0f;
        try {
            retVal = Float.parseFloat(this.getString(name));
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    public int getInt(String name) {
        if (!this.contains(name)) {
            return this.getDefaultInt(name);
        }
        int retVal = 0;
        try {
            retVal = Integer.parseInt(this.getString(name));
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    public long getLong(String name) {
        if (!this.contains(name)) {
            return this.getDefaultLong(name);
        }
        long retVal = 0L;
        try {
            retVal = Long.parseLong(this.getString(name));
        }
        catch (NumberFormatException numberFormatException) {}
        return retVal;
    }

    public String getString(String name) {
        String retVal = "";
        if (this.contains(name)) {
            retVal = this.getProperty(ProjectPropertyStore.getQName(name));
        }
        return retVal;
    }

    public boolean isDefault(String name) {
        if (!this.contains(name)) {
            return false;
        }
        return this.getString(name).equals(this.getDefault(name));
    }

    public boolean needsSaving() {
        return this.props.size() > 0;
    }

    private void putValueHandled(String name, String value) {
        try {
            if (this.project != null) {
                this.project.setPersistentProperty(ProjectPropertyStore.getQName(name), value);
            }
            this.props.put(name, value);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    public void putValue(String name, String value) {
        this.putValueHandled(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
    }

    public void setValue(String name, double value) {
        this.setValue(name, Double.toString(value));
    }

    public void setValue(String name, float value) {
        this.setValue(name, Float.toString(value));
    }

    public void setValue(String name, int value) {
        this.setValue(name, Integer.toString(value));
    }

    public void setValue(String name, long value) {
        this.setValue(name, Long.toString(value));
    }

    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        this.putValueHandled(name, value);
        this.firePropertyChangeEvent(name, oldValue, value);
    }

    public void setValue(String name, boolean value) {
        this.setValue(name, value ? "true" : "false");
    }
}

