/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.util.ArrayList;
import java.util.Iterator;
import org.cfeclipse.cfml.snippets.views.snips.SnipDialog;
import org.cfeclipse.cfml.snippets.views.snips.SnipVarItem;
import org.eclipse.swt.widgets.Shell;

public class SnipSmartDialog {
    public static String parse(String str, Shell shell) {
        String newStr = str;
        ArrayList<SnipVarItem> list = new ArrayList<SnipVarItem>();
        int position = 0;
        while (newStr.indexOf("$${", position) >= 0) {
            int expressionStart = newStr.indexOf("$${", position) + 3;
            int expressionEnd = newStr.indexOf("}", expressionStart);
            String expression = newStr.substring(expressionStart, expressionEnd);
            String[] stringArray = expression.split(":");
            String variable = stringArray[0];
            String defaultValue = "";
            if (stringArray.length > 1) {
                defaultValue = stringArray[1];
            }
            String[] optionValArray = defaultValue.split("\\|");
            SnipVarItem item = new SnipVarItem(variable, optionValArray, expression);
            Iterator i = list.iterator();
            boolean duplicateItem = false;
            while (i.hasNext()) {
                if (!((SnipVarItem)i.next()).getOriginal().equalsIgnoreCase(expression)) continue;
                duplicateItem = true;
            }
            if (!duplicateItem) {
                list.add(item);
            }
            position = expressionEnd;
        }
        if (list.iterator().hasNext()) {
            SnipDialog dia = new SnipDialog(shell);
            dia.setItemList(list);
            dia.setTitle("Replace  variables");
            if (dia.open() == 0) {
                try {
                    for (SnipVarItem item : list) {
                        String original = "$${" + item.getOriginal() + "}";
                        String replacement = item.getReplacement();
                        newStr = SnipSmartDialog.doReplacement(newStr, original, replacement);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                dia.close();
            } else {
                return null;
            }
        }
        return newStr;
    }

    private static String doReplacement(String oldStr, String original, String replacement) {
        StringBuffer buffer = new StringBuffer(oldStr);
        int fromOffset = 0;
        while ((fromOffset = buffer.indexOf(original, fromOffset)) >= 0) {
            buffer.replace(fromOffset, fromOffset + original.length(), replacement);
            fromOffset += replacement.length();
        }
        return buffer.toString();
    }
}

