/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.tizen.common.Cabinet;
import org.tizen.common.Messages;
import org.tizen.common.ui.TableToolTipListener;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ViewUtil;

public class SWTUtil {
    protected static final Collection<?> HTML_EXTENSIONS = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList("html", "htm", "shtml", "shtm", "xhtml")));

    public static Display getDisplay() {
        Display dp = Display.getCurrent();
        if (dp != null) {
            return dp;
        }
        return Display.getDefault();
    }

    public static Shell getActiveShell() {
        Display dp = SWTUtil.getDisplay();
        if (dp == null) {
            return null;
        }
        return dp.getActiveShell();
    }

    public static Shell getShell() {
        Shell shell = SWTUtil.getActiveShell();
        if (shell == null && SWTUtil.getDisplay() != null) {
            shell = SWTUtil.getDisplay().getShells()[0];
        }
        return shell;
    }

    public static <T> T exec(Cabinet<T> runnable) {
        SWTUtil.syncExec(runnable);
        return runnable.getData();
    }

    public static void syncExec(Runnable runnable) {
        SWTUtil.syncExec(SWTUtil.getDisplay(), runnable);
    }

    public static void syncExec(Display dp, Runnable runnable) {
        dp.syncExec(runnable);
    }

    public static void asyncExec(Runnable runnable) {
        SWTUtil.asyncExec(SWTUtil.getDisplay(), runnable);
    }

    public static void asyncExec(Display dp, Runnable runnable) {
        dp.asyncExec(runnable);
    }

    public static void tryDispose(Widget ... disposables) {
        if (disposables == null) {
            return;
        }
        Widget[] widgetArray = disposables;
        int n = disposables.length;
        int n2 = 0;
        while (n2 < n) {
            Widget disposable = widgetArray[n2];
            if (disposable != null && !disposable.isDisposed()) {
                disposable.dispose();
            }
            ++n2;
        }
    }

    public static void tryDispose(Resource ... disposables) {
        if (disposables == null) {
            return;
        }
        Resource[] resourceArray = disposables;
        int n = disposables.length;
        int n2 = 0;
        while (n2 < n) {
            Resource disposable = resourceArray[n2];
            if (disposable != null && !disposable.isDisposed()) {
                disposable.dispose();
            }
            ++n2;
        }
    }

    public static Text createNumericText(Composite composite, int style, int limit) {
        Text text = new Text(composite, style);
        text.setTextLimit(limit);
        text.addVerifyListener(new VerifyListener(){
            final Pattern pattern = Pattern.compile("[0-9]*");

            public void verifyText(VerifyEvent e) {
                Matcher m = this.pattern.matcher(e.text);
                if (!m.matches()) {
                    e.doit = false;
                }
            }
        });
        return text;
    }

    public static Text createNumericText(Composite composite, int limit) {
        return SWTUtil.createNumericText(composite, 2048, limit);
    }

    public static ScrolledComposite createScrolledComposite(Composite parent, int width, int height) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (width == 0) {
            width = screen.width;
        }
        if (height == 0) {
            height = screen.height;
        }
        sc.setMinSize(width, height);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        return sc;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = SWTUtil.getActivePage();
        if (page == null) {
            return null;
        }
        return page.getActiveEditor();
    }

    public static IEditorPart getCurrentEditor(String ext) {
        if (ext == null) {
            throw new IllegalArgumentException("extension can't be null");
        }
        IEditorPart editor = SWTUtil.getActiveEditor();
        if (editor == null || editor.getEditorInput() == null) {
            return null;
        }
        if (ext.equalsIgnoreCase(FileUtil.getFileExtension(editor.getEditorInput().getName()))) {
            return editor;
        }
        return null;
    }

    public static IEditorPart getCurrentHtmlEditor() {
        IEditorPart editor = SWTUtil.getActiveEditor();
        if (editor == null || editor.getEditorInput() == null) {
            return null;
        }
        if (SWTUtil.isHtmlFile(editor.getEditorInput().getName())) {
            return editor;
        }
        return null;
    }

    public static boolean isHtmlFile(String fullName) {
        String fileExt = StringUtil.nvl(FileUtil.getFileExtension(fullName));
        return HTML_EXTENSIONS.contains(fileExt.toLowerCase());
    }

    public static IEditorReference[] getEditorReferences() {
        IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        return page.getEditorReferences();
    }

    public static void refreshLocal(IFile file, int depth) throws CoreException {
        if (file == null || !file.exists() || !file.isAccessible()) {
            return;
        }
        if (file.isSynchronized(depth)) {
            return;
        }
        file.refreshLocal(depth, null);
    }

    public static void refreshLocal(IProject project, int depth) throws CoreException {
        if (project == null || !project.exists() || !project.isAccessible()) {
            return;
        }
        if (project.isSynchronized(depth)) {
            return;
        }
        project.refreshLocal(depth, null);
    }

    public static void refreshLocal() throws CoreException {
        IEditorPart editor = SWTUtil.getActiveEditor();
        if (editor != null && editor.getEditorInput() != null) {
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput().getAdapter(IFileEditorInput.class);
            if (input == null) {
                return;
            }
            SWTUtil.refreshLocal(input.getFile().getProject(), 2);
        }
    }

    public static String getProjectPath() {
        IEditorPart editor = SWTUtil.getActiveEditor();
        if (editor == null || editor.getEditorInput() == null) {
            return null;
        }
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput().getAdapter(IFileEditorInput.class);
        if (input == null) {
            return null;
        }
        String projectName = input.getFile().getProject().getName();
        IWorkspaceRoot workspaceRoot = IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
        String projectPath = "";
        try {
            projectPath = workspaceRoot.getProject(projectName).getLocation().toOSString();
        }
        catch (Exception exception) {
            projectPath = workspaceRoot.getLocation().toOSString();
        }
        return projectPath;
    }

    public static void addTableToolTipListener(Table table, TableToolTipListener listener) {
        listener.setTable(table);
        table.addListener(5, (Listener)listener);
        table.addListener(37, (Listener)listener);
        table.addListener(12, (Listener)listener);
        table.addListener(32, (Listener)listener);
    }

    public static void expandTree(Tree tree) {
        if (tree == null) {
            return;
        }
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeitem = treeItemArray[n2];
            SWTUtil.expandTreeItem(treeitem);
            ++n2;
        }
    }

    private static void expandTreeItem(TreeItem treeItem) {
        Stack<TreeItem> treeStack = new Stack<TreeItem>();
        treeStack.add(treeItem);
        TreeItem selectedItem = null;
        do {
            selectedItem = (TreeItem)treeStack.pop();
            selectedItem.setExpanded(true);
            if (selectedItem.getItems() == null || selectedItem.getItemCount() == 0) continue;
            TreeItem[] treeItemArray = selectedItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                treeStack.add(childItem);
                ++n2;
            }
        } while (!treeStack.isEmpty());
    }

    public static void setGridLayout(Composite composite, int numColumns, boolean equalWidth, int heightHint, int widthHint, int horizontalSpan, int verticalSpan, int style) {
        composite.setLayout((Layout)new GridLayout(numColumns, equalWidth));
        SWTUtil.setGridLayoutData((Control)composite, heightHint, widthHint, horizontalSpan, verticalSpan, style);
    }

    public static void setGridLayoutData(Control control, int heightHint, int widthHint, int horizontalSpan, int verticalSpan, int style) {
        GridData gd = new GridData(style);
        if (heightHint != -1) {
            gd.heightHint = heightHint;
        }
        if (widthHint != -1) {
            gd.widthHint = widthHint;
        }
        if (horizontalSpan != -1) {
            gd.horizontalSpan = horizontalSpan;
        }
        if (verticalSpan != -1) {
            gd.verticalSpan = verticalSpan;
        }
        control.setLayoutData((Object)gd);
    }

    public static void errorDialogWithStackTrace(String title, String msg, Throwable t, String pluginId, Shell shell) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String trace = sw.toString();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        String[] stringArray = trace.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            childStatuses.add(new Status(4, pluginId, line));
            ++n2;
        }
        MultiStatus ms = new MultiStatus(pluginId, 4, (IStatus[])childStatuses.toArray(new Status[0]), t.getLocalizedMessage(), t);
        ErrorDialog.openError((Shell)shell, (String)"Error Dialog", (String)msg, (IStatus)ms);
    }

    public static Composite createCompositeEx(Composite parent, int numColumns, int layoutMode) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        composite.setLayoutData((Object)new GridData(layoutMode));
        return composite;
    }

    public static Group createGroup(Composite parent, String label, int numColumns) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    public static void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void makeChildBackgroundTransient(final Composite parent) {
        if (parent != null) {
            final Object lock = new Object();
            final AtomicBoolean finished = new AtomicBoolean(false);
            parent.addPaintListener(new PaintListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paintControl(PaintEvent e) {
                    if (finished.get()) {
                        return;
                    }
                    Object object = lock;
                    synchronized (object) {
                        finished.set(true);
                        parent.removePaintListener((PaintListener)this);
                        if (parent.getBackgroundImage() != null) {
                            Stack<PairControl> childStack = new Stack<PairControl>();
                            Control[] controlArray = parent.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control childControl = controlArray[n2];
                                childStack.add(new PairControl(parent, childControl));
                                ++n2;
                            }
                            while (!childStack.isEmpty()) {
                                PairControl pair = (PairControl)childStack.pop();
                                Control childControl = pair.child;
                                Composite parentComposite = pair.parent;
                                Image parentImage = parentComposite.getBackgroundImage();
                                Point childLoc = childControl.getLocation();
                                if (childControl instanceof Composite) {
                                    Composite childComposite = (Composite)childControl;
                                    Control[] controlArray2 = childComposite.getChildren();
                                    int n3 = controlArray2.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Control grandChildControl = controlArray2[n4];
                                        childStack.push(new PairControl(childComposite, grandChildControl));
                                        ++n4;
                                    }
                                }
                                Point childSize = childControl.getSize();
                                if (childSize.x <= 0 || childSize.y <= 0) continue;
                                Image childImage = new Image((Device)SWTUtil.getDisplay(), childSize.x, childSize.y);
                                GC gc = new GC((Drawable)parentImage);
                                gc.copyArea(childImage, childLoc.x, childLoc.y);
                                gc.dispose();
                                childControl.setBackgroundImage(childImage);
                            }
                        }
                    }
                }

                class PairControl {
                    Composite parent;
                    Control child;

                    PairControl(Composite parent, Control child) {
                        this.parent = parent;
                        this.child = child;
                    }
                }
            });
        }
    }

    public static Combo createCombo(Composite parent, String label, String tooltip, String[] contents) {
        return SWTUtil.createCombo(parent, label, tooltip, contents, 0);
    }

    public static Combo createCombo(Composite parent, String label, String tooltip, String[] contents, int selectedIndex) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setToolTipText(tooltip);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        return SWTUtil.createCombo(parent, contents, selectedIndex);
    }

    public static Combo createCombo(Composite parent, int style, String label, String tooltip, String[] contents, int selectedIndex) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setToolTipText(tooltip);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        return SWTUtil.createCombo(parent, style, contents, selectedIndex);
    }

    public static Combo createCombo(Composite parent, String[] contents, int selectedIndex) {
        return SWTUtil.createCombo(parent, 8, contents, selectedIndex);
    }

    public static Combo createCombo(Composite parent, int style, String[] contents, int selectedIndex) {
        Combo combo = new Combo(parent, style);
        int i = 0;
        while (i < contents.length) {
            combo.add(contents[i]);
            ++i;
        }
        combo.select(selectedIndex);
        return combo;
    }

    public static <E extends Enum<E>> Combo createEnumCombo(Composite parent, String label, String tooltip, E[] values, int selectedIndex) {
        String[] contents = StringUtil.enumNameToStringArray(values);
        int i = 0;
        while (i < contents.length) {
            contents[i] = contents[i].toLowerCase();
            ++i;
        }
        return SWTUtil.createCombo(parent, label, tooltip, contents, selectedIndex);
    }

    public static <E extends Enum<E>> Combo createEnumCombo(Composite parent, E[] values, int selectedIndex) {
        String[] contents = StringUtil.enumNameToStringArray(values);
        int i = 0;
        while (i < contents.length) {
            contents[i] = contents[i].toLowerCase();
            ++i;
        }
        return SWTUtil.createCombo(parent, contents, selectedIndex);
    }

    public static Spinner createSpinner(Composite parent, String label, String tooltip) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setToolTipText(tooltip);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        Spinner s = new Spinner(parent, 2048);
        return s;
    }

    public static Spinner createSpinner(Composite parent, String label, String tooltip, int minimum, int maximum) {
        Spinner s = SWTUtil.createSpinner(parent, label, tooltip);
        s.setMaximum(maximum);
        s.setMinimum(minimum);
        return s;
    }

    public static Text createText(Composite parent, String label, String tooltip, int horizontalSpan, int verticalSpan) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setToolTipText(tooltip);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(4, 4, true, false, horizontalSpan, verticalSpan));
        return t;
    }

    public static Button createFileBrowserButton(Composite parent, final Text parentText, final String[] extensions) {
        Button button = new Button(parent, 8);
        button.setText(Messages.BrowserButtonLabel);
        button.setLayoutData((Object)new GridData(1, 2, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parentText.getShell());
                dialog.setFilterExtensions(extensions);
                String projectPath = SWTUtil.getProjectPath();
                dialog.setFilterPath(projectPath);
                dialog.setText(Messages.DialogOpenLabel);
                if (dialog.open() != null) {
                    String selectedFile = dialog.getFileName();
                    String selectedPath = dialog.getFilterPath();
                    if (!selectedPath.equals(projectPath)) {
                        StringBuilder relativePath = new StringBuilder(selectedPath.replace(String.valueOf(projectPath) + File.separator, "")).append("/").append(selectedFile);
                        parentText.setText(relativePath.toString());
                    } else {
                        parentText.setText(selectedFile);
                    }
                }
            }
        });
        return button;
    }

    public static Button createCheckbox(Composite parent, String label, String tooltip, boolean selected, boolean enabled) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        button.setSelection(selected);
        button.setEnabled(enabled);
        button.setText(label);
        button.setToolTipText(tooltip);
        return button;
    }

    public static Button createButton(Composite parent, String label, String tooltip) {
        Button button = new Button(parent, 0);
        button.setLayoutData((Object)new GridData(768));
        button.setText(label);
        button.setToolTipText(tooltip);
        return button;
    }

    public static Label createLabel(Composite parent, String text, String tooltip) {
        Label label = new Label(parent, 0);
        if (!StringUtil.isEmpty(text)) {
            label.setText(text);
        }
        if (!StringUtil.isEmpty(tooltip)) {
            label.setToolTipText(tooltip);
        }
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        return label;
    }

    public static RGB convertHexadecimalToRGB(String hexadecimal) {
        try {
            int length;
            if (!hexadecimal.startsWith("#")) {
                hexadecimal = "#" + hexadecimal;
            }
            if ((length = hexadecimal.length()) == 4) {
                int r = Integer.parseInt(hexadecimal.substring(1, 2), 16);
                int g = Integer.parseInt(hexadecimal.substring(2, 3), 16);
                int b = Integer.parseInt(hexadecimal.substring(3, 4), 16);
                return new RGB(r << 4 | r, g << 4 | g, b << 4 | b);
            }
            if (length == 7) {
                return new RGB(Integer.parseInt(hexadecimal.substring(1, 3), 16), Integer.parseInt(hexadecimal.substring(3, 5), 16), Integer.parseInt(hexadecimal.substring(5, 7), 16));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public static String convertRGBToHexadecimal(RGB rgb) {
        int red = rgb.red;
        int green = rgb.green;
        int blue = rgb.blue;
        String redHexadecimal = Integer.toHexString(red);
        String greenHexadecimal = Integer.toHexString(green);
        String blueHexadecimal = Integer.toHexString(blue);
        if (redHexadecimal.length() == 1) {
            redHexadecimal = "0" + redHexadecimal;
        }
        if (greenHexadecimal.length() == 1) {
            greenHexadecimal = "0" + greenHexadecimal;
        }
        if (blueHexadecimal.length() == 1) {
            blueHexadecimal = "0" + blueHexadecimal;
        }
        return "#" + redHexadecimal + greenHexadecimal + blueHexadecimal;
    }

    public static String getActivePerspectiveId() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        return perspective.getId();
    }

    public static String getPerspectiveId(String name) {
        IPerspectiveRegistry perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = perspectives.findPerspectiveWithLabel(name);
        return perspective != null ? perspective.getId() : null;
    }

    public static void showPerspective(String perspectiveId) throws WorkbenchException {
        if (perspectiveId != null) {
            PlatformUI.getWorkbench().showPerspective(perspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
    }

    public static Font deriveFont(Font font, int style) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontDatum = fontDataArray[n2];
            fontDatum.setStyle(fontDatum.getStyle() | style);
            ++n2;
        }
        return new Font((Device)SWTUtil.getDisplay(), fontData);
    }

    public static Region getTrimmedRegion(Image image, int alpha) {
        if (image == null) {
            return null;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        ImageData imageData = image.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        Region region = new Region();
        region.add(new Rectangle(0, 0, width, height));
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                if (alpha >= imageData.getAlpha(i, j)) {
                    region.subtract(i, j, 1, 1);
                }
                ++j;
            }
            ++i;
        }
        return region;
    }
}

