/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.File;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceConstants;
import org.cfeclipse.cfml.snippets.util.CFPluginImages;
import org.cfeclipse.cfml.snippets.views.snips.SnipKeyCombos;
import org.cfeclipse.cfml.snippets.views.snips.SnipReader;
import org.cfeclipse.snippet.snipex.Library;
import org.cfeclipse.snippet.snipex.SnipEx;
import org.cfeclipse.snippet.snipex.Snippet;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.util.StringUtil;

public class SnipTreeViewLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private SnipReader snipReader = new SnipReader();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getImage(Object element) {
        if (element instanceof File) {
            if (((File)element).isDirectory()) return CFPluginImages.get("package.gif");
            String fname = ((File)element).getName();
            if (fname.endsWith(".xml") || fname.endsWith(".XML")) {
                this.snipReader.read(((File)element).getAbsolutePath());
                if (!this.snipReader.isFileTemplate()) return CFPluginImages.get("snip.gif");
                return CFPluginImages.get("insertsnip.gif");
            }
            if (!fname.endsWith(".csn") && !fname.endsWith(".CSN")) return null;
            return CFPluginImages.get("dw.gif");
        }
        if (element instanceof SnipEx || element instanceof Library) {
            return CFPluginImages.get("package_sx.png");
        }
        if (!(element instanceof Snippet)) return null;
        Snippet snip = (Snippet)element;
        if (!snip.isTemplate()) return CFPluginImages.get("snip.gif");
        return CFPluginImages.get("insertsnip.gif");
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }

    public void dispose() {
    }

    public StyledString getStyledText(Object element) {
        StyledString str = new StyledString("");
        if (element instanceof File) {
            String fname = ((File)element).getName();
            if (!((File)element).isDirectory()) {
                SnipKeyCombos keyCombos = new SnipKeyCombos();
                String key = StringUtil.removeStart((String)((File)element).getAbsolutePath(), (String)CFMLPreferenceConstants.SNIPPETS_PATH);
                key = key.replace('\\', '/');
                String trigger = keyCombos.getSequence(key);
                String description = String.valueOf(fname.substring(0, fname.length() - 4)) + (trigger == null ? "" : " [" + trigger + "]");
                str.append(description);
                int index = description.lastIndexOf(91);
                if (index != -1) {
                    str.setStyle(index, description.length() - index, StyledString.DECORATIONS_STYLER);
                }
            } else {
                str.append(fname);
            }
        }
        return str;
    }
}

