/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.snippet.snipex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.snippet.snipex.Library;
import org.cfeclipse.snippet.snipex.Snippet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LibraryHandler
extends DefaultHandler {
    private boolean isStackReadyForText = false;
    private Library library;
    private Library currentLibrary;
    private Snippet currentSnippet;
    private StringBuffer currentString;
    private long maxCacheAge = 604800000L;

    public LibraryHandler(Library l, boolean fullReload) {
        this.library = l;
        this.library.setLibraries(new Vector());
        this.library.setSnippets(new Vector());
        try {
            URL src;
            String query;
            String dir = String.valueOf(SnippetPlugin.getDefault().getStateLocation().toString()) + "/snipex";
            File cacheFolder = new File(dir);
            if (!cacheFolder.exists()) {
                cacheFolder.mkdir();
            }
            File cache = (query = (src = this.library.getSource()).getQuery()) != null ? new File(String.valueOf(dir) + "/lib." + src.getHost() + src.getPath().replace('/', '.') + "." + query.replace('&', '.').replace('=', '_') + ".xml") : new File(String.valueOf(dir) + "/lib." + src.getHost() + src.getPath().replace('/', '.') + ".xml");
            System.out.println(cache);
            long age = new Date().getTime() - cache.lastModified();
            if (!cache.exists() || age > this.maxCacheAge || fullReload) {
                int x;
                URLConnection connection = this.library.getSource().openConnection();
                FileOutputStream output = new FileOutputStream(cache);
                InputStreamReader stream = new InputStreamReader(connection.getInputStream());
                while ((x = stream.read()) != -1) {
                    output.write(x);
                }
                output.close();
                stream.close();
            }
            FileInputStream input = new FileInputStream(cache);
            SAXParserFactory tSaxParserFact = SAXParserFactory.newInstance();
            SAXParser tSAXParser = tSaxParserFact.newSAXParser();
            XMLReader xr = tSAXParser.getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.parse(new InputSource(input));
        }
        catch (Exception e) {
            System.err.println("LibraryHandler failed:" + this.library.getSource() + " - " + e);
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (qName.equalsIgnoreCase("snipex")) {
            this.library.setName(atts.getValue("name"));
        } else if (qName.equalsIgnoreCase("library") && !atts.getValue("id").equals(this.library.getID())) {
            this.currentLibrary = new Library();
            this.currentLibrary.setName(atts.getValue("name"));
            this.currentLibrary.setID(atts.getValue("id"));
            try {
                String lurl = this.library.getSource().toString();
                if (lurl.indexOf(63) > 0) {
                    lurl = lurl.substring(0, lurl.indexOf(63));
                }
                URL u = new URL(String.valueOf(lurl) + "?libid=" + atts.getValue("id"));
                this.currentLibrary.setSource(u);
            }
            catch (MalformedURLException malformedURLException) {}
            this.currentString = new StringBuffer();
            this.isStackReadyForText = true;
            this.library.addLibrary(this.currentLibrary);
        } else if (qName.equalsIgnoreCase("snippet")) {
            this.currentSnippet = new Snippet();
            this.currentSnippet.setID(atts.getValue("id"));
            this.currentSnippet.setTemplate(Boolean.valueOf(atts.getValue("template")));
            this.isStackReadyForText = false;
            this.library.addSnippet(this.currentSnippet);
        } else if (qName.equalsIgnoreCase("name") || qName.equalsIgnoreCase("help") || qName.equalsIgnoreCase("description") || qName.equalsIgnoreCase("starttext") || qName.equalsIgnoreCase("endtext") || qName.equalsIgnoreCase("author") || qName.equalsIgnoreCase("platforms") || qName.equalsIgnoreCase("lastupdated")) {
            this.currentString = new StringBuffer();
            this.isStackReadyForText = true;
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equalsIgnoreCase("library") && this.currentLibrary != null) {
            this.currentLibrary.setDescription(this.currentString.toString().trim());
            this.currentLibrary = null;
        } else if (this.currentSnippet != null) {
            if (qName.equalsIgnoreCase("name")) {
                this.currentSnippet.setName(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("help")) {
                this.currentSnippet.setHelp(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("description")) {
                this.currentSnippet.setDescription(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("starttext")) {
                this.currentSnippet.setStartText(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("endtext")) {
                this.currentSnippet.setEndText(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("author")) {
                this.currentSnippet.setAuthor(this.currentString.toString().trim());
            } else if (qName.equalsIgnoreCase("platforms")) {
                String p = this.currentString.toString().trim();
                this.currentSnippet.setPlatforms(p, ",");
            }
        }
        this.isStackReadyForText = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.isStackReadyForText) {
            this.currentString.append(ch, start, length);
        }
    }
}

