/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.log.Level;
import org.tizen.common.util.log.UserLogger;

public class GoogleAnalyticAppender
extends AppenderSkeleton {
    private boolean isUsage = false;
    private boolean isPerform = false;
    static final String URL_GOOGLE_ANALYTIC = "http://www.google-analytics.com/collect";
    private static final int MAX_STACK_TRACE = 2;
    private static final String KEY_ANALYTIC_VER = "v";
    private static final String KEY_TRACKING_ID = "tid";
    private static final String KEY_CLIENT_ID = "cid";
    private static final String KEY_HIT_TYPE = "t";
    private static final String KEY_APP_NAME = "an";
    private static final String KEY_APP_VER = "av";
    private static final String KEY_CONTENT_DES = "cd";
    private static final String KEY_EVENT_CATEGORY = "ec";
    private static final String KEY_EVENT_ACTION = "ea";
    private static final String KEY_PERFORM_CATEGORY = "utc";
    private static final String KEY_PERFORM_VARIABLE = "utv";
    private static final String KEY_PERFORM_TIME = "utt";
    private static final String KEY_EXCEPTION = "exd";
    private static final String KEY_FATAL = "exf";
    private static final String VALUE_ANALYTIC_VER = "1";
    private static final String VALUE_TRACKING_ID = "UA-33537119-1";
    private static final String VALUE_CLIENT_ID = ObjectUtil.generateGUID(GoogleAnalyticAppender.class);
    private static final String VALUE_APP_NAME = "tizen-ide";
    private static final String VALUE_APP_VER = "dev";
    private static final String VALUE_HIT_TYPE_TIMING = "timing";
    private static final String VALUE_HIT_TYPE_EVENT = "event";
    private static final String VALUE_HIT_TYPE_APP = "appview";
    int rc;

    public GoogleAnalyticAppender(boolean isUsage, boolean isPerform) {
        this(isUsage, isPerform, (Layout)new EnhancedPatternLayout("[%d{yyyy.MM.dd HH:mm:ss}][%-5p] %F(%L) - %m%n"));
    }

    public GoogleAnalyticAppender(boolean isUsage, boolean isPerform, Layout layout) {
        this.setName("TIZEN_GOOGLE_APPENDER");
        this.isUsage = isUsage;
        this.isPerform = isPerform;
        this.setLayout(layout);
    }

    public void setUsage(boolean isUsage) {
        this.isUsage = isUsage;
    }

    public void setPerform(boolean isPerform) {
        this.isPerform = isPerform;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected String assembly(String key, String value) throws UnsupportedEncodingException {
        return String.valueOf(URLEncoder.encode(key, "utf-8")) + "=" + URLEncoder.encode(value, "utf-8");
    }

    protected String join(String ... props) {
        StringBuilder buffer = new StringBuilder(1000);
        int i = 0;
        int n = props.length;
        while (i < n) {
            if (i != 0) {
                buffer.append("&");
            }
            String prop = props[i];
            buffer.append(prop);
            ++i;
        }
        return buffer.toString();
    }

    protected void append(LoggingEvent event) {
        try {
            this.rc = 0;
            ArrayList<String> result = new ArrayList<String>();
            try {
                if (!this.assembleString(result, event)) {
                    return;
                }
            }
            catch (UnsupportedEncodingException e) {
                LogLog.error((String)"Exception occurred while creating google analytic message", (Throwable)e);
                return;
            }
            String resultData = this.join(result.toArray(new String[result.size()]));
            try {
                URL u = new URL(URL_GOOGLE_ANALYTIC);
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                try {
                    con.setDoOutput(true);
                    OutputStream out = con.getOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(out);
                    writer.write(resultData);
                    writer.flush();
                    this.rc = con.getResponseCode();
                    if (200 <= this.rc && this.rc < 300) {
                        LogLog.debug((String)"Send log data to google analytic");
                    }
                }
                finally {
                    con.disconnect();
                }
            }
            catch (MalformedURLException e) {
                LogLog.debug((String)String.format("Malformed URL: %s", URL_GOOGLE_ANALYTIC), (Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                LogLog.debug((String)"Exception occurred while transmitting google analytic data.", (Throwable)e);
            }
        }
        catch (Throwable t) {
            LogLog.error((String)MessageFormat.format("Exception occurred while logging message: {0}", event.getMessage()), (Throwable)t);
        }
    }

    private boolean assembleString(ArrayList<String> result, LoggingEvent event) throws UnsupportedEncodingException {
        org.apache.log4j.Level level = event.getLevel();
        if (level == Level.PERFORM_END) {
            if (!this.isPerform) {
                return false;
            }
            UserLogger.PerformanceInfo perform = (UserLogger.PerformanceInfo)event.getMessage();
            this.addPerformPreVariables(result, perform);
            result.add(this.assembly(KEY_PERFORM_TIME, perform.getPerformanceString()));
        } else if (level == Level.PERFORM_START) {
            if (!this.isPerform) {
                return false;
            }
            UserLogger.PerformanceInfo perform = (UserLogger.PerformanceInfo)event.getMessage();
            this.addPerformPreVariables(result, perform);
        } else if (level == Level.PAGE) {
            if (!this.isUsage) {
                return false;
            }
            this.addPageVariable(result, (UserLogger.Page)event.getMessage());
        } else if (level == Level.EVENT) {
            if (!this.isUsage) {
                return false;
            }
            this.addEventVariable(result, (UserLogger.Event)event.getMessage());
        } else {
            result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_APP));
        }
        this.addBasicInfo(result, event);
        return true;
    }

    private void addPageVariable(ArrayList<String> result, UserLogger.Page page) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_EVENT));
        result.add(this.assembly(KEY_EVENT_CATEGORY, page.getCategory()));
    }

    private void addEventVariable(ArrayList<String> result, UserLogger.Event event) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_EVENT));
        result.add(this.assembly(KEY_EVENT_CATEGORY, event.getCategory()));
        result.add(this.assembly(KEY_EVENT_ACTION, event.getAction()));
    }

    private void addPerformPreVariables(ArrayList<String> result, UserLogger.PerformanceInfo performanceInfo) throws UnsupportedEncodingException {
        result.add(this.assembly(KEY_HIT_TYPE, VALUE_HIT_TYPE_TIMING));
        result.add(this.assembly(KEY_PERFORM_CATEGORY, performanceInfo.getCategory()));
        result.add(this.assembly(KEY_PERFORM_VARIABLE, performanceInfo.getVariableName()));
    }

    private void addBasicInfo(ArrayList<String> result, LoggingEvent event) throws UnsupportedEncodingException {
        String[] tss = event.getThrowableStrRep();
        org.apache.log4j.Level level = event.getLevel();
        StringBuffer msg = new StringBuffer();
        msg.append(this.getLayout().format(event));
        if (tss != null) {
            if (level == Level.FATAL) {
                result.add(this.assembly(KEY_FATAL, "FATAL"));
            }
            StringBuffer tBuffer = new StringBuffer();
            int i = 0;
            String[] stringArray = tss;
            int n = tss.length;
            int n2 = 0;
            while (n2 < n) {
                String ts = stringArray[n2];
                if (2 <= i + 1) break;
                tBuffer.append(String.valueOf(ts) + "\n");
                ++i;
                ++n2;
            }
            result.add(this.assembly(KEY_EXCEPTION, tBuffer.toString()));
            if (this.getLayout().ignoresThrowable()) {
                msg.append(tBuffer);
            }
        }
        result.add(this.assembly(KEY_ANALYTIC_VER, VALUE_ANALYTIC_VER));
        result.add(this.assembly(KEY_TRACKING_ID, VALUE_TRACKING_ID));
        result.add(this.assembly(KEY_CLIENT_ID, VALUE_CLIENT_ID));
        result.add(this.assembly(KEY_APP_NAME, VALUE_APP_NAME));
        result.add(this.assembly(KEY_APP_VER, VALUE_APP_VER));
        result.add(this.assembly(KEY_CONTENT_DES, msg.toString()));
    }
}

