/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.preferences;

import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceConstants;
import org.cfeclipse.cfml.snippets.preferences.SnipExPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class CFMLPreferenceManager {
    private IPreferenceStore store = SnippetPlugin.getDefault().getPreferenceStore();

    public boolean getBooleanPref(String prefKey) {
        return this.store.getBoolean(prefKey);
    }

    public String getStringPref(String prefKey) {
        return this.store.getString(prefKey);
    }

    public void initializeDefaultValues() {
        CFMLPreferenceConstants.setDefaults(this.store);
        SnipExPreferenceConstants.setDefaults(this.store);
    }

    public RGB getColor(String key) {
        String rgbString = this.store.getString(key);
        if (rgbString.length() <= 0 && (rgbString = this.store.getDefaultString(key)).length() <= 0) {
            try {
                rgbString = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.err.println("Color key: " + key + " is a no show using black");
            rgbString = "0,0,0";
        }
        rgbString = this.deParen(rgbString);
        RGB newcolor = null;
        try {
            newcolor = StringConverter.asRGB((String)this.deParen(rgbString));
        }
        catch (Exception e) {
            System.err.println("Woah... got an odd color passed: " + key);
            e.printStackTrace(System.err);
        }
        return newcolor;
    }

    private String deParen(String item) {
        String d = item.replace('{', ' ').replace('}', ' ');
        d = d.replaceAll("[RGB ]", "").trim();
        return d;
    }

    public String snippetsPath() {
        return this.store.getString("_snippetsPath").trim();
    }

    public String getPluginStateLocation() {
        return SnippetPlugin.getDefault().getStateLocation().toString();
    }

    public int tabWidth() {
        System.out.println("Tab width retrieved as: " + this.store.getInt("_tabWidth"));
        return Integer.parseInt(this.store.getString("_tabWidth").trim());
    }

    public int defaultTabWidth() {
        return this.store.getDefaultInt("_tabWidth");
    }

    public boolean insertSpacesForTabs() {
        return this.store.getString("spacesForTabs").trim().equalsIgnoreCase("true");
    }

    public boolean defaultSpacesForTabs() {
        return this.store.getDefaultBoolean("spacesForTabs");
    }
}

