/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.properties;

import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.properties.CFMLPropertyManager;
import org.cfeclipse.cfml.snippets.properties.ProjectPropertyStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage {
    private static final String PATH_TITLE = "Path:";
    private static final String SNIPPETS_PATH_PROPERTY = "snippetsPath";
    private static String DEFAULT_SNIPPETS_PATH = "";
    private DirectoryFieldEditor snippetsPathField;
    private CFMLPropertyManager propertyManager = SnippetPlugin.getDefault().getPropertyManager();
    private ProjectPropertyStore propStore = new ProjectPropertyStore();

    public ProjectPropertyPage() {
        DEFAULT_SNIPPETS_PATH = this.propertyManager.defaultSnippetsPath();
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        IProject project = (IProject)this.getElement();
        this.propStore.setProject(project);
    }

    private void addPathSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(((IResource)this.getElement()).getFullPath().toString());
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSnippetsSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        this.snippetsPathField = new DirectoryFieldEditor("", "Path to snippets directory", composite);
        this.snippetsPathField.setStringValue(SNIPPETS_PATH_PROPERTY);
        try {
            String snippetsPath = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", SNIPPETS_PATH_PROPERTY));
            this.snippetsPathField.setStringValue(snippetsPath != null ? snippetsPath : DEFAULT_SNIPPETS_PATH);
        }
        catch (CoreException coreException) {
            this.snippetsPathField.setStringValue(DEFAULT_SNIPPETS_PATH);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addPathSection(composite);
        this.addSeparator(composite);
        this.addSnippetsSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.snippetsPathField.setStringValue(DEFAULT_SNIPPETS_PATH);
    }

    public boolean performOk() {
        try {
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("", SNIPPETS_PATH_PROPERTY), this.snippetsPathField.getStringValue());
            this.propertyManager.setSnippetsPath(this.snippetsPathField.getStringValue(), (IProject)this.getElement());
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }
}

