/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.views.snips;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.cfeclipse.cfml.snippets.views.snips.SnipKeyCombos;
import org.eclipse.core.runtime.IPath;

public class SnipWriter {
    File snippetFile;
    File parentFolder;
    String snippetType;
    String fileExtension;
    IPath snipBase;

    public SnipWriter(File parentFolder, String snippetType, IPath snipBase) {
        this.parentFolder = parentFolder == null ? (File)snipBase : parentFolder;
        this.snippetType = snippetType;
        this.snipBase = snipBase;
        this.fileExtension = snippetType.equals("Dreamweaver") ? ".csn" : ".xml";
    }

    private String getFullPath(String name) {
        return String.valueOf(this.parentFolder.toString()) + File.separator + name + this.fileExtension;
    }

    public void writeSnippet(String snippetName, String snippetKeyCombo, String snippetDescription, String startText, String endText, boolean useAsTemplate, String templateExtension) {
        File snippetFile = new File(String.valueOf(this.parentFolder.toString()) + File.separator + snippetName + this.fileExtension);
        String snippetContents = this.createFormattedSnip(snippetName, snippetDescription, startText, endText, useAsTemplate, templateExtension);
        try {
            if (!snippetFile.isFile()) {
                snippetFile.createNewFile();
            }
            FileWriter writer = new FileWriter(snippetFile);
            writer.write(snippetContents);
            writer.close();
            if (snippetKeyCombo.length() > 0) {
                String basePath;
                SnipKeyCombos snipKeyCombos = new SnipKeyCombos();
                String filepath = snippetFile.getAbsolutePath().replaceAll("\\\\", "/");
                String relativePath = filepath.replaceFirst(basePath = this.snipBase.toString(), "");
                String sequence = snipKeyCombos.getSequence(relativePath);
                if (sequence != null) {
                    snipKeyCombos.clearKeyCombo(sequence);
                }
                snipKeyCombos.setKeyCombo(snippetKeyCombo, relativePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public void writeSnippet(String snippetName, String snippetKeyCombo, String snippetDescription, String startText, String endText, boolean useAsTemplate, String templateExtension, String originalFileName) {
        File snippetFile = new File(this.getFullPath(snippetName));
        if (originalFileName.length() != 0) {
            File oldFile = new File(this.getFullPath(originalFileName));
            oldFile.renameTo(snippetFile);
        }
        String snippetContents = this.createFormattedSnip(snippetName, snippetDescription, startText, endText, useAsTemplate, templateExtension);
        try {
            if (!snippetFile.isFile()) {
                snippetFile.createNewFile();
            }
            FileWriter writer = new FileWriter(snippetFile);
            writer.write(snippetContents);
            writer.close();
            if (snippetKeyCombo.length() > 0) {
                String basePath;
                SnipKeyCombos snipKeyCombos = new SnipKeyCombos();
                String filepath = snippetFile.getAbsolutePath().replaceAll("\\\\", "/");
                String relativePath = filepath.replaceFirst(basePath = this.snipBase.toString(), "");
                String sequence = snipKeyCombos.getSequence(relativePath);
                if (sequence != null) {
                    snipKeyCombos.clearKeyCombo(sequence);
                }
                snipKeyCombos.setKeyCombo(snippetKeyCombo, relativePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private String createFormattedSnip(String snippetName, String snippetDescription, String startText, String endText, boolean useAsTemplate, String templateExtension) {
        String snippetContents;
        String useSnippetAsTemplate;
        String string = useSnippetAsTemplate = useAsTemplate ? "true" : "false";
        if (this.snippetType == "CFEclipse") {
            snippetContents = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            snippetContents = String.valueOf(snippetContents) + "<snippet filetemplate=\"" + useSnippetAsTemplate + "\" extension=\"" + templateExtension + "\">\n";
            snippetContents = String.valueOf(snippetContents) + "<name>" + snippetName + "</name>\n";
            snippetContents = String.valueOf(snippetContents) + "<help>" + snippetDescription + "</help>\n";
            snippetContents = String.valueOf(snippetContents) + "<starttext><![CDATA[" + startText + "]]></starttext>\n";
            snippetContents = String.valueOf(snippetContents) + "<endtext><![CDATA[" + endText + "]]></endtext>\n";
            snippetContents = String.valueOf(snippetContents) + "</snippet>";
        } else {
            snippetContents = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            snippetContents = String.valueOf(snippetContents) + "<snippet name = \"" + snippetName + "\" description = \"" + snippetDescription + "\" preview=\"html\" type=\"block\">\n";
            snippetContents = String.valueOf(snippetContents) + "<insertText location=\"beforeSelection\"><![CDATA[" + startText + "]]></insertText>\n";
            snippetContents = String.valueOf(snippetContents) + "<insertText location=\"afterSelection\"><![CDATA[" + endText + "]]></insertText>\n";
            snippetContents = String.valueOf(snippetContents) + "</snippet>\n";
        }
        return snippetContents;
    }

    public void writeFolder(String folderName) {
        File newFolder = new File(String.valueOf(this.parentFolder.toString()) + File.separator + folderName);
        newFolder.mkdir();
    }
}

