/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import java.util.ArrayList;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnipExExportBean;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.internal.ide.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectFilesPage
extends WizardPage {
    private IAdaptable root;
    private CheckboxTreeAndListGroup selectionGroup;
    private SnipExExportBean exportBean;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;

    public SelectFilesPage(String pageName, SnipExExportBean exportBean) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Select the files in the project you want to export");
        this.exportBean = exportBean;
        if (this.exportBean.getProject() != null) {
            this.root = this.exportBean.getProject();
        }
    }

    public SelectFilesPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        ArrayList<IAdaptable> input = new ArrayList<IAdaptable>();
        input.add(this.root);
        this.selectionGroup = new CheckboxTreeAndListGroup(container, input, this.getResourceProvider(14), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        container.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = SelectFilesPage.this.selectionGroup.getListTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
        this.exportBean.setFiles(this.selectionGroup);
        this.setControl((Control)container);
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }
}

