/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceUtils {
    public static Set getIResourceSurroundingResources(IResource res, String pathSoFar) {
        String postPath = "";
        if (!pathSoFar.endsWith("\\") && !pathSoFar.endsWith("/")) {
            int lastSlash = pathSoFar.lastIndexOf("\\");
            int n = lastSlash = lastSlash == -1 ? pathSoFar.lastIndexOf("/") : lastSlash;
            if (lastSlash == -1) {
                postPath = pathSoFar;
                pathSoFar = "";
            } else {
                postPath = pathSoFar.substring(lastSlash, pathSoFar.length());
                pathSoFar = pathSoFar.substring(pathSoFar.length());
            }
        }
        IPath folder = res.getFullPath().removeLastSegments(1).append(pathSoFar);
        IFolder folderRes = res.getWorkspace().getRoot().getFolder(folder);
        HashSet<IResource> suggestions = new HashSet<IResource>();
        if (folderRes != null) {
            try {
                IResource[] children = folderRes.members();
                int i = 0;
                while (i < children.length) {
                    if (children[i].getName().toLowerCase().startsWith(postPath.toLowerCase()) && (children[i] instanceof IFolder || children[i] instanceof IFile)) {
                        suggestions.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
        return suggestions;
    }

    public static IProjectNature[] getProjectNatures(IProject srcProject) throws CoreException {
        if (srcProject == null) {
            throw new IllegalArgumentException("ResourceUtils::getProjectNatures()");
        }
        IProjectDescription prjDesc = srcProject.getDescription();
        String[] natures = prjDesc.getNatureIds();
        IProjectNature[] natureArray = new IProjectNature[natures.length];
        int i = 0;
        while (i < natures.length) {
            try {
                natureArray[i] = srcProject.getNature(natures[i]);
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return natureArray;
    }

    public static String getStringFromInputStream(InputStream is) throws IOException {
        int k;
        InputStream in = is;
        StringBuffer stringFromIS = new StringBuffer();
        int aBuffSize = 0x112333;
        byte[] buff = new byte[aBuffSize];
        ByteArrayOutputStream xOutputStream = new ByteArrayOutputStream(aBuffSize);
        while ((k = in.read(buff)) != -1) {
            ((OutputStream)xOutputStream).write(buff, 0, k);
        }
        stringFromIS.append(((Object)xOutputStream).toString());
        return stringFromIS.toString();
    }

    public static boolean hasNature(IProject project2Check, String natureID) throws CoreException {
        IProjectDescription description = project2Check.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(natureID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void applyNature(IProject project2ApplyTo, String natureID) throws CoreException {
        IProjectDescription description = project2ApplyTo.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(natureID)) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = natureID;
        description.setNatureIds(newNatures);
        project2ApplyTo.setDescription(description, null);
    }

    public static void removeNature(IProject project, String natureID) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (natures.length == 0) {
            return;
        }
        if (!ResourceUtils.hasNature(project, natureID)) {
            return;
        }
        String[] newNatures = new String[natures.length - 1];
        int i = 0;
        int newNaturePos = 0;
        while (i < natures.length) {
            if (!natures[i].equals(natureID)) {
                newNatures[newNaturePos] = natures[i];
                ++newNaturePos;
            }
            ++i;
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static String getRelativePath(File fromDir, File toFileOrDir) throws IOException {
        File tof;
        File fromf;
        boolean otoEndsWithSep;
        boolean needSepEndForDirs;
        char sep = File.separatorChar;
        String ofrom = fromDir.getCanonicalPath();
        String oto = toFileOrDir.getCanonicalPath();
        if (!ofrom.endsWith(File.separator)) {
            ofrom = String.valueOf(ofrom) + sep;
            needSepEndForDirs = false;
        } else {
            needSepEndForDirs = true;
        }
        if (!oto.endsWith(File.separator)) {
            oto = String.valueOf(oto) + sep;
            otoEndsWithSep = false;
        } else {
            otoEndsWithSep = true;
        }
        String from = ofrom.toLowerCase();
        String to = oto.toLowerCase();
        StringBuffer path = new StringBuffer(oto.length());
        int fromln = from.length();
        while (!to.regionMatches(0, from, 0, fromln) || !(fromf = new File(ofrom.substring(0, needSepEndForDirs ? fromln : fromln - 1))).equals(tof = new File(oto.substring(0, needSepEndForDirs ? fromln : fromln - 1)))) {
            path.append(".." + sep);
            --fromln;
            while (fromln > 0 && from.charAt(fromln - 1) != sep) {
                --fromln;
            }
            if (fromln != 0) continue;
            throw new IOException("Could not find common parent directory in these paths: " + ofrom + " and " + oto);
        }
        path.append(oto.substring(fromln));
        if (!otoEndsWithSep && path.length() != 0) {
            path.setLength(path.length() - 1);
        }
        return path.toString();
    }

    public static String getPersistentProperty(IResource resource, String qualifier, String name) {
        try {
            return resource.getPersistentProperty(new QualifiedName(qualifier, name));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean hasProperty(IResource resource, String qualifier, String name) {
        String persistentProperty = ResourceUtils.getPersistentProperty(resource, qualifier, name);
        return persistentProperty != null && persistentProperty.trim().length() != 0;
    }
}

