/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.cfml.snippets.views.snips.SnipTreeViewLabelProvider;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnipExCategoriesContentProvider;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnippetToSnipExWizard;
import org.cfeclipse.snippet.snipex.Library;
import org.cfeclipse.snippet.snipex.SnipEx;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class SnippetToSnipExCategoryPage
extends WizardPage {
    private String snipexserver;
    private TreeViewer categoryTree;
    private boolean isPageComplete = false;
    private boolean canFinish = false;
    private Log logger = LogFactory.getLog(SnippetToSnipExCategoryPage.class);

    public SnippetToSnipExCategoryPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
    }

    public SnippetToSnipExCategoryPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        Label lbl_TreeLabel = new Label(container, 0);
        lbl_TreeLabel.setText("Select category to export snippet to");
        GridData layoutData = new GridData(1808);
        Tree tree = new Tree(container, 4);
        tree.setLayoutData((Object)layoutData);
        this.categoryTree = new TreeViewer(tree);
        this.categoryTree.setContentProvider((IContentProvider)new SnipExCategoriesContentProvider());
        this.categoryTree.setLabelProvider((IBaseLabelProvider)new SnipTreeViewLabelProvider());
        this.categoryTree.setInput((Object)"root");
        this.categoryTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SnippetToSnipExCategoryPage.this.isPageValid();
            }
        });
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            SnippetToSnipExWizard wizardmain = (SnippetToSnipExWizard)this.getWizard();
            String server = wizardmain.getDescriptionPage().getServerList().getText();
            this.categoryTree.setContentProvider((IContentProvider)new SnipExCategoriesContentProvider(server, false));
            this.isPageValid();
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    private boolean isPageValid() {
        if (this.categoryTree.getSelection().isEmpty()) {
            this.setErrorMessage("Select a category to export this snippet to");
            this.canFinish = false;
            this.isPageComplete = false;
            this.getWizard().getContainer().updateButtons();
            return false;
        }
        this.getWizard().getContainer().updateButtons();
        this.canFinish = true;
        this.isPageComplete = true;
        this.setErrorMessage(null);
        return true;
    }

    public TreeViewer getCategoryTree() {
        return this.categoryTree;
    }

    public String getCategoryID() {
        ITreeSelection selection = (ITreeSelection)this.categoryTree.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof Library) {
            Library lib = (Library)firstElement;
            return lib.getID();
        }
        if (firstElement instanceof SnipEx) {
            SnipEx snipEx = (SnipEx)firstElement;
            return snipEx.getID();
        }
        return "0";
    }
}

