/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.editors.actions;

import org.cfeclipse.cfml.snippets.util.Encloser;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class GenericEncloserAction
extends Encloser
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    protected ITextEditor editor = null;
    protected String start = "";
    protected String end = "";

    public GenericEncloserAction() {
    }

    public GenericEncloserAction(String start, String end) {
        this.setEnclosingStrings(start, end);
    }

    public void setEnclosingStrings(String start, String end) {
        this.start = start;
        this.end = end;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
        }
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        if (this.editor != null && this.editor.isEditable()) {
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            ISelection sel = this.editor.getSelectionProvider().getSelection();
            this.enclose(doc, (ITextSelection)sel, this.start, this.end);
            int offset = ((ITextSelection)sel).getOffset();
            offset += ((ITextSelection)sel).getLength();
            this.editor.setHighlightRange(offset += this.start.length(), 0, true);
            this.editor.resetHighlightRange();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.editor != null) {
            this.setActiveEditor(null, this.editor.getSite().getPage().getActiveEditor());
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)activeEditor;
        }
    }
}

