/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.cfml.snippets.wizards.snipex.EnterDescriptionPage;
import org.cfeclipse.cfml.snippets.wizards.snipex.SelectAppPage;
import org.cfeclipse.cfml.snippets.wizards.snipex.SelectFilesPage;
import org.cfeclipse.cfml.snippets.wizards.snipex.SnipExExportBean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportApplicationWizard
extends Wizard
implements IExportWizard {
    private SelectAppPage appPage;
    private SelectFilesPage filePage;
    private EnterDescriptionPage descPage;
    private Log logger = LogFactory.getLog(ExportApplicationWizard.class);
    private boolean isFinished = false;
    private SnipExExportBean exportBean = new SnipExExportBean();

    public ExportApplicationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.appPage = new SelectAppPage("Select Application to Export", this.exportBean);
        this.filePage = new SelectFilesPage("Select Files to Export", this.exportBean);
        this.descPage = new EnterDescriptionPage("Enter Description", this.exportBean);
        this.addPage((IWizardPage)this.appPage);
        this.addPage((IWizardPage)this.filePage);
        this.addPage((IWizardPage)this.descPage);
    }

    public boolean performFinish() {
        this.logger.debug((Object)("Performing Finish!" + this.exportBean.getFiles()));
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        this.logger.debug((Object)("The thing that we have chosen is : " + firstElement));
        if (firstElement instanceof IProject) {
            this.exportBean.setProject((IProject)firstElement);
        } else if (firstElement instanceof IFolder) {
            IFolder folderItem = (IFolder)firstElement;
            this.exportBean.setProject(folderItem.getProject());
        } else if (firstElement instanceof IFile) {
            IFile fileItem = (IFile)firstElement;
            this.exportBean.setProject(fileItem.getProject());
        }
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public boolean canFinish() {
        return this.isFinished;
    }
}

