/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.wizards.snipex;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.util.ResourceUtils;
import org.cfeclipse.cfml.snippets.views.snips.SnippetObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SnippetToSnipExDescriptionPage
extends WizardPage {
    private Combo serverList;
    private Text txt_sDescription;
    private Text txt_sName;
    private Text txt_uEmail;
    private SnippetObject snippet;
    private Text txt_uName;
    private Log logger = LogFactory.getLog(SnippetToSnipExDescriptionPage.class);

    protected SnippetToSnipExDescriptionPage(String pageName, SnippetObject object) {
        super(pageName);
        this.setTitle(pageName);
        this.snippet = object;
        this.setDescription("Select the SnipEx server to export this snippet to and enter details about yourself and the snippet that is being exported.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        Label lblServer = new Label(container, 0);
        lblServer.setText("SnipEx Server:");
        GridData comboGD = new GridData();
        comboGD.widthHint = 200;
        this.serverList = new Combo(container, 8);
        this.serverList.setLayoutData((Object)comboGD);
        this.serverList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetToSnipExDescriptionPage.this.isValidatedPage();
            }
        });
        this.fillServers(this.serverList);
        GridData fieldsgd = new GridData();
        fieldsgd.widthHint = 200;
        Label lbl_uName = new Label(container, 0);
        lbl_uName.setText("Your Name:");
        lbl_uName.setLayoutData((Object)fieldsgd);
        this.txt_uName = new Text(container, 2048);
        this.txt_uName.setText(System.getProperty("user.name"));
        this.txt_uName.setLayoutData((Object)fieldsgd);
        this.txt_uName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetToSnipExDescriptionPage.this.isValidatedPage();
            }
        });
        Label lbl_uEmail = new Label(container, 0);
        lbl_uEmail.setText("Your Email:");
        this.txt_uEmail = new Text(container, 2048);
        this.txt_uEmail.setLayoutData((Object)fieldsgd);
        this.txt_uEmail.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetToSnipExDescriptionPage.this.isValidatedPage();
            }
        });
        Label lbl_sName = new Label(container, 0);
        lbl_sName.setText("Snippet Name:");
        this.txt_sName = new Text(container, 2048);
        this.txt_sName.setLayoutData((Object)fieldsgd);
        this.txt_sName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetToSnipExDescriptionPage.this.isValidatedPage();
            }
        });
        GridData spanLabel = new GridData();
        spanLabel.horizontalSpan = 2;
        Label lbl_sDescription = new Label(container, 0);
        lbl_sDescription.setText("Snippet Description:");
        lbl_sDescription.setLayoutData((Object)spanLabel);
        GridData spanField = new GridData(1808);
        spanField.horizontalSpan = 2;
        spanField.widthHint = 410;
        spanField.heightHint = 200;
        this.txt_sDescription = new Text(container, 2818);
        this.txt_sDescription.setLayoutData((Object)spanField);
        this.setControl((Control)container);
    }

    private void fillServers(Combo serverList2) {
        IPreferenceStore preferenceStore = SnippetPlugin.getDefault().getPreferenceStore();
        String url1 = preferenceStore.getString("snipExURL1");
        String url2 = preferenceStore.getString("snipExURL2");
        String url3 = preferenceStore.getString("snipExURL3");
        String url4 = preferenceStore.getString("snipExURL4");
        String url5 = preferenceStore.getString("snipExURL5");
        String url6 = preferenceStore.getString("snipExURL6");
        String url7 = preferenceStore.getString("snipExURL7");
        String url8 = preferenceStore.getString("snipExURL8");
        if (url1.length() > 0 && this.canSubmit(url1)) {
            serverList2.add(url1);
        }
        if (url2.length() > 0 && this.canSubmit(url2)) {
            serverList2.add(url2);
        }
        if (url3.length() > 0 && this.canSubmit(url3)) {
            serverList2.add(url3);
        }
        if (url4.length() > 0 && this.canSubmit(url4)) {
            serverList2.add(url4);
        }
        if (url5.length() > 0 && this.canSubmit(url5)) {
            serverList2.add(url5);
        }
        if (url6.length() > 0 && this.canSubmit(url6)) {
            serverList2.add(url6);
        }
        if (url7.length() > 0 && this.canSubmit(url7)) {
            serverList2.add(url7);
        }
        if (url8.length() > 0 && this.canSubmit(url8)) {
            serverList2.add(url8);
        }
    }

    private boolean canSubmit(String url1) {
        try {
            URL snipexServer = new URL(String.valueOf(url1) + "?method=canSubmit");
            Object response = snipexServer.getContent();
            String stringFromInputStream = ResourceUtils.getStringFromInputStream((InputStream)response);
            if (stringFromInputStream.trim().equals("true")) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.logger.debug((Object)"Description page is visible");
            if (this.snippet != null) {
                this.txt_sName.setText(this.snippet.getName());
                this.txt_sDescription.setText(this.snippet.getDescription());
            }
            this.isValidatedPage();
        }
    }

    public boolean canFinish() {
        return this.isValidatedPage();
    }

    private boolean isValidatedPage() {
        if (this.serverList.getText() == null || this.serverList.getText().length() == 0) {
            this.setErrorMessage("Please select a SnipEx server");
            return false;
        }
        if (this.txt_uName.getText().length() == 0) {
            this.setErrorMessage("Please enter a user's name");
            return false;
        }
        if (this.txt_uEmail.getText().length() == 0) {
            this.setErrorMessage("Please enter a user's email address");
            return false;
        }
        if (this.txt_sName.getText().length() == 0) {
            this.setErrorMessage("Please enter a name for this snippet");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Combo getServerList() {
        return this.serverList;
    }

    public String getSnippetDescription() {
        return this.txt_sDescription.getText();
    }

    public String getSnippetName() {
        return this.txt_sName.getText();
    }

    public String getUserEmail() {
        return this.txt_uEmail.getText();
    }

    public String getUserName() {
        return this.txt_uName.getText();
    }
}

