/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileAppTypeInfo;
import org.tizen.common.core.application.ProfileVersionInfo;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.util.Assert;

public class ProfileInfo {
    private static final Logger logger = LoggerFactory.getLogger(ProfileInfo.class);
    private static final String TV = "tv";
    private String profile;
    private Map<String, String> versions = new HashMap<String, String>();
    private Map<String, ProfileVersionInfo> versionInfoMap = new HashMap<String, ProfileVersionInfo>();
    private String parentProfile = "none";
    private String description = "";
    private List<ProfileVersionInfo> descentPlatformVersionList;

    public ProfileInfo(String profile) {
        Assert.notNull(this.versions);
        this.profile = profile;
    }

    public ProfileInfo(String profile, Map<String, String> versions) {
        Assert.notNull(versions);
        this.profile = profile;
        this.versions = versions;
    }

    public ProfileInfo(String profile, Map<String, String> versions, Map<String, ProfileVersionInfo> versionsInfo) {
        Assert.notNull(versions);
        this.profile = profile;
        this.versions = versions;
        this.versionInfoMap = versionsInfo;
    }

    public ProfileInfo(String profile, String version, String path) {
        this.profile = profile;
        this.versions.put(version, path);
        this.setParentProfileByProfile(profile);
    }

    public ProfileInfo(String profile, String version, String path, String parentProfile) {
        this.profile = profile;
        this.versions.put(version, path);
        this.setParentProfile(parentProfile);
    }

    public ProfileInfo(String profile, String version, String path, ProfileVersionInfo versionInfo) {
        this.profile = profile;
        this.versions.put(version, path);
        this.versionInfoMap.put(version, versionInfo);
        this.setParentProfileByProfile(profile);
    }

    private void setParentProfileByProfile(String profile) {
        String profileParentProfile = "none";
        if (StringUtil.isEmpty(profile)) {
            this.parentProfile = profileParentProfile;
            return;
        }
        String profileLow = profile.toLowerCase();
        String[] profileNameArr = StringUtil.split(String.valueOf(profileLow), "-");
        if (profileNameArr.length > 1) {
            if (profileLow.contains("mobile")) {
                profileParentProfile = "mobile";
            } else if (profileLow.contains("wearable")) {
                profileParentProfile = "wearable";
            } else if (profileLow.contains(TV)) {
                profileParentProfile = TV;
            }
        }
        this.parentProfile = profileParentProfile;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getParentProfile() {
        return this.parentProfile;
    }

    public void setParentProfile(String parentProfile) {
        if (StringUtil.isEmpty(parentProfile)) {
            this.parentProfile = "none";
            return;
        }
        this.parentProfile = parentProfile.toLowerCase();
    }

    public Set<String> getVersions() {
        return this.versions.keySet();
    }

    public Map<String, String> getVersionsMap() {
        return this.versions;
    }

    public Set<String> getVersionInfos() {
        return this.versionInfoMap.keySet();
    }

    public Map<String, ProfileVersionInfo> getVersionInfoMap() {
        return this.versionInfoMap;
    }

    public void setVersionInfoMap(Map<String, ProfileVersionInfo> versionInfoMap) {
        this.versionInfoMap = versionInfoMap;
    }

    public void setVersionMap(Map<String, String> versionMap) {
        this.versions = versionMap;
    }

    public void appendVersion(String version, String path) {
        this.versions.put(version, path);
    }

    public void appendVersionInfo(String version, ProfileVersionInfo versionInfo) {
        if (this.versionInfoMap.get(version) != null) {
            List<String> supportIDEList = this.versionInfoMap.get(version).getSupportIDE();
            boolean isSameValue = false;
            for (String ideType : supportIDEList) {
                for (String insertIdeType : versionInfo.getSupportIDE()) {
                    if (!ideType.equals(insertIdeType)) continue;
                    isSameValue = true;
                }
            }
            if (!isSameValue) {
                List<ProfileAppTypeInfo> appTypeInfo = this.versionInfoMap.get(version).getAppTypeInfoList();
                versionInfo.getAppTypeInfoList().addAll(appTypeInfo);
            }
        }
        this.versionInfoMap.put(version, versionInfo);
    }

    public void appendProfileVersionInfo(String version, ProfileVersionInfo versionInfo) {
        if (this.versionInfoMap.get(version) != null) {
            List<String> supportIDEList = this.versionInfoMap.get(version).getSupportIDE();
            boolean isSameValue = false;
            for (String ideType : supportIDEList) {
                for (String insertIdeType : versionInfo.getSupportIDE()) {
                    if (!ideType.equals(insertIdeType)) continue;
                    isSameValue = true;
                }
            }
            if (!isSameValue) {
                versionInfo.getSupportIDE().addAll(supportIDEList);
            }
        }
        this.versionInfoMap.put(version, versionInfo);
    }

    public String getLatestPlatformPath() {
        String version = this.getLatestPlatformVersion();
        if (version.isEmpty()) {
            return "";
        }
        ProfileVersionInfo versionInfo = this.versionInfoMap.get(version);
        if (versionInfo == null) {
            return "";
        }
        return versionInfo.getVersionPath();
    }

    public String getLatestPlatformVersion() {
        String version = "";
        Version latestVersion = Version.ZERO;
        Version tempVersion = null;
        for (String curVersion : this.getVersions()) {
            tempVersion = new Version(curVersion);
            if (latestVersion.compareTo(tempVersion) >= 0) continue;
            latestVersion = tempVersion;
            version = curVersion;
        }
        return version;
    }

    public List<ProfileVersionInfo> getSortDescendPlatformVersion() {
        if (this.descentPlatformVersionList != null && this.descentPlatformVersionList.size() > 0) {
            return this.descentPlatformVersionList;
        }
        this.descentPlatformVersionList = new ArrayList<ProfileVersionInfo>();
        if (this.versions == null || this.versionInfoMap == null) {
            return this.descentPlatformVersionList;
        }
        ArrayList<ProfileVersionInfo> installedPlatformVersion = new ArrayList<ProfileVersionInfo>();
        ArrayList<ProfileVersionInfo> notInstalledPlatformVersion = new ArrayList<ProfileVersionInfo>();
        NavigableSet<String> keys = new TreeSet<String>(this.getVersions()).descendingSet();
        for (String curVersion : keys) {
            ProfileVersionInfo versionInfo = this.versionInfoMap.get(curVersion);
            if (versionInfo.isInstalledVersion()) {
                installedPlatformVersion.add(versionInfo);
                continue;
            }
            notInstalledPlatformVersion.add(versionInfo);
        }
        if (installedPlatformVersion.size() > 0) {
            this.descentPlatformVersionList.addAll(installedPlatformVersion);
        }
        if (notInstalledPlatformVersion.size() > 0) {
            this.descentPlatformVersionList.addAll(notInstalledPlatformVersion);
        }
        return this.descentPlatformVersionList;
    }

    public String[] getSupportVersionList(String checkVersion) {
        ArrayList<String> versionList = new ArrayList<String>();
        Version checkVersionInfo = new Version(checkVersion);
        Version tempVersion = null;
        NavigableSet<String> keys = new TreeSet<String>(this.getVersions()).descendingSet();
        for (String curVersion : keys) {
            tempVersion = new Version(curVersion);
            if (checkVersionInfo.compareTo(tempVersion) > 0) continue;
            versionList.add(curVersion);
        }
        if (versionList.size() < 1) {
            return null;
        }
        String[] versionArr = new String[versionList.size()];
        versionList.toArray(versionArr);
        return versionArr;
    }

    public boolean isSupportPlatformVersion(String checkVersion) {
        Version checkVersionInfo = new Version(checkVersion);
        Version tempVersion = null;
        for (String curVersion : this.getVersions()) {
            tempVersion = new Version(curVersion);
            if (checkVersionInfo.compareTo(tempVersion) > 0) continue;
            return true;
        }
        return false;
    }

    public ProfileVersionInfo getVersionInfo(String version) {
        ProfileVersionInfo profileVersionInfo = this.versionInfoMap.get(version);
        if (profileVersionInfo == null) {
            return null;
        }
        return profileVersionInfo;
    }

    public String getPlatformPath(String version) {
        String platformPath = this.versions.get(version);
        if (platformPath == null) {
            return "";
        }
        return platformPath;
    }

    public String getPlatformName(String version) {
        if (!this.versions.containsKey(version)) {
            return "";
        }
        return String.format("%s-%s", this.profile, version);
    }

    public String getLatestPlatformName() {
        return this.getPlatformName(this.getLatestPlatformVersion());
    }

    public static String getPlatformName(IDevice device) {
        ProfileInfo profileInfo;
        block3: {
            try {
                profileInfo = ProfileInfo.getProfileInfo(device);
                if (profileInfo != null) break block3;
                return "";
            }
            catch (Exception e) {
                logger.error("cannot get device information - " + device, (Throwable)e);
                return "";
            }
        }
        return profileInfo.getLatestPlatformName();
    }

    public static ProfileInfo getProfileInfo(IDevice device) {
        PlatformInfo platformInfo = null;
        try {
            platformInfo = device.getPlatformInfo();
            String version = platformInfo.getPlatformVersion();
            if (!version.matches("(((\\d)|([1-9]\\d{2,}))\\.)+((\\d)|([1-9]\\d{2,}))")) {
                throw new Exception("Failed to get a device's profile version");
            }
            String profile = platformInfo.getProfileName();
            String path = null;
            ProfileInfo profileInfo = InstallPathConfig.getProfileInfo(profile);
            if (profileInfo != null) {
                path = profileInfo.getPlatformPath(version);
            }
            return new ProfileInfo(profile, version, path);
        }
        catch (Exception e) {
            logger.error(String.format("Failed to get a device information from '%s' (%s) ", device, platformInfo), (Throwable)e);
            return null;
        }
    }

    public boolean isProduct() {
        return !this.parentProfile.equals("none");
    }

    public boolean isInstalledProfile() {
        if (this.versionInfoMap == null || this.versionInfoMap.size() < 1) {
            return false;
        }
        ArrayList<ProfileVersionInfo> versionList = new ArrayList<ProfileVersionInfo>(this.versionInfoMap.values());
        for (ProfileVersionInfo versionInfo : versionList) {
            if (!versionInfo.isInstalledVersion()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getParentProfileName(String version) {
        return this.parentProfile;
    }

    @Deprecated
    public boolean isProduct(String version) {
        return !this.parentProfile.equals("none");
    }

    public boolean isTV() {
        boolean isTV = false;
        if (TV.equals(this.profile) || TV.equals(this.parentProfile)) {
            isTV = true;
        }
        return isTV;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

