/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.CommonProjectDependentPackager;
import org.tizen.nativecommon.build.model.ProjectType;

public class ProjectTypeManager {
    private static final Map<String, ProjectType> projectArtifactTypeMap = new HashMap<String, ProjectType>();

    public static void registerProjectArtifactType(String[] artifactType, CommonProjectDependentBuilder builder, CommonProjectDependentPackager packager, boolean isValidProject) {
        String[] stringArray = artifactType;
        int n = artifactType.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            ProjectType project = new ProjectType(type, builder, packager, isValidProject);
            projectArtifactTypeMap.put(type, project);
            ++n2;
        }
    }

    public static void registerProjectArtifactType(String artifactType, CommonProjectDependentBuilder builder, CommonProjectDependentPackager packager, boolean isValidProject) {
        ProjectType project = new ProjectType(artifactType, builder, packager, isValidProject);
        projectArtifactTypeMap.put(artifactType, project);
    }

    public static CommonProjectDependentBuilder getProjectBuilderInstance(IProject project) {
        String name = ProjectTypeManager.getProjectArtifactType(project);
        ProjectType type = projectArtifactTypeMap.get(name);
        if (type == null) {
            type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectTypeName(project));
        }
        if (type == null) {
            return null;
        }
        CommonProjectDependentBuilder b = type.getBuilder();
        if (b == null) {
            return null;
        }
        b.setProject(project);
        return b;
    }

    public static CommonProjectDependentPackager getProjectPackagerInstance(IProject project) {
        String name = ProjectTypeManager.getProjectArtifactType(project);
        ProjectType type = projectArtifactTypeMap.get(name);
        if (type == null) {
            type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectTypeName(project));
        }
        if (type == null) {
            return null;
        }
        CommonProjectDependentPackager b = type.getPackager();
        if (b == null) {
            return null;
        }
        b.setProject(project);
        b.setSbi(project);
        return b;
    }

    public static boolean isSupportedProjectType(IProject project) {
        ProjectType type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectArtifactType(project));
        if (type == null) {
            type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectTypeName(project));
        }
        return type != null;
    }

    public static boolean isValidProjectType(IProject project) {
        ProjectType type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectArtifactType(project));
        if (type == null) {
            type = projectArtifactTypeMap.get(ProjectTypeManager.getProjectTypeName(project));
        }
        if (type == null) {
            return false;
        }
        return type.getValidProject();
    }

    private static String getProjectArtifactType(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            return null;
        }
        IManagedProject managedProject = cfg.getManagedProject();
        if (managedProject == null) {
            return null;
        }
        if (managedProject.getProjectType() != null) {
            return managedProject.getProjectType().getBuildArtefactType().getId();
        }
        return null;
    }

    private static String getProjectTypeName(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            return null;
        }
        IConfiguration cfg = info.getDefaultConfiguration();
        if (cfg == null) {
            return null;
        }
        IManagedProject managedProject = cfg.getManagedProject();
        if (managedProject == null) {
            return null;
        }
        return managedProject.getName();
    }
}

