/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;

public abstract class PropertyUtil {
    protected static final Logger logger = LoggerFactory.getLogger(PropertyUtil.class);

    public static Properties loadProperties(String fileName) {
        Properties props;
        block6: {
            props = new Properties();
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(fileName));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        if (StringUtil.isEmpty(line)) continue;
                        int index = line.indexOf("=");
                        String key = line.substring(0, index);
                        String value = line.substring(index + 1);
                        props.setProperty(key, value);
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    IOUtil.tryClose(reader);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(reader);
                throw throwable;
            }
            IOUtil.tryClose(reader);
        }
        return props;
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException iOException) {
            logger.info("Ignore exception");
        }
        return props;
    }

    public static boolean storeProperties(OutputStream outputStream, Properties props) {
        try {
            props.store(outputStream, null);
        }
        catch (IOException iOException) {
            try {
                logger.info("Ignore exception");
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(outputStream);
                throw throwable;
            }
            IOUtil.tryClose(outputStream);
            return false;
        }
        IOUtil.tryClose(outputStream);
        return true;
    }

    public static boolean storeProperties(String fileName, Properties props) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            props.store(writer, null);
        }
        catch (IOException iOException) {
            try {
                logger.info("Ignore exception");
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(writer);
                throw throwable;
            }
            IOUtil.tryClose(writer);
            return false;
        }
        IOUtil.tryClose(writer);
        return true;
    }
}

