/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.nativecommon.po.editor.TableViewerKeyBoardSupporter;

class CellEditorTraverseListener
implements TraverseListener {
    private TableViewerKeyBoardSupporter fKeyBoardSupporter = null;
    private CellEditor fEditor = null;
    private int fEditorColumn = -1;

    public CellEditorTraverseListener(TableViewerKeyBoardSupporter keyBoardSupporter, CellEditor editor, int editorColumn) {
        this.fKeyBoardSupporter = keyBoardSupporter;
        this.fEditor = editor;
        this.fEditorColumn = editorColumn;
    }

    public void keyTraversed(TraverseEvent e) {
        switch (e.detail) {
            case 16: {
                this.fKeyBoardSupporter.editColumnOrNextPossible(this.fKeyBoardSupporter.nextColumn(this.fEditorColumn));
                e.detail = 0;
                break;
            }
            case 8: {
                this.fKeyBoardSupporter.editColumnOrPrevPossible(this.fKeyBoardSupporter.prevColumn(this.fEditorColumn));
                e.detail = 0;
                break;
            }
            case 2: {
                this.fKeyBoardSupporter.getTableViewer().cancelEditing();
                e.detail = 0;
                break;
            }
            case 4: {
                this.fEditor.deactivate();
                e.detail = 0;
                Rectangle area = this.fKeyBoardSupporter.getComposite().getClientArea();
                this.fKeyBoardSupporter.getSizeController().restoreIfFocusingStatus(area, this.fKeyBoardSupporter.getTable());
                break;
            }
        }
    }
}

