/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.commands;

import org.cfeclipse.cfml.snippets.util.Encloser;
import org.cfeclipse.cfml.snippets.views.snips.SnipKeyCombos;
import org.cfeclipse.cfml.snippets.views.snips.SnipReader;
import org.cfeclipse.cfml.snippets.views.snips.SnipVarParser;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class InsertSnippetCommand
extends AbstractHandler {
    protected String start = "";
    protected String end = "";

    public InsertSnippetCommand() {
    }

    public InsertSnippetCommand(String triggerText, Shell shell) {
        SnipKeyCombos keyCombos = new SnipKeyCombos();
        ITextEditor editor = (ITextEditor)Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ISelection sel = editor.getSelectionProvider().getSelection();
        String fileName = keyCombos.getKeyCombo(triggerText);
        SnipReader snipReader = new SnipReader();
        IFile activeFile = null;
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            activeFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
        snipReader.read(String.valueOf(keyCombos.getSnippetFolder()) + fileName);
        this.start = SnipVarParser.parse(snipReader.getSnipStartBlock(), activeFile, shell);
        this.end = SnipVarParser.parse(snipReader.getSnipEndBlock(), activeFile, shell);
        if (this.end != null) {
            Encloser encloser = new Encloser();
            encloser.enclose(doc, (ITextSelection)sel, this.start, this.end);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        Shell shell = editorPart.getSite().getShell();
        ITextEditor editor = null;
        if (editorPart instanceof ITextEditor) {
            editor = (ITextEditor)editorPart;
        } else if (editorPart instanceof MultiPageEditorPart) {
            editor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        }
        if (editor != null && editor.isEditable()) {
            ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            SnipKeyCombos keyCombos = new SnipKeyCombos();
            String sequence = "";
            int cursorOffset = sel.getOffset();
            int lastSpaceOffset = -1;
            FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
            try {
                IRegion lastSpace = finder.find(cursorOffset - 1, "[^\\*0-9a-zA-Z_-]", false, false, false, true);
                lastSpaceOffset = lastSpace == null ? 0 : lastSpace.getOffset() + 1;
                if (cursorOffset > lastSpaceOffset) {
                    if (cursorOffset != doc.getLength()) {
                        System.out.println("yep");
                        IRegion nextSpace = finder.find(cursorOffset - 1, "[^\\*0-9a-zA-Z_-]", true, false, false, true);
                        if (nextSpace != null && nextSpace.getOffset() == cursorOffset) {
                            sequence = doc.get().substring(lastSpaceOffset, cursorOffset);
                        }
                    } else {
                        sequence = doc.get().substring(lastSpaceOffset, cursorOffset);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sequence.length() == 0) {
                System.out.println("no trigger text has been passed in");
            }
            if (sequence.length() > 0) {
                String[] stringArray = sequence.split("\\*");
                String trigger = stringArray[0];
                int loopcount = 1;
                if (stringArray.length > 1) {
                    loopcount = Integer.parseInt(stringArray[1].trim());
                }
                String fileName = keyCombos.getKeyCombo(trigger);
                SnipReader snipReader = new SnipReader();
                IFile activeFile = null;
                if (editor.getEditorInput() instanceof IFileEditorInput) {
                    activeFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
                }
                if (fileName == null) {
                    MessageBox dialog = new MessageBox(shell, 1);
                    dialog.setMessage("No snippet found for : " + sequence);
                    dialog.open();
                    return null;
                }
                snipReader.read(fileName);
                String indentString = "";
                try {
                    int lineNumber = doc.getLineOfOffset(lastSpaceOffset);
                    int lineOffset = doc.getLineOffset(lineNumber);
                    indentString = doc.get().substring(lineOffset, lastSpaceOffset);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                if (indentString.length() > 0) {
                    snipReader.performIndent(indentString);
                }
                String snippet = "";
                int finalCursorOffset = -1;
                int i = 0;
                while (i < loopcount) {
                    this.start = SnipVarParser.parse(snipReader.getSnipStartBlock(), activeFile, shell);
                    this.end = SnipVarParser.parse(snipReader.getSnipEndBlock(), activeFile, shell);
                    if (this.start == null || this.end == null) {
                        snippet = null;
                        break;
                    }
                    snippet = String.valueOf(this.start) + this.end;
                    if (snippet != null && snippet.length() > 0) {
                        Encloser encloser = new Encloser();
                        encloser.enclose(doc, sel, snippet, "");
                        int offset = sel.getOffset();
                        offset += sel.getLength();
                        offset += snippet.length();
                        if (i == 0) {
                            try {
                                doc.replace(lastSpaceOffset, sequence.length(), "");
                                sel = new TextSelection(doc, offset - sequence.length(), 0);
                                if (this.end.length() > 0) {
                                    finalCursorOffset = lastSpaceOffset + this.start.length();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            sel = new TextSelection(doc, offset, 0);
                        }
                        editor.setHighlightRange(offset, 0, true);
                    } else {
                        MessageBox dialog = new MessageBox(shell, 1);
                        dialog.setMessage("No key combo specified for : " + trigger + "in " + keyCombos.getKeyCombosFilePath());
                        dialog.open();
                    }
                    ++i;
                }
                if (finalCursorOffset > 0) {
                    editor.setHighlightRange(finalCursorOffset, 0, true);
                }
            }
        }
        return null;
    }
}

