/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.cfml.snippets.preferences;

import org.cfeclipse.cfml.snippets.SnippetPlugin;
import org.cfeclipse.cfml.snippets.preferences.CFMLPreferenceManager;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SnipExPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    CFMLPreferenceManager cfmlpm;
    CFMLPreferenceManager preferenceManager;

    public SnipExPreferencePage() {
        super(1);
        this.setPreferenceStore(SnippetPlugin.getDefault().getPreferenceStore());
        this.setDescription("These preferences will allow you to customize the what SnipEx servers will be aggregated in your snippet view.\n\n");
        this.cfmlpm = SnippetPlugin.getDefault().getPreferenceManager();
    }

    protected void createFieldEditors() {
        DirectoryFieldEditor directoryFieldEditor = new DirectoryFieldEditor("_snippetsPath", "Snippets directory", this.getFieldEditorParent()){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                int widthInChars = 28;
                Text textField = this.getTextControl(parent);
                GridData gd = new GridData();
                gd.horizontalSpan = numColumns - 1;
                GC gc = new GC((Drawable)textField);
                try {
                    Point extent = gc.textExtent("X");
                    gd.widthHint = widthInChars * extent.x;
                    textField.setLayoutData((Object)gd);
                }
                finally {
                    gc.dispose();
                }
            }
        };
        this.addField((FieldEditor)directoryFieldEditor);
        this.addField((FieldEditor)new StringFieldEditor("snipExURL1", "URL 1", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL2", "URL 2", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL3", "URL 3", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL4", "URL 4", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL5", "URL 5", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL6", "URL 6", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL7", "URL 7", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("snipExURL8", "URL 8", this.getFieldEditorParent()));
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

