/*
 * Decompiled with CFR 0.152.
 */
package org.cfeclipse.snippet.snipex;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cfeclipse.snippet.snipex.LibraryHandler;
import org.cfeclipse.snippet.snipex.Snippet;

public class Library {
    private String id;
    private String name;
    private Vector snippets;
    private Vector libraries;
    private Date createdAt;
    private String description;
    private URL source;
    private URL detailsAddress;
    private URL proposalAddress;
    private Log logger = LogFactory.getLog(Library.class);

    public Library() {
    }

    public Library(URL source) {
        this.setSource(source);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getSource() {
        return this.source;
    }

    public URL getDetailsAddress() {
        return this.detailsAddress;
    }

    public URL getProposalAddress() {
        return this.proposalAddress;
    }

    public Vector getSnippets() {
        if (this.snippets == null) {
            this.load(true);
        }
        return this.snippets;
    }

    public Vector getLibraries() {
        if (this.libraries == null) {
            this.load(true);
        }
        return this.libraries;
    }

    public void setID(String i) {
        this.id = i;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setSnippets(Vector s) {
        this.snippets = s;
    }

    public void setLibraries(Vector l) {
        this.libraries = l;
    }

    public void setCreatedAt(Date d) {
        this.createdAt = d;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public void setSource(URL url) {
        this.source = url;
    }

    public void setSource(String url) throws MalformedURLException {
        this.source = new URL(url);
    }

    public void setDetailsAddress(URL url) {
        this.detailsAddress = url;
    }

    public void setDetailsAddress(String url) throws MalformedURLException {
        this.detailsAddress = new URL(url);
    }

    public void setProposalAddress(URL url) {
        this.proposalAddress = url;
    }

    public void setProposalAddress(String url) throws MalformedURLException {
        this.proposalAddress = new URL(url);
    }

    public boolean addLibrary(Library l) {
        return this.libraries.add(l);
    }

    public boolean removeLibrary(Library l) {
        return this.libraries.remove(l);
    }

    public void clearLibraries() {
        this.libraries.clear();
    }

    public int getLibCount() {
        return this.libraries.size();
    }

    public boolean addSnippet(Snippet s) {
        return this.snippets.add(s);
    }

    public boolean removeSnippet(Snippet s) {
        return this.snippets.remove(s);
    }

    public void clearSnippet() {
        this.snippets.clear();
    }

    public int getSnipCount() {
        return this.snippets.size();
    }

    private void load(boolean fullReload) {
        this.setSnippets(new Vector());
        this.setLibraries(new Vector());
        new LibraryHandler(this, fullReload);
    }

    public String toString() {
        return this.getName();
    }
}

