/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.exception;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;

public class SigningErrorDialog
extends IconAndMessageDialog {
    private String title;

    public SigningErrorDialog(String message) {
        this(SWTUtil.getActiveShell(), "Signing", message);
    }

    public SigningErrorDialog(Shell parentShell, String dialogTitle, String message) {
        super(parentShell);
        this.title = StringUtil.nvl((String[])new String[]{dialogTitle, JFaceResources.getString((String)"Problem_Occurred")});
        this.message = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.addAccessibleListeners(this.imageLabel, image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Link messageLabel = new Link(composite, this.getMessageLabelStyle());
            messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLabel);
            messageLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)SigningErrorDialog.this.getShell(), (String)"org.tizen.common.sign.preferences.SigningPreferencePage", (String[])new String[]{"org.tizen.common.sign.preferences.SigningPreferencePage"}, null);
                    dialog.open();
                }
            });
        }
        return composite;
    }

    private void addAccessibleListeners(Label label, final Image image) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = SigningErrorDialog.this.getAccessibleMessageFor(image);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }
        });
    }

    private String getAccessibleMessageFor(Image image) {
        if (image.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (image.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (image.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (image.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        return this.getErrorImage();
    }

    public static int openError(Shell parent, String dialogTitle, String message, IStatus status) {
        return SigningErrorDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        ErrorDialog dialog = new ErrorDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].matches(mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isResizable() {
        return true;
    }
}

