/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.ui.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PluginDropAdapter;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.RMTreeContentProvider;
import org.tizen.nativecommon.rm.ui.view.RMTreeLabelProvider;
import org.tizen.nativecommon.rm.ui.view.TizenRMView;

public class RMViewTabFolder {
    private static final String DIRECTORY = "dir";
    private static final String NANE = "name";
    private static final String ITEM = "item";
    private TabFolder tabFolder;
    private final TizenRMView rmView;
    private TreeViewer treeViewer;
    private Composite parent;
    private SashForm sashForm;
    private Label directoryText;
    private Label resolutionText;
    private Label languageText;
    private Composite InfoItemComp;
    private Label separator;
    private Label projectName;
    private SelectionAdapter selectionApdater;
    public static final ImageDescriptor ENABLE_ICON = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/elcl18/switch_tab.png");
    public static final ImageDescriptor DISABLE_ICON = ImageUtil.getImageDescriptor((String)"org.tizen.nativecommon", (String)"icons/rm/dlcl18/switch_tab.png");
    public static final String DESCIPTION = "";
    public static final String TEXT = "Switch Tab List";
    public MenuManager menuMgr;

    public RMViewTabFolder(Composite parent, TizenRMView view, int style) {
        this.parent = parent;
        this.rmView = view;
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.projectName = new Label(parent, 0);
        this.projectName.setText(view.getProject().getName());
        this.separator = new Label(parent, 258);
        this.separator.setLayoutData((Object)new GridData(768));
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setLayout((Layout)new GridLayout());
        this.tabFolder = new TabFolder((Composite)this.sashForm, style);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        SelectionAdapter selectionApdater = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RMViewTabFolder.this.drawTabBody();
                RMViewTabFolder.this.drawInfoTable();
            }
        };
        this.tabFolder.addSelectionListener((SelectionListener)selectionApdater);
        this.createListViewer();
        this.createInfo((Composite)this.sashForm);
    }

    public void pack() {
        this.sashForm.pack();
    }

    public void createInfo(Composite parent) {
        this.InfoItemComp = new Composite(parent, 2048);
        this.InfoItemComp.setLayoutData((Object)new GridData(1808));
        GridLayout gl = GridLayoutFactory.fillDefaults().numColumns(2).create();
        gl.marginHeight += 5;
        gl.marginWidth += 5;
        this.InfoItemComp.setLayout((Layout)gl);
        this.directoryText = this.createInfoItem(this.InfoItemComp, "Directory");
        this.resolutionText = this.createInfoItem(this.InfoItemComp, "Resolution");
        this.languageText = this.createInfoItem(this.InfoItemComp, "Language");
    }

    public void drawInfoTable() {
        ResConfig.Item item = this.getSelectedItem();
        if (item == null) {
            return;
        }
        this.directoryText.setText(item.getDir());
        this.resolutionText.setText(item.getResolutionToString());
        this.languageText.setImage(item.getLocaleImage());
    }

    private Label createInfoItem(Composite parent, String title) {
        Label l = new Label(parent, 0);
        GridData gd = GridDataFactory.swtDefaults().create();
        gd.widthHint = 100;
        l.setLayoutData((Object)gd);
        l.setText(title);
        FontData fontData = l.getFont().getFontData()[0];
        Font font = new Font((Device)l.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        l.setFont(font);
        Label tt = new Label(parent, 0);
        GridData gd1 = new GridData(768);
        tt.setLayoutData((Object)gd1);
        return tt;
    }

    public void dispose() {
        this.projectName.dispose();
        this.separator.dispose();
        this.tabFolder.dispose();
        this.treeViewer.getControl().dispose();
        this.directoryText.dispose();
        this.resolutionText.dispose();
        this.languageText.dispose();
        this.sashForm.dispose();
    }

    public void removeAllListener() {
        if (this.selectionApdater != null) {
            this.tabFolder.removeSelectionListener((SelectionListener)this.selectionApdater);
        }
    }

    private void createListViewer() {
        Composite detailTabComposite = new Composite((Composite)this.tabFolder, 0x40000000);
        GridLayout detailTabGl = new GridLayout(1, false);
        detailTabGl.marginWidth = 0;
        detailTabGl.marginHeight = 0;
        detailTabComposite.setLayout((Layout)detailTabGl);
        detailTabComposite.setLayoutData((Object)new GridData(1, 128, true, true));
        this.treeViewer = new TreeViewer(detailTabComposite, 2);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new RMTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RMTreeLabelProvider());
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        this.treeViewer.addDropSupport(3, transfers, (DropTargetListener)new PluginDropAdapter((StructuredViewer)this.treeViewer){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 2;
                super.dragEnter(event);
            }

            public boolean performDrop(Object data) {
                String[] datas;
                ArrayList<String> sourcePathList = new ArrayList<String>();
                ArrayList<String> destPathList = new ArrayList<String>();
                IResource destRes = (IResource)this.getCurrentTarget();
                String destPath = null;
                if (destRes == null) {
                    return false;
                }
                if (1 == destRes.getType()) {
                    destPath = destRes.getParent().getLocation().toOSString();
                } else if (2 == destRes.getType()) {
                    destPath = destRes.getLocation().toOSString();
                }
                String[] stringArray = datas = (String[])data;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    String fileName = new File(source).getName();
                    String dest = FileUtil.appendPath((String)destPath, (String)fileName);
                    if (this.canCopy(source, dest)) {
                        sourcePathList.add(source);
                        destPathList.add(dest);
                    }
                    ++n2;
                }
                RMViewTabFolder.this.rmView.createDefaultItem();
                DirectoryCopyHandlingCommand command = new DirectoryCopyHandlingCommand(sourcePathList, destPathList);
                CommonPlugin.getDefault().getExecutor().execute(new Command[]{command});
                try {
                    RMViewTabFolder.this.rmView.getProject().refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
                return true;
            }

            protected Object determineTarget(DropTargetEvent event) {
                Widget widget = event.item;
                if (widget == null) {
                    return RMViewTabFolder.this.getSelectedItem().getResource();
                }
                ResConfig.Key key = (ResConfig.Key)widget.getData();
                return key.getRes();
            }

            private boolean canCopy(String src, String dest) {
                File srcFile = new File(src);
                File destFile = new File(dest);
                while (destFile != null) {
                    if (destFile.equals(srcFile)) {
                        return false;
                    }
                    destFile = destFile.getParentFile();
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                super.validateDrop(target, operation, transferType);
                return true;
            }
        });
        transfers = new Transfer[]{TextTransfer.getInstance(), TemplateTransfer.getInstance(), FileTransfer.getInstance()};
        this.treeViewer.addDragSupport(3, transfers, (DragSourceListener)new TreeDragSourceEffect(this.treeViewer.getTree()){

            public void dragStart(DragSourceEvent event) {
                event.doit = true;
                super.dragStart(event);
            }

            public void dragSetData(DragSourceEvent event) {
                List<ResConfig.Key> keys = RMViewTabFolder.this.getSelectedKeys();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] fileArray = new String[keys.size()];
                    int i = 0;
                    while (i < keys.size()) {
                        ResConfig.Key key = keys.get(i);
                        fileArray[i] = key.getRes().getLocation().toFile().toString();
                        ++i;
                    }
                    event.data = fileArray;
                } else if (TemplateTransfer.getInstance().isSupportedType(event.dataType)) {
                    ResConfig.Key key = keys.get(0);
                    if (key.isKey()) {
                        event.data = key.getKeyString();
                    } else {
                        event.data = null;
                        event.doit = false;
                    }
                } else {
                    ResConfig.Key key = keys.get(0);
                    if (key.isKey()) {
                        event.data = String.format("app_resource_manager_get(APP_RESOURCE_TYPE_IMAGE, \"%s\", &res_path);", key.getKeyString());
                    } else {
                        event.data = null;
                        event.doit = false;
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] fileStrings;
                    String[] stringArray = fileStrings = (String[])event.data;
                    int n = fileStrings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileString = stringArray[n2];
                        new File(fileString).delete();
                        ++n2;
                    }
                }
            }
        });
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return e1.toString().compareTo(e2.toString());
            }
        });
        this.addMenu();
    }

    private void addMenu() {
        this.menuMgr = new MenuManager("Resource Manager MenuMgr");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object action : RMViewTabFolder.this.rmView.getActions(RMViewTabFolder.this.getSelectedItem())) {
                    if (action instanceof IAction) {
                        manager.add((IAction)action);
                        continue;
                    }
                    manager.add((IContributionItem)action);
                }
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RMViewTabFolder.this.rmView.doOpenAction();
            }
        });
    }

    public void update(Set<ResConfig.Item> items) {
        this.removeTabItem(items);
        this.addTabItem(items);
        this.drawTabBody();
        this.drawInfoTable();
        this.projectName.setText(this.rmView.getProject().getName());
    }

    public void setEnabled(boolean isEnabled) {
        this.tabFolder.setEnabled(isEnabled);
    }

    public void setVisible(boolean isVisible) {
        this.tabFolder.setVisible(isVisible);
    }

    private void drawTabBody() {
        ResConfig.Item item = this.getSelectedItem();
        if (item == null) {
            return;
        }
        this.treeViewer.setInput((Object)item);
    }

    private void addTabItem(Set<ResConfig.Item> items) {
        ArrayList<ResConfig.Item> sortedList = new ArrayList<ResConfig.Item>(items);
        Collections.sort(sortedList);
        TabItem[] tabItems = this.tabFolder.getItems();
        boolean isExist = false;
        for (ResConfig.Item item : sortedList) {
            isExist = false;
            TabItem[] tabItemArray = tabItems;
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem tabItem = tabItemArray[n2];
                String dir = (String)tabItem.getData(DIRECTORY);
                if (item.getDirForResXml().equals(dir)) {
                    tabItem.setData(ITEM, (Object)item);
                    isExist = true;
                    break;
                }
                ++n2;
            }
            if (isExist) continue;
            this.createTabItem(item, sortedList.indexOf(item));
        }
    }

    private void removeTabItem(Set<ResConfig.Item> items) {
        TabItem[] tabItems = this.tabFolder.getItems();
        boolean isDelete = true;
        ArrayList<TabItem> removeTabItemList = new ArrayList<TabItem>();
        TabItem[] tabItemArray = tabItems;
        int n = tabItems.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            isDelete = true;
            for (ResConfig.Item item : items) {
                ResConfig.Item oldItem = (ResConfig.Item)tabItem.getData(ITEM);
                if (!oldItem.equals(item)) continue;
                isDelete = false;
                break;
            }
            if (isDelete) {
                removeTabItemList.add(tabItem);
            }
            ++n2;
        }
        for (TabItem tabItem : removeTabItemList) {
            tabItem.dispose();
        }
    }

    private TabItem createTabItem(ResConfig.Item item, int index) {
        TabItem tabItem = null;
        tabItem = index == -1 ? new TabItem(this.tabFolder, 0) : new TabItem(this.tabFolder, 0, index);
        tabItem.setData(DIRECTORY, (Object)item.getDirForResXml());
        tabItem.setData(ITEM, (Object)item);
        tabItem.setText(item.getName());
        tabItem.setControl((Control)this.treeViewer.getControl().getParent());
        if (item.getLocaleImage() == null || item.getResolutionImage() == null) {
            return tabItem;
        }
        CompositeImageDescriptor cid = new CompositeImageDescriptor(item){
            Image localeImage;
            Image resolutionImage;
            {
                this.localeImage = item.getLocaleImage();
                this.resolutionImage = item.getResolutionImage();
            }

            protected Point getSize() {
                return new Point(34, 16);
            }

            protected void drawCompositeImage(int arg0, int arg1) {
                Rectangle r = this.localeImage.getBounds();
                int y = 8 - r.height / 2;
                this.drawImage(this.localeImage.getImageData(), 0, y);
                this.drawImage(this.resolutionImage.getImageData(), 18, 0);
            }
        };
        tabItem.setImage(cid.createImage());
        return tabItem;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.tabFolder.addSelectionListener(listener);
    }

    public ResConfig.Item getSelectedItem() {
        return (ResConfig.Item)this.tabFolder.getSelection()[0].getData(ITEM);
    }

    private ResConfig.Key getSelectedKey() {
        Object[] items = this.treeViewer.getTree().getSelection();
        if (ArrayUtil.isEmpty((Object[])items)) {
            return null;
        }
        return (ResConfig.Key)items[0].getData();
    }

    public List<ResConfig.Key> getSelectedKeys() {
        ArrayList<ResConfig.Key> selectedKeyList = new ArrayList<ResConfig.Key>();
        TreeItem[] treeItemArray = this.treeViewer.getTree().getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            selectedKeyList.add((ResConfig.Key)treeItem.getData());
            ++n2;
        }
        return selectedKeyList;
    }
}

