/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.ui.properties.AbstractMultiPropertyPage;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.ui.multi.MultiCheckStateListener;
import org.tizen.nativecommon.ui.tpk.page.ReferencedProjectPackagePage;

public class MultiPropertyPage
extends AbstractMultiPropertyPage {
    private List<IProject> nativeUIProjectList = new ArrayList<IProject>();
    private List<IProject> nativeWidgetProjectList = new ArrayList<IProject>();
    private List<IProject> nativeServProjectList = new ArrayList<IProject>();
    private List<IProject> nativeSharedLibProjectList = new ArrayList<IProject>();
    private Composite parent;
    private CheckboxTableViewer uiProjectViewer;
    private CheckboxTableViewer widgetProjectViewer;
    private CheckboxTableViewer servProjectViewer;
    private ReferencedProjectPackagePage libraryViewer;

    protected Control createConfigurationContents(Composite parent) {
        this.parent = parent;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.divideRefProjects(projects);
        this.uiProjectViewer = this.addViewer(this.nativeUIProjectList, TizenProjectType.TIZEN_C_UI_APPLICATION);
        this.servProjectViewer = this.addViewer(this.nativeServProjectList, TizenProjectType.TIZEN_C_SERVICE_APPLICATION);
        this.widgetProjectViewer = this.addViewer(this.nativeWidgetProjectList, TizenProjectType.TIZEN_C_WIDGET_APPLICATION);
        this.createLibraryTableViewer(parent);
        return null;
    }

    private CheckboxTableViewer createCheckBoxTableViewer(Composite parent, boolean isMultiCheckbox) {
        Table table = new Table(parent, 68128);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        MultiCheckStateListener checkListener = new MultiCheckStateListener(viewer, isMultiCheckbox);
        viewer.addCheckStateListener((ICheckStateListener)checkListener);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        return viewer;
    }

    private void createLibraryTableViewer(Composite parent) {
        if (this.nativeSharedLibProjectList == null || this.nativeSharedLibProjectList.isEmpty()) {
            return;
        }
        Group group = (Group)this.createReferenceGroup(parent, TizenProjectType.TIZEN_C_SHAREDLIBRARY);
        group.setText("Shared Library Projects");
        this.libraryViewer = new ReferencedProjectPackagePage(this.getProject(), this.nativeSharedLibProjectList);
        this.libraryViewer.createReferencedProjectTable((Composite)group);
    }

    private CheckboxTableViewer addViewer(List<IProject> projectList, TizenProjectType type) {
        if (projectList == null || projectList.isEmpty()) {
            return null;
        }
        boolean isMultiCheckbox = true;
        IProject refProject = projectList.get(0);
        TizenProjectType refProjectType = ProjectUtil.getTizenProjectType((IProject)refProject);
        TizenProjectType projectType = ProjectUtil.getTizenProjectType((IProject)this.getProject());
        TizenProjectType.SubProjectType subProjectType = projectType.getAvailableSubProjectType(refProjectType);
        if (subProjectType == null || subProjectType.getSelectableReferenceNum().equals((Object)TizenProjectType.SelectableReferenceNum.ZERO)) {
            return null;
        }
        if (subProjectType.getSelectableReferenceNum().equals((Object)TizenProjectType.SelectableReferenceNum.ONE)) {
            isMultiCheckbox = false;
        } else if (subProjectType.getSelectableReferenceNum().equals((Object)TizenProjectType.SelectableReferenceNum.NATURAL)) {
            isMultiCheckbox = true;
        }
        Composite group = this.createReferenceGroup(this.parent, type);
        CheckboxTableViewer viewer = this.createCheckBoxTableViewer(group, isMultiCheckbox);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)element;
                return project.getName();
            }
        });
        viewer.setInput(projectList);
        this.initCheck(projectList, viewer);
        return viewer;
    }

    private void initCheck(List<IProject> projectList, CheckboxTableViewer viewer) {
        TizenProjectDescription desc = ProjectUtil.getTizenProjectDescription((IProject)this.getProject());
        List subProjectList = desc.getSubProjectList();
        for (IProject project : projectList) {
            for (TizenProjectDescription.RefTizenProject subProject : subProjectList) {
                if (!project.getName().equals(subProject.getName())) continue;
                viewer.setChecked((Object)project, true);
            }
        }
    }

    private void divideRefProjects(IProject[] refProjectList) {
        IProject project = this.getProject();
        IProject[] iProjectArray = refProjectList;
        int n = refProjectList.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (!refProject.equals((Object)project)) {
                TizenProjectType refType = ProjectUtil.getTizenProjectType((IProject)refProject);
                if (TizenProjectType.TIZEN_C_UI_APPLICATION.equals((Object)refType)) {
                    this.nativeUIProjectList.add(refProject);
                } else if (TizenProjectType.TIZEN_C_SERVICE_APPLICATION.equals((Object)refType)) {
                    this.nativeServProjectList.add(refProject);
                } else if (TizenProjectType.TIZEN_C_WIDGET_APPLICATION.equals((Object)refType)) {
                    this.nativeWidgetProjectList.add(refProject);
                } else if (TizenProjectType.TIZEN_C_SHAREDLIBRARY.equals((Object)refType)) {
                    this.nativeSharedLibProjectList.add(refProject);
                }
            }
            ++n2;
        }
    }

    protected List<TizenProjectDescription.RefTizenProject> getSelectedProjects() {
        ArrayList<TizenProjectDescription.RefTizenProject> refTizenProjectList = new ArrayList<TizenProjectDescription.RefTizenProject>();
        refTizenProjectList.addAll(this.getCheckedTizenProject(this.uiProjectViewer));
        refTizenProjectList.addAll(this.getCheckedTizenProject(this.servProjectViewer));
        refTizenProjectList.addAll(this.getCheckedTizenProject(this.widgetProjectViewer));
        return refTizenProjectList;
    }

    private List<TizenProjectDescription.RefTizenProject> getCheckedTizenProject(CheckboxTableViewer viewer) {
        ArrayList<TizenProjectDescription.RefTizenProject> refTizenProjectList = new ArrayList<TizenProjectDescription.RefTizenProject>();
        if (viewer == null) {
            return refTizenProjectList;
        }
        Object[] objectArray = viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            IProject project = (IProject)obj;
            refTizenProjectList.add(new TizenProjectDescription.RefTizenProject(project.getName(), ""));
            ++n2;
        }
        return refTizenProjectList;
    }

    public boolean performOk() {
        List<Object> selectedDataList = new ArrayList();
        if (this.libraryViewer != null) {
            selectedDataList = this.libraryViewer.getSelectedData();
            this.libraryViewer.saveReferencedProject();
        }
        try {
            IProject project = this.getProject();
            IProjectDescription eclipseDesc = project.getDescription();
            IProject[] refProjectArray = eclipseDesc.getReferencedProjects();
            boolean isFlag = false;
            HashSet<Object> newRefProjectList = new HashSet<Object>();
            for (ReferencedProjectPackagePage.InputData inputData : selectedDataList) {
                newRefProjectList.add(inputData.getProject());
            }
            HashSet<IProject> hashSet = new HashSet<IProject>();
            HashSet<IProject> oldRefProjectList = new HashSet<IProject>();
            IProject[] iProjectArray = refProjectArray;
            int n = refProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject oldRefProject = iProjectArray[n2];
                isFlag = true;
                for (String refTizenProject : this.getOldDesc().getReferencedLibraryProjectMap().keySet()) {
                    if (!oldRefProject.getName().equals(refTizenProject)) continue;
                    hashSet.add(oldRefProject);
                    isFlag = false;
                    break;
                }
                if (isFlag) {
                    oldRefProjectList.add(oldRefProject);
                }
                ++n2;
            }
            CommonConfigurationManager.removeReferencedProjectOptions((IProject)project, hashSet);
            CommonConfigurationManager.addReferencedProjectOptions((IProject)project, newRefProjectList);
            newRefProjectList.addAll(oldRefProjectList);
            eclipseDesc.setReferencedProjects(newRefProjectList.toArray(new IProject[newRefProjectList.size()]));
            this.getProject().setDescription(eclipseDesc, null);
        }
        catch (CoreException coreException) {
            return false;
        }
        return super.performOk();
    }
}

