/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.PlatformChangingManager;
import org.tizen.nativecommon.launch.LaunchInfo;
import org.tizen.nativecommon.launch.LaunchListener;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;

public abstract class AbstractTizenCLaunchDelegate
extends AbstractCLaunchDelegate {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ILaunch launch;
    private static Set<LaunchListener> launchListeners = new LinkedHashSet<LaunchListener>();
    private IProject project;
    private List orderedProjects;
    private String preLaunchBuildConfiguration;
    private boolean workspaceBuildBeforeLaunch;
    private boolean buildFailed;

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.workspaceBuildBeforeLaunch = true;
        int buildBeforeLaunchValue = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2);
        if (buildBeforeLaunchValue == 0) {
            return false;
        }
        if (this.orderedProjects == null) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int scale = 1000;
        int totalWork = (this.orderedProjects.size() + 1) * scale;
        this.buildFailed = false;
        UserLogger.start((String)"native.launch", (String)".buildForLaunch");
        try {
            monitor.beginTask("Building prerequisite project list", totalWork);
            try {
                this.setBuildConfiguration(configuration, this.project);
                for (IProject proj : this.orderedProjects) {
                    monitor.subTask("Building " + proj.getName());
                    this.changePlatform(configuration, proj);
                    proj.build(10, (IProgressMonitor)new BuildProgressMonitor(monitor, scale));
                }
                monitor.subTask("Building " + this.project.getName());
                this.project.build(10, (IProgressMonitor)new BuildProgressMonitor(monitor, scale));
            }
            catch (Exception exception) {
                this.buildFailed = true;
            }
        }
        finally {
            monitor.done();
            UserLogger.end((String)"native.launch", (String)".buildForLaunch");
        }
        return false;
    }

    private void setBuildConfiguration(ILaunchConfiguration configuration, IProject buildProject) {
        try {
            ICConfigurationDescription buildConfiguration;
            ICProjectDescription projDes = CDTPropertyManager.getProjectDescription((IProject)buildProject);
            String buildConfigID = null;
            if (configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", false)) {
                String programPath = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                ICConfigurationDescription buildConfig = org.eclipse.cdt.launch.LaunchUtils.getBuildConfigByProgramPath((IProject)buildProject, (String)programPath);
                if (buildConfig != null) {
                    buildConfigID = buildConfig.getId();
                }
            } else {
                buildConfigID = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            }
            if (buildConfigID != null && buildConfigID.length() > 0 && projDes != null && (buildConfiguration = projDes.getConfigurationById(buildConfigID)) != null) {
                this.preLaunchBuildConfiguration = projDes.getActiveConfiguration().getId();
                buildConfiguration.setActive();
                this.changePlatform(configuration, buildProject);
                CDTPropertyManager.performOk(null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void changePlatform(ILaunchConfiguration configuration, IProject project) {
        DeviceDescriptor device = ConnectionPlugin.getDefault().getTargetToolBarManager().getDefaultDeviceDescriptor();
        String defaultArch = LaunchUtils.ARCH_86_SYMBOL;
        if (device != null && device.getDeviceState() == 32) {
            defaultArch = device.getIDevice().getArch().getArch();
        }
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        String buildArch = CommonConfigurationManager.getArchitectureFromConfiguration(config);
        if (!LaunchUtils.getArch(defaultArch).equals(LaunchUtils.getArch(buildArch)) && !PlatformChangingManager.changePlatform(project, defaultArch, true)) {
            this.logger.error("Failed to change architecture to " + defaultArch);
        }
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!this.workspaceBuildBeforeLaunch && 1 == configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2)) {
            try {
                BuildProgressMonitor buildMonitor = new BuildProgressMonitor(monitor, 10, 4);
                buildMonitor.beginTask("Build before launch - ", 10);
                buildMonitor.subTask("Performing required build...");
                if (this.buildForLaunch(configuration, mode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)buildMonitor, 7))) {
                    buildMonitor.subTask("Performing incremental workspace build...");
                    ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)buildMonitor, 3));
                } else {
                    buildMonitor.worked(3);
                }
            }
            catch (Exception exception) {
                this.buildFailed = true;
            }
        }
        if (monitor.isCanceled()) {
            if (this.launch != null) {
                if (!this.launch.isTerminated()) {
                    this.launch.terminate();
                }
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunch(this.launch);
            }
            LaunchUtils.newCoreException(8, null, null);
        }
        boolean continueLaunch = true;
        if (this.orderedProjects == null) {
            return continueLaunch;
        }
        int scale = 1000;
        int totalWork = (this.orderedProjects.size() + 1) * scale;
        try {
            IStatusHandler prompter;
            monitor.beginTask("Searching for compile errors", totalWork);
            boolean compileErrorsInProjs = this.buildFailed;
            if (!compileErrorsInProjs) {
                for (IProject proj : this.orderedProjects) {
                    monitor.subTask("Searching for compile errors in " + proj.getName());
                    monitor.worked(scale);
                    compileErrorsInProjs = this.existsErrors(proj);
                    if (compileErrorsInProjs) break;
                }
            }
            if (!compileErrorsInProjs) {
                monitor.subTask("Searching for compile errors in " + this.project.getName());
                monitor.worked(scale);
                compileErrorsInProjs = this.existsErrors(this.project);
            }
            if (!compileErrorsInProjs) {
                compileErrorsInProjs = this.verifyProjectError(this.project);
            }
            if (compileErrorsInProjs && (prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus)) != null) {
                continueLaunch = (Boolean)prompter.handleStatus(complileErrorPromptStatus, null);
            }
        }
        finally {
            monitor.done();
        }
        return continueLaunch;
    }

    private boolean verifyProjectError(IProject project) throws CoreException {
        int severity = org.tizen.common.util.ProjectUtil.getMaxProblemSeverity((IResource)project, (boolean)false);
        return severity >= 2;
    }

    private void resetBuildConfiguration(IProject buildProject) {
        if (this.preLaunchBuildConfiguration != null) {
            ICConfigurationDescription buildConfiguration;
            ICProjectDescription projDes = CDTPropertyManager.getProjectDescription((IProject)buildProject);
            if (this.preLaunchBuildConfiguration.length() > 0 && projDes != null && (buildConfiguration = projDes.getConfigurationById(this.preLaunchBuildConfiguration)) != null) {
                buildConfiguration.setActive();
                CDTPropertyManager.performOk(null);
            }
        }
        this.preLaunchBuildConfiguration = null;
    }

    private void getReferencedProjectSet(IProject proj, HashSet referencedProjSet) throws CoreException {
        IProject[] projects = proj.getReferencedProjects();
        int i = 0;
        while (i < projects.length) {
            IProject refProject = projects[i];
            if (refProject.exists() && !referencedProjSet.contains(refProject)) {
                referencedProjSet.add(refProject);
                this.getReferencedProjectSet(refProject, referencedProjSet);
            }
            ++i;
        }
    }

    private List getBuildOrder(List resourceCollection) {
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjs = new ArrayList<Object>(resourceCollection.size());
            ArrayList unorderedProjects = new ArrayList(resourceCollection.size());
            unorderedProjects.addAll(resourceCollection);
            int i = 0;
            while (i < orderedNames.length) {
                String projectName = orderedNames[i];
                int j = 0;
                while (j < resourceCollection.size()) {
                    IProject proj = (IProject)resourceCollection.get(j);
                    if (proj.getName().equals(projectName)) {
                        orderedProjs.add(proj);
                        unorderedProjects.remove(proj);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            orderedProjs.addAll(unorderedProjects);
            return orderedProjs;
        }
        IProject[] projects = new IProject[resourceCollection.size()];
        projects = resourceCollection.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjs = new ArrayList<IProject>();
        orderedProjs.addAll(Arrays.asList(po.projects));
        return orderedProjs;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!mode.equals("run")) {
            org.eclipse.cdt.launch.LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.cdigdbActivity", (boolean)true);
        }
        this.workspaceBuildBeforeLaunch = false;
        int scale = 1000;
        int totalWork = 2 * scale;
        try {
            monitor.beginTask("Building prerequisite project list", totalWork);
            this.orderedProjects = null;
            ICProject cProject = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cProject != null) {
                this.project = cProject.getProject();
                HashSet projectSet = new HashSet();
                this.getReferencedProjectSet(this.project, projectSet);
                this.orderedProjects = this.getBuildOrder(new ArrayList(projectSet));
            }
            this.firePreLaunched(this.project, RdsPreferencePage.isRdsMode((IProject)this.project));
            monitor.worked(scale);
            boolean bl = super.preLaunchCheck(configuration, mode, (IProgressMonitor)new SubProgressMonitor(monitor, scale));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public static void addListener(LaunchListener listener) {
        launchListeners.add(listener);
    }

    public static void removeListener(LaunchListener listener) {
        launchListeners.remove(listener);
    }

    protected void firePreLaunched(IProject project, boolean isRdsMode) throws CoreException {
        LaunchInfo launchInfo = new LaunchInfo(project, isRdsMode);
        for (LaunchListener listener : launchListeners) {
            listener.preLaunched(launchInfo);
        }
    }

    protected void firePostLaunched(IProject project, boolean isRdsMode) throws CoreException {
        LaunchInfo launchInfo = new LaunchInfo(project, isRdsMode);
        for (LaunchListener listener : launchListeners) {
            listener.postLaunched(launchInfo);
        }
    }

    protected void verifyCProjectConfigurationSettings(ILaunchConfiguration config) throws CoreException {
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        ICProject cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        if (exePath != null) {
            this.verifyBinary(cproject, exePath);
        } else {
            LaunchUtils.newCoreException(TizenLaunchMessages.CANNOT_FIND_EXECUTABLE, null);
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.launch = super.getLaunch(configuration, mode);
        return this.launch;
    }

    static class BuildProgressMonitor
    extends SubProgressMonitor {
        private boolean cancelled;

        public BuildProgressMonitor(IProgressMonitor monitor, int ticks, int style) {
            super(monitor, ticks, style);
        }

        public BuildProgressMonitor(IProgressMonitor monitor, int ticks) {
            this(monitor, ticks, 0);
        }

        public void setCanceled(boolean b) {
            this.cancelled = b;
        }

        public boolean isCanceled() {
            return this.cancelled || super.isCanceled();
        }
    }
}

