/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.nativecommon.ProjectUtil;

public class LibraryArchitectureChecker {
    static final int MAX_LIB_COUNT = 1000;
    static final int MAX_DIR_COUNT = 100;
    ArrayList<String> libDirList;
    String libProjectPath;
    int libCount;
    int dirCount;

    public boolean validateLibraryArchitecture(ILaunchConfiguration config) {
        IProject project = null;
        if (config == null) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        try {
            project = ProjectUtil.getProject(config);
        }
        catch (CoreException coreException) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        return this.validateLibraryArchitecture(project);
    }

    public boolean validateLibraryArchitecture(IProject project) {
        IConfiguration config = null;
        String exePath = null;
        File exeFile = null;
        if (project == null) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        try {
            config = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            exePath = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + config.getName() + File.separatorChar + ProjectUtil.getBinaryName(project);
            exeFile = new File(exePath);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        if (exeFile == null || !exeFile.exists()) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        File buildOutputFile = new File(exePath);
        if (buildOutputFile == null || !buildOutputFile.exists() || !buildOutputFile.isFile()) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        Elf exeElf = null;
        int exeArch = -1;
        try {
            exeElf = new Elf(buildOutputFile.getPath());
            exeArch = exeElf.getELFhdr().e_machine;
        }
        catch (IOException iOException) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        File libDir = new File(project.getLocation().append("lib").toString());
        if (libDir == null || !libDir.exists() || !libDir.isDirectory()) {
            DialogUtil.openErrorDialog((Shell)DialogUtil.getActiveShell(), (String)"Packaging Error", (String)"Error occurred while validating library architecture");
            return false;
        }
        File[] libFiles = libDir.listFiles();
        if (libFiles == null) {
            return true;
        }
        this.libProjectPath = String.valueOf(project.getLocation().removeLastSegments(1).toOSString()) + File.separatorChar;
        this.libDirList = new ArrayList();
        this.libCount = 0;
        this.dirCount = 0;
        ArrayList<String> libListArr = this.checkLibraryDir(libDir, exeArch);
        if (libListArr != null && libListArr.size() != 0) {
            AtomicInteger retValue;
            block15: {
                String libsString = "";
                int i = 0;
                while (i < libListArr.size()) {
                    libsString = String.valueOf(libsString) + libListArr.get(i) + "\n";
                    ++i;
                }
                retValue = new AtomicInteger();
                final LibraryArchitectureConfirmDialog lacDlg = new LibraryArchitectureConfirmDialog(ViewUtil.getWorkbenchWindow().getShell(), exeElf.getAttributes().getCPU(), libsString);
                SWTUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int ret = lacDlg.open();
                        retValue.set(ret);
                    }
                });
                if (retValue.get() != 0) break block15;
                return true;
            }
            try {
                if (retValue.get() == 1) {
                    return false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private ArrayList<String> checkLibraryDir(File curDir, int exeArch) {
        ArrayList<String> retList = new ArrayList<String>();
        Elf libElf = null;
        if (curDir == null || !curDir.exists() || !curDir.isDirectory()) {
            return retList;
        }
        File[] libFiles = curDir.listFiles();
        if (libFiles == null) {
            return retList;
        }
        try {
            if (this.libDirList == null) {
                return retList;
            }
            if (this.libDirList.contains(curDir.getCanonicalPath())) {
                return retList;
            }
            this.libDirList.add(curDir.getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ++this.dirCount;
        if (this.dirCount > 100 || this.libCount > 1000) {
            return retList;
        }
        int i = 0;
        while (i < libFiles.length && this.libCount <= 1000) {
            if (libFiles[i].isFile()) {
                ++this.libCount;
                try {
                    libElf = new Elf(libFiles[i].getCanonicalPath());
                    if (libElf != null && libElf.getELFhdr().e_machine != exeArch) {
                        String libItemStr = libFiles[i].getPath().replace(this.libProjectPath, "");
                        if (!libFiles[i].getPath().equals(libFiles[i].getCanonicalPath())) {
                            libItemStr = String.valueOf(libItemStr) + " -> " + libFiles[i].getCanonicalPath().replace(this.libProjectPath, "");
                        }
                        retList.add(String.valueOf(libItemStr) + " [" + libElf.getAttributes().getCPU() + "]");
                    }
                }
                catch (IOException iOException) {}
            } else if (libFiles[i].isDirectory()) {
                retList.addAll(this.checkLibraryDir(libFiles[i], exeArch));
            }
            ++i;
        }
        return retList;
    }

    public class LibraryArchitectureConfirmDialog
    extends ErrorDialog {
        String libList;

        public LibraryArchitectureConfirmDialog(Shell parentShell, String exeArch, String libList) {
            super(parentShell, "Confirm Packaging", null, (IStatus)new Status(2, "org.tizen.common.sign", "\"" + exeArch + "\" packaging...\nIn lib folder, there are libraries that not " + exeArch + " architecture.\n\nContinue packaging?"), 2);
            this.libList = libList;
        }

        protected Control createDialogArea(Composite parent) {
            super.createDialogArea(parent);
            Text libList = new Text(parent, 2826);
            libList.setText(this.libList);
            libList.setLayoutData((Object)new GridData(1808));
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createButton(parent, 0, "Continue", true);
        }

        protected Point getInitialSize() {
            return new Point(500, 300);
        }
    }
}

