/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.view;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.ui.sa.view.TizenSAView;

public class TizenSAViewToolBar {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Text txtFile;
    private Button btnBrowse;
    private ToolItem drop;
    private ToolItem expand;
    private ToolItem collapse;
    private Menu dropMenu;
    private TizenSAView viewer;
    private MenuItem miWarning;
    private MenuItem miFile;
    private final int FILE_TEXT_SIZE = 200;
    SelectionListener expandListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TreeViewer treeViewer = TizenSAViewToolBar.this.viewer.getTreeViewer();
            if (treeViewer != null) {
                treeViewer.expandAll();
            }
        }
    };
    SelectionListener collapseListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            TreeViewer treeViewer = TizenSAViewToolBar.this.viewer.getTreeViewer();
            if (treeViewer != null) {
                treeViewer.collapseAll();
            }
        }
    };
    SelectionListener btnBrowserListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            DirectoryDialog dirDialog = new DirectoryDialog(SWTUtil.getShell());
            String selected = dirDialog.open();
            if (StringUtil.isEmpty((CharSequence)selected)) {
                return;
            }
            try {
                TizenSAView view = (TizenSAView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.tizen.nativecommon.ui.view.tizensa");
                view.refresh(selected);
            }
            catch (PartInitException e) {
                TizenSAViewToolBar.this.logger.warn("Failed to open a view for TizenSA", (Throwable)e);
            }
        }
    };
    SelectionListener groupByFileListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (TizenSAViewToolBar.this.miWarning != null) {
                TizenSAViewToolBar.this.miWarning.setSelection(false);
            }
            TizenSAViewToolBar.this.viewer.refresh();
        }
    };
    SelectionListener groupByWarningListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            if (TizenSAViewToolBar.this.miFile != null) {
                TizenSAViewToolBar.this.miFile.setSelection(false);
            }
            TizenSAViewToolBar.this.viewer.refresh();
        }
    };

    public TizenSAViewToolBar(Composite parent, int style, TizenSAView viewer) {
        this.viewer = viewer;
        GridLayout parentLayout = new GridLayout(1, false);
        GridData parentGd = new GridData(4, 4, true, false);
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayoutData((Object)parentGd);
        parent.setLayout((Layout)parentLayout);
        Composite toolBarLeft = new Composite(parent, 0);
        GridData leftGd = new GridData(4, 0x1000000, true, true);
        toolBarLeft.setLayoutData((Object)leftGd);
        GridLayout leftGl = new GridLayout(2, false);
        leftGl.marginHeight = 0;
        leftGl.marginWidth = 0;
        toolBarLeft.setLayout((Layout)leftGl);
        this.drawToolBarLeft(toolBarLeft);
        Composite toolBarRight = new Composite(parent, 0);
        GridData rightGd = new GridData(0x1000008, 128, false, false);
        toolBarRight.setLayoutData((Object)rightGd);
        GridLayout rightGl = new GridLayout(3, false);
        rightGl.marginHeight = 0;
        rightGl.marginWidth = 0;
        toolBarRight.setLayout((Layout)rightGl);
        this.drawToolBarRight(toolBarRight);
    }

    public boolean isGroupByWarningMode() {
        if (this.miWarning != null) {
            return this.miWarning.getSelection();
        }
        return true;
    }

    public void updateTxtFile(String file) {
        String txtFileText = file;
        int txtSize = 0;
        Path path = new Path(file);
        int maxLbSize = this.txtFile.getParent().getSize().x;
        int maxHeight = this.txtFile.getParent().getSize().y;
        this.txtFile.setText(txtFileText);
        int i = 0;
        while (i < 50) {
            this.txtFile.pack();
            txtSize = this.txtFile.getSize().x;
            if (txtSize <= maxLbSize) break;
            path = path.removeFirstSegments(1);
            txtFileText = path.toString();
            this.txtFile.setText(".../" + txtFileText);
            ++i;
        }
        GridData lbFileGd = new GridData(4, 4, true, true);
        lbFileGd.widthHint = 200;
        this.txtFile.setToolTipText(file);
        this.txtFile.setSize(maxLbSize, maxHeight);
        this.txtFile.getParent().layout();
    }

    private void drawToolBarRight(Composite parent) {
        ImageDescriptor disableImageDesc;
        ImageDescriptor imageDesc;
        ToolBar toolBarForTool = new ToolBar(parent, 0x800000);
        toolBarForTool.setLayout((Layout)new FillLayout());
        ToolBar toolBarForDropDown = new ToolBar(parent, 0x800000);
        toolBarForDropDown.setLayout((Layout)new FillLayout());
        this.drop = new ToolItem(toolBarForDropDown, 131076);
        this.drop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 && TizenSAViewToolBar.this.dropMenu != null) {
                    ToolItem item = (ToolItem)event.widget;
                    Rectangle rect = item.getBounds();
                    Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                    TizenSAViewToolBar.this.dropMenu.setLocation(pt.x, pt.y + rect.height);
                    TizenSAViewToolBar.this.dropMenu.setVisible(true);
                }
            }
        });
        this.dropMenu = new Menu((Control)this.drop.getParent().getShell());
        this.miWarning = new MenuItem(this.dropMenu, 32);
        this.miWarning.addSelectionListener(this.groupByWarningListener);
        this.miWarning.setText("Group by warning");
        this.miWarning.setSelection(true);
        this.miFile = new MenuItem(this.dropMenu, 32);
        this.miFile.addSelectionListener(this.groupByFileListener);
        this.miFile.setText("Group by file");
        if (this.expand == null) {
            this.expand = new ToolItem(toolBarForTool, 8);
            imageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.tizen.nativecommon.ui", (String)"icons/elcl18/expandall.png");
            disableImageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.tizen.nativecommon.ui", (String)"icons/dlcl18/expandall.png");
            this.expand.setImage(imageDesc.createImage());
            this.expand.setDisabledImage(disableImageDesc.createImage());
            this.expand.addSelectionListener(this.expandListener);
        }
        if (this.collapse == null) {
            this.collapse = new ToolItem(toolBarForTool, 8);
            imageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.tizen.nativecommon.ui", (String)"icons/elcl18/collapseall.png");
            disableImageDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.tizen.nativecommon.ui", (String)"icons/dlcl18/collapseall.png");
            this.collapse.setImage(imageDesc.createImage());
            this.collapse.setDisabledImage(disableImageDesc.createImage());
            this.collapse.addSelectionListener(this.collapseListener);
        }
    }

    private void drawToolBarLeft(Composite parent) {
        this.txtFile = new Text(parent, 2052);
        this.txtFile.setEditable(false);
        GridData lbFileGd = new GridData(4, 4, true, true);
        lbFileGd.widthHint = 200;
        this.txtFile.setLayoutData((Object)lbFileGd);
        this.txtFile.pack();
        this.btnBrowse = new Button(parent, 8);
        this.btnBrowse.setText("...");
        this.btnBrowse.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.btnBrowse.pack();
        this.btnBrowse.addSelectionListener(this.btnBrowserListener);
    }
}

