/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.ui.CMainTab;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.ui.HelpToolTip;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;

public class TizenMainTab
extends CMainTab {
    private Button btnUpdateMode = null;
    private HelpToolTip toolTip = null;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createUpdateModeButton(comp, 1);
        this.createBuildOptionGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateUpdateMode(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.tizen.nativecommon.ATTR_LAUNCH_UPDATE_MODE", false);
        try {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            configuration.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", projectName);
        }
        catch (CoreException e) {
            this.logger.error("Failed to get projectName on launch configuration", (Throwable)e);
        }
    }

    protected void updateUpdateMode(ILaunchConfiguration config) {
        IProject project = null;
        if (config != null) {
            try {
                project = ProjectUtil.getProject(config);
            }
            catch (CoreException e) {
                this.btnUpdateMode.setEnabled(false);
                this.logger.error("Cannot find project", (Throwable)e);
                return;
            }
        }
        this.updateUpdateMode(project, config);
    }

    protected void updateUpdateMode(IProject project, ILaunchConfiguration config) {
        boolean isRds = RdsPreferencePage.isRdsMode((IProject)project);
        if (isRds) {
            this.btnUpdateMode.setEnabled(false);
        } else {
            this.btnUpdateMode.setEnabled(true);
            if (config != null) {
                this.btnUpdateMode.setSelection(LaunchUtils.isUpdateMode(config));
            }
        }
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        boolean renamed = false;
        IBinary binary = null;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            String configName = ProjectUtil.getLaunchConfigurationName(project);
            String binaryName = ProjectUtil.getBinaryName(project);
            configName = this.getLaunchConfigurationDialog().generateName(configName);
            config.rename(configName);
            renamed = true;
            IConfiguration defaultConfig = ProjectUtil.getDefaultConfiguration(project);
            if (defaultConfig != null) {
                String buildConfigName = defaultConfig.getName();
                IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
                if (bins != null) {
                    int i = 0;
                    while (i < bins.length) {
                        IPath binaryPath = bins[i].getPath();
                        String parentDirName = binaryPath.removeLastSegments(1).lastSegment();
                        if (parentDirName.equals(buildConfigName) && binaryPath.lastSegment().equals(binaryName)) {
                            binary = bins[i];
                            break;
                        }
                        ++i;
                    }
                }
            }
            LaunchUtils.setStopAtMain(config, project);
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (binary != null) {
            String path = binary.getResource().getProjectRelativePath().toOSString();
            config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", path);
            if (!renamed) {
                String name = binary.getElementName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
                name = this.getLaunchConfigurationDialog().generateName(name);
                config.rename(name);
                renamed = true;
            }
        }
        if (!renamed) {
            String name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    protected void createExeFileGroup(Composite parent, int colSpan) {
        super.createExeFileGroup(parent, colSpan);
        this.fProgText.setMessage(TizenLaunchMessages.PROJECT_NOT_BUILT);
        this.fProgText.setEnabled(false);
        this.fSearchButton.setEnabled(false);
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        Button button = super.createPushButton(parent, label, image);
        if ("B&rowse...".equals(label)) {
            button.setEnabled(false);
        }
        return button;
    }

    protected void createProjectGroup(Composite parent, int colSpan) {
        super.createProjectGroup(parent, colSpan);
        this.fProjText.setMessage(TizenLaunchMessages.PROJECT_NOT_SPECIFIED);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        if (this.fBuildConfigCombo != null) {
            config.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", (String)this.fBuildConfigCombo.getData(String.valueOf(Integer.toString(this.fBuildConfigCombo.getSelectionIndex())) + "name"));
        }
        config.setAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", this.fProjText.getText());
        config.setAttribute("org.tizen.nativecommon.ATTR_LAUNCH_UPDATE_MODE", this.btnUpdateMode.getSelection());
    }

    protected void updateBuildConfigCombo(String selectedConfigID) {
        if (this.fBuildConfigCombo != null) {
            ICProjectDescription projDes;
            this.fBuildConfigCombo.setEnabled(!this.fBuildConfigAuto.getSelection());
            this.fBuildConfigCombo.removeAll();
            this.fBuildConfigCombo.add(TizenLaunchMessages.TizenMainTab_Use_Active);
            this.fBuildConfigCombo.setData("0", (Object)"");
            this.fBuildConfigCombo.select(0);
            ICProject cproject = this.getCProject();
            if (cproject != null && (projDes = CDTPropertyManager.getProjectDescription((IProject)cproject.getProject())) != null) {
                ICConfigurationDescription autoConfig;
                String autoConfigId = null;
                if (this.fBuildConfigAuto.getSelection() && (autoConfig = org.eclipse.cdt.launch.LaunchUtils.getBuildConfigByProgramPath((IProject)cproject.getProject(), (String)this.fProgText.getText())) != null) {
                    autoConfigId = autoConfig.getId();
                }
                int selIndex = 0;
                ICConfigurationDescription[] configurations = projDes.getConfigurations();
                ICConfigurationDescription selectedConfig = projDes.getConfigurationById(selectedConfigID);
                int i = 0;
                while (i < configurations.length) {
                    String configName = configurations[i].getName();
                    this.fBuildConfigCombo.add(configName);
                    this.fBuildConfigCombo.setData(Integer.toString(i + 1), (Object)configurations[i].getId());
                    this.fBuildConfigCombo.setData(String.valueOf(Integer.toString(i + 1)) + "name", (Object)configurations[i].getName());
                    if (selectedConfig != null && selectedConfigID.equals(configurations[i].getId()) || this.fBuildConfigAuto.getSelection() && configurations[i].getId().equals(autoConfigId)) {
                        selIndex = i + 1;
                    }
                    ++i;
                }
                this.fBuildConfigCombo.select(selIndex);
            }
        }
    }

    protected void createUpdateModeButton(Composite parent, int colSpan) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        comp.setLayoutData((Object)gd);
        this.btnUpdateMode = new Button(comp, 32);
        this.btnUpdateMode.setText(TizenLaunchMessages.UPDATE_MODE_LABEL);
        this.btnUpdateMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TizenMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.toolTip = new HelpToolTip(comp);
        this.toolTip.setText(NLS.bind((String)TizenLaunchMessages.UPDATE_MODE_TOOLTIP_WITH_HELP, (Object)TizenLaunchMessages.UPDATE_MODE_TOOLTIP));
    }

    protected void updateLaunchConfigurationDialog() {
        String projectName = this.fProjText.getText();
        IProject project = null;
        if (!StringUtil.isEmpty((CharSequence)projectName)) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        this.updateUpdateMode(project, null);
        super.updateLaunchConfigurationDialog();
    }
}

