/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.Activator;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.IOUtil;

public class SigningProfileUtil {
    protected static final Logger logger = LoggerFactory.getLogger(SigningProfileUtil.class);
    protected static final String PROFILES_FILE = "profiles.xml";

    public static SigningProfileContainer getProfileContainerFromFile() {
        SigningProfileContainer container = new SigningProfileContainer();
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        InputStream inputStream = null;
        try {
            inputStream = SigningProfileUtil.openFileStream(profilesPath.toFile());
            if (inputStream != null) {
                container.readProfileXML(inputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{inputStream});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        return container;
    }

    public static InputStream openFileStream(File file) {
        try {
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (IllegalStateException e) {
            logger.error("Can't access state location", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("Can't open profile", (Throwable)e);
        }
        return null;
    }

    public static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static String getActiveProfileName() {
        return SigningProfileUtil.getPreferenceStore().getString("defaultprofile");
    }

    public static void setActiveProfileName(String profileName) {
        if (profileName == null) {
            profileName = "";
        }
        SigningProfileUtil.getPreferenceStore().setValue("defaultprofile", profileName);
    }

    public static IPath getProfilesPath() {
        return Activator.getDefault().getStateLocation().append(PROFILES_FILE);
    }

    public static boolean writeProfilesToFile(SigningProfileContainer container) {
        IPath profilesPath = SigningProfileUtil.getProfilesPath();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(profilesPath.toFile());
            container.writeProfileXML(outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                logger.error("Can't write a profile", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{outputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{outputStream});
            return false;
        }
        IOUtil.tryClose((Object[])new Object[]{outputStream});
        return true;
    }

    public static IPath getCertStorePath() {
        return new Path(InstallPathConfig.getUserDataPath()).append("keystore");
    }

    public static IPath getAuthorCertStorePath() {
        return SigningProfileUtil.getCertStorePath().append("author");
    }
}

