/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.view;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;
import org.tizen.nativecommon.sa.parser.TizenSAResultHandler;
import org.tizen.nativecommon.ui.sa.view.DetailTreeContentProvider;
import org.tizen.nativecommon.ui.sa.view.DetailTreeDoubleClickListener;
import org.tizen.nativecommon.ui.sa.view.DetailTreeLabelProvider;
import org.tizen.nativecommon.ui.sa.view.TizenSAViewToolBar;

public class TizenSAView
extends ViewPart {
    private TabFolder tabFolder;
    private final String[] tabNames = new String[]{"Report"};
    public static final String VIEW_ID = "org.tizen.nativecommon.ui.view.tizensa";
    private IProject project;
    private File outDir;
    private TreeViewer detailTreeViewer;
    ToolItem fileSep;
    Label lbFile;
    TizenSAViewToolBar toolBar;

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 18432);
        TabItem tabItem = null;
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(this.tabNames[0]);
        this.tabFolder.setBackgroundMode(1);
        Composite detailTabComposite = new Composite((Composite)this.tabFolder, 0x40000000);
        GridLayout detailTabGl = new GridLayout(1, false);
        detailTabGl.marginWidth = 0;
        detailTabGl.marginHeight = 0;
        detailTabComposite.setLayout((Layout)detailTabGl);
        detailTabComposite.setLayoutData((Object)new GridData(1, 128, true, false));
        Composite toolbarComp = new Composite(detailTabComposite, 0);
        toolbarComp.setLayout((Layout)detailTabGl);
        this.toolBar = new TizenSAViewToolBar(toolbarComp, 0x800000, this);
        GridData treeViewerGd = new GridData(1808);
        Composite treeViewerComp = new Composite(detailTabComposite, 0);
        treeViewerComp.setLayout((Layout)new FillLayout());
        treeViewerComp.setLayoutData((Object)treeViewerGd);
        this.detailTreeViewer = new TreeViewer(treeViewerComp);
        this.detailTreeViewer.setContentProvider((IContentProvider)new DetailTreeContentProvider());
        this.detailTreeViewer.setLabelProvider((IBaseLabelProvider)new DetailTreeLabelProvider());
        this.detailTreeViewer.addDoubleClickListener((IDoubleClickListener)new DetailTreeDoubleClickListener());
        tabItem.setControl((Control)detailTabComposite);
    }

    public void setFocus() {
    }

    public void refresh(IProject project, File outDir) {
        this.project = project;
        this.outDir = outDir;
        this.refresh();
    }

    public void refresh(String outDir) {
        this.outDir = new File(outDir);
        this.refresh();
    }

    public void refresh() {
        if (this.outDir == null || !this.outDir.exists()) {
            return;
        }
        Object root = this.getWarningRoot();
        this.detailTreeViewer.setInput(root);
        this.toolBar.updateTxtFile(this.outDir.getAbsolutePath());
    }

    public TreeViewer getTreeViewer() {
        return this.detailTreeViewer;
    }

    public Object getWarningRoot() {
        boolean isGroupBtWarningMode = this.toolBar.isGroupByWarningMode();
        if (isGroupBtWarningMode) {
            return TizenSAResultHandler.makeTizenSAModel((File)this.outDir);
        }
        return TizenSAResultHandler.makeTizenSAModelByFile((File)this.outDir);
    }
}

