/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Header;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.tools.Executable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlBookmarks
extends AbstractTool {
    public HtmlBookmarks() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The owner password if the file is encrypt"));
        this.arguments.add(new StringArgument(this, "css", "The path to a CSS file"));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Html Bookmarks", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Html Bookmarks OPENED ===");
    }

    @Override
    public void execute() {
        try {
            List list;
            Object v;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File file = (File)this.getValue("srcfile");
            PdfReader pdfReader = this.getValue("ownerpassword") == null ? new PdfReader(file.getAbsolutePath()) : new PdfReader(file.getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            File file2 = file.getParentFile();
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            File file3 = new File(file2, string + "_index.html");
            Document document = new Document();
            HtmlWriter.getInstance(document, new FileOutputStream(file3));
            Object object = this.getValue("css");
            if (object != null) {
                document.add(new Header("stylesheet", object.toString()));
            }
            if ((v = pdfReader.getInfo().get("Title")) == null) {
                document.addTitle("Index for " + file.getName());
            } else {
                document.addKeywords("Index for '" + v + "'");
            }
            Object v2 = pdfReader.getInfo().get("Keywords");
            if (v2 != null) {
                document.addKeywords((String)v2);
            }
            Object v3 = pdfReader.getInfo().get("Subject");
            if (v2 != null) {
                document.addSubject((String)v3);
            }
            document.open();
            Paragraph paragraph = v == null ? new Paragraph("Index for " + file.getName()) : new Paragraph("Index for '" + v + "'");
            document.add(paragraph);
            if (v3 != null) {
                list = new Paragraph((String)v3);
                document.add((Element)((Object)list));
            }
            if ((list = SimpleBookmark.getBookmark(pdfReader)) == null) {
                document.add(new Paragraph("This document has no bookmarks."));
            } else {
                for (HashMap hashMap : list) {
                    Chapter chapter = (Chapter)HtmlBookmarks.createBookmark(file.getName(), null, hashMap);
                    List list2 = (List)hashMap.get("Kids");
                    if (list2 != null) {
                        for (HashMap hashMap2 : list2) {
                            HtmlBookmarks.addBookmark(file.getName(), chapter, hashMap2);
                        }
                    }
                    document.add(chapter);
                }
            }
            document.close();
            Executable.launchBrowser(file3.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    private static void addBookmark(String string, Section section, HashMap<String, Object> hashMap) {
        Section section2 = HtmlBookmarks.createBookmark(string, section, hashMap);
        List list = (List)hashMap.get("Kids");
        if (list == null) {
            return;
        }
        for (HashMap hashMap2 : list) {
            HtmlBookmarks.addBookmark(string, section2, hashMap2);
        }
    }

    private static Section createBookmark(String string, Section section, HashMap<String, Object> hashMap) {
        Paragraph paragraph = new Paragraph((String)hashMap.get("Title"));
        System.out.println((String)hashMap.get("Title"));
        String string2 = (String)hashMap.get("Action");
        if ("GoTo".equals(string2)) {
            if (hashMap.get("Page") != null) {
                String string3 = (String)hashMap.get("Page");
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                String string4 = stringTokenizer.nextToken();
                Anchor anchor = new Anchor(" page" + string4);
                anchor.setReference(string + "#page=" + string4);
                paragraph.add(anchor);
            }
        } else if ("URI".equals(string2)) {
            String string5 = (String)hashMap.get("URI");
            Anchor anchor = new Anchor(" Goto URL");
            anchor.setReference(string5);
            paragraph.add(anchor);
        } else if ("GoToR".equals(string2)) {
            String string6 = (String)hashMap.get("File");
            Anchor anchor = new Anchor(" goto " + string6);
            if (hashMap.get("Named") != null) {
                String string7 = (String)hashMap.get("Named");
                string6 = string6 + "#nameddest=" + string7;
            } else if (hashMap.get("Page") != null) {
                String string8 = (String)hashMap.get("Page");
                StringTokenizer stringTokenizer = new StringTokenizer(string8);
                String string9 = stringTokenizer.nextToken();
                anchor.add(new Chunk(" page " + string9));
                string6 = string6 + "#page=" + string9;
            }
            anchor.setReference(string6);
            paragraph.add(anchor);
        }
        Section section2 = section == null ? new Chapter(paragraph, 0) : section.addSection(paragraph);
        section2.setNumberDepth(0);
        return section2;
    }

    @Override
    public void valueHasChanged(AbstractArgument abstractArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        HtmlBookmarks htmlBookmarks = new HtmlBookmarks();
        if (stringArray.length < 1) {
            System.err.println(htmlBookmarks.getUsage());
        }
        htmlBookmarks.setMainArguments(stringArray);
        htmlBookmarks.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        HtmlBookmarks.addVersion("$Id: HtmlBookmarks.java 3373 2008-05-12 16:21:24Z xlv $");
    }
}

