/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenAttachSelector;
import org.tizen.nativecommon.launch.TizenDeviceProcessList;
import org.tizen.nativecommon.launch.TizenLaunchDelegate;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.TizenProcessInfo;
import org.tizen.nativecommon.launch.ui.LaunchImages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.ApplicationUtil;

public class TizenAttachDelegate
extends TizenLaunchDelegate {
    private final Logger logger = LoggerFactory.getLogger(TizenAttachDelegate.class);
    protected Integer pid = -1;
    private boolean isAutoDebugAttach = false;
    private boolean isIme = false;

    @Override
    protected boolean canDebugProject(ILaunchConfiguration config) throws CoreException {
        return true;
    }

    @Override
    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask(TizenLaunchMessages.LAUNCH_APPLICATION, 10);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.isAutoDebugAttach = true;
            this.launchApplicationWithGDBServer(launch, config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.launchApplicationWithGDBClient(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected String getGdbserverRunCommand(ILaunchConfiguration config) throws CoreException {
        IBinaryParser.IBinaryObject exeFile = this.getBinaryObject(config);
        String binaryFullName = exeFile.getName();
        String binaryName = FileUtil.getFileNameWithoutExtension((String)binaryFullName);
        String appId = config.getAttribute("org.tizen.nativecommon.launch.app.id", "");
        this.setPID(binaryName, appId);
        if (this.pid.equals(-1) || this.pid.equals(0)) {
            this.newCoreException(NLS.bind((String)TizenLaunchMessages.CANNOT_LAUNCH_FIND_PROCESS, (Object)appId, (Object)this.currentDevice.getSerialNumber()), null);
        }
        String debugFormat = TizenPlatformConstants.DEBUG_ATTACH_CMD_FORMAT;
        String gdbserverPort = LaunchUtils.getGdbserverPort(config);
        String gdbserverCmd = String.format(debugFormat, appId, gdbserverPort, this.pid.toString());
        return gdbserverCmd;
    }

    private void setPID(final String binaryName, final String appId) throws OperationCanceledException {
        final AtomicReference exRef = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TizenAttachDelegate.this.pid = TizenAttachDelegate.this.promptForProcessID(binaryName, appId);
                }
                catch (OperationCanceledException oce) {
                    exRef.set(oce);
                }
            }
        });
        OperationCanceledException ex = (OperationCanceledException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
    }

    private Integer promptForProcessID(String binaryName, String appId) {
        try {
            if (this.isAutoDebugAttach) {
                int pid = -1;
                try {
                    boolean isRoot = "disabled".equals(this.currentDevice.getPlatformCapability().getAppid2pidSupport());
                    if (isRoot) {
                        if (this.isIme) {
                            IProcessInfo pInfo = this.getIMEProcessInfo(binaryName, appId);
                            if (pInfo != null) {
                                pid = pInfo.getPid();
                            }
                        } else {
                            pid = ApplicationUtil.getPid((IDevice)this.currentDevice, (String)appId, (String)binaryName);
                        }
                    } else {
                        pid = ApplicationUtil.getPid((IDevice)this.currentDevice, (String)appId, (String)binaryName);
                    }
                }
                catch (IOException iOException) {
                    return -1;
                }
                if (pid < 1) {
                    this.logger.error("Could not check the application is running or not.");
                    return 0;
                }
                return pid;
            }
            return this.selectProcess(binaryName, appId);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private IProcessInfo getProcessInfo(IProcessInfo[] pInfos, String binaryName, String appId) throws CoreException {
        if (StringUtil.isEmpty((CharSequence)appId)) {
            return null;
        }
        IProcessInfo pInfo = null;
        IProcessInfo[] iProcessInfoArray = pInfos;
        int n = pInfos.length;
        int n2 = 0;
        while (n2 < n) {
            String infoBinaryName;
            IProcessInfo info = iProcessInfoArray[n2];
            String infoName = info.getName();
            if (infoName.contains(appId) && (infoBinaryName = StringUtil.getLastStringAfter((String)infoName, (String)"/")) != null && infoBinaryName.equals(binaryName)) {
                pInfo = info;
                break;
            }
            ++n2;
        }
        return pInfo;
    }

    private IProcessInfo getIMEProcessInfo(String binaryName, String appId) throws CoreException {
        TizenProcessInfo[] pInfos;
        TizenDeviceProcessList processList = new TizenDeviceProcessList(this.currentDevice, null, null);
        TizenProcessInfo[] tizenProcessInfoArray = pInfos = processList.getProcessList();
        int n = pInfos.length;
        int n2 = 0;
        while (n2 < n) {
            TizenProcessInfo info = tizenProcessInfoArray[n2];
            String cmd = info.getCmd();
            if (cmd.contains("scim-helper-launcher") && cmd.contains(appId)) {
                return info;
            }
            ++n2;
        }
        return null;
    }

    private IProcessInfo[] getProcessInfos() throws CoreException {
        IProcessInfo[] pInfos = null;
        TizenDeviceProcessList processList = null;
        processList = new TizenDeviceProcessList(this.currentDevice, String.valueOf(this.currentDevice.getAppInstallPath()) + "/", "/opt/apps/");
        pInfos = processList.getProcessList();
        if (pInfos == null) {
            this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_PROCESS_LIST, null);
        }
        return pInfos;
    }

    private Integer selectProcess(String binaryName, String appId) throws CoreException {
        Shell shell = SWTUtil.getShell();
        if (shell == null) {
            this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_SHELL, null);
        }
        LabelProvider topprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo pinfo = (IProcessInfo)element;
                Path ppath = new Path(pinfo.getName());
                return String.format("%s (%s)", ppath.lastSegment(), pinfo.getPid());
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_DEBUG);
            }
        };
        LabelProvider downprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                return info.getName();
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_DEBUG);
            }
        };
        TizenAttachSelector dlg = new TizenAttachSelector(shell, (ILabelProvider)topprovider, (ILabelProvider)downprovider);
        dlg.setTitle("Tizen Native Application - Attach");
        dlg.setMessage("Select a process (pid) to attach:");
        Object[] pInfos = this.getProcessInfos();
        dlg.setElements(pInfos);
        this.setDefaultSelection((IProcessInfo[])pInfos, dlg, binaryName, appId);
        int result = dlg.open();
        if (result == 0) {
            IProcessInfo info = (IProcessInfo)dlg.getFirstResult();
            if (info != null) {
                return info.getPid();
            }
        } else if (result == 1) {
            throw new OperationCanceledException();
        }
        return 0;
    }

    private void setDefaultSelection(IProcessInfo[] pInfos, TwoPaneElementSelector dlg, String binaryName, String appId) throws CoreException {
        IProcessInfo info = this.getProcessInfo(pInfos, binaryName, appId);
        ArrayList<IProcessInfo> srcProject = new ArrayList<IProcessInfo>();
        srcProject.add(info);
        dlg.setInitialElementSelections(srcProject);
    }

    @Override
    protected void setSharedlibrarySearchPath(ILaunchConfiguration config) throws CoreException {
        super.setSharedlibrarySearchPath(config);
        List values = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, new ArrayList(1));
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        IProject proj = ProjectUtil.getProject(config);
        Path debugPath = new Path(String.valueOf(proj.getLocation().toOSString()) + File.separatorChar + ProjectUtil.getDefaultConfiguration(proj).getName());
        if (this.canAddLibrarySearchPath(config, (IPath)debugPath)) {
            values.add(debugPath.toOSString());
        }
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, values);
    }

    @Override
    protected File getGDBClientArgument(IBinaryParser.IBinaryObject exeFile) {
        return null;
    }

    @Override
    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        super.setDebugConfigAttributes(config);
        this.isIme = LaunchUtils.isImeCategory(config);
        this.launchConsole.println("setDebugConfigAttributes> isIme? " + this.isIme);
    }
}

