/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.ProjectTypeManager;

public class TizenGDBBackend
extends GDBBackend {
    ILaunchConfiguration launchConfig;

    public TizenGDBBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.launchConfig = lc;
    }

    protected String getGDBCommandLine() {
        ICProject cproject = null;
        try {
            cproject = LaunchUtils.getCProject((ILaunchConfiguration)this.launchConfig);
            if (cproject == null) {
                return super.getGDBCommandLine();
            }
            IProject project = cproject.getProject();
            CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(project);
            if (builder == null) {
                return super.getGDBCommandLine();
            }
            StringBuffer gdbOptions = new StringBuffer(" -q");
            gdbOptions.append(" -nw");
            gdbOptions.append(" --interpreter");
            gdbOptions.append(" mi2");
            return builder.getGDBCommandLine(gdbOptions);
        }
        catch (IOException iOException) {
            return super.getGDBCommandLine();
        }
        catch (CoreException coreException) {
            return super.getGDBCommandLine();
        }
    }
}

