/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.PackageInfo;
import org.tizen.nativecommon.build.PackageListener;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.sdblib.IDevice;

public abstract class CommonProjectDependentPackager {
    public static final String TPK = "TPK";
    public static final String RPM = "RPM";
    public static final String DEB = "DEB";
    public static final String DEFAULT = "TPK";
    protected IProject project = null;
    protected SmartBuildInterface sbi = null;
    protected boolean isDialogCancel = false;
    private Set<PackageListener> packageListeners = new LinkedHashSet<PackageListener>();
    private IDevice device;

    public CommonProjectDependentPackager() {
        this.setSbi();
    }

    public CommonProjectDependentPackager(IProject project) {
        this.setProject(project);
        this.setSbi(project);
    }

    public abstract boolean isDependencyCheckSuppoted();

    public abstract boolean isPackageCheckSuppoted();

    public abstract boolean checkPackageFile(String var1);

    public abstract String getPackageOption(IConfiguration var1, String var2);

    protected abstract String getPackageDependencyCheckOption();

    public abstract String getTargetID(IConfiguration var1);

    public abstract void buildPackage(String var1) throws SBIException, CoreException;

    public abstract void buildPackage(String var1, String var2) throws SBIException, CoreException;

    public abstract void buildPackage(String var1, String var2, boolean var3) throws SBIException, CoreException;

    public abstract void buildPackage(String var1, boolean var2, boolean var3) throws SBIException, CoreException;

    public abstract void buildPackage(String var1, boolean var2, boolean var3, Thread var4) throws SBIException, CoreException;

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setSbi() {
        this.sbi = SmartBuildInterface.getInstance();
    }

    public void setSbi(IProject project) {
        this.sbi = SmartBuildInterface.getInstance(project);
    }

    public IProject getProject() {
        return this.project;
    }

    public SmartBuildInterface getSbi() {
        return this.sbi;
    }

    public String getWorkingDir() {
        IConfiguration config = this.getCurrentConfiguration();
        String workingDir = String.valueOf(this.getProjectPath()) + File.separatorChar + config.getName();
        return workingDir;
    }

    public String getWorkingDir(IConfiguration config) {
        String workingDir = String.valueOf(this.getProjectPath()) + File.separatorChar + config.getName();
        return workingDir;
    }

    public String getProjectPath() {
        IPath proLoc = this.project.getLocation();
        return proLoc.toOSString();
    }

    public IConfiguration getCurrentConfiguration() {
        return ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
    }

    public boolean checkMakeFile(String path) {
        Path makeFilePath = new Path(path);
        return makeFilePath.toFile().isFile();
    }

    public void addListener(PackageListener listener) {
        this.packageListeners.add(listener);
    }

    public void removeListener(PackageListener listener) {
        this.packageListeners.remove(listener);
    }

    protected void firePreCreated(IProject project, boolean isLaunchMode) throws CoreException {
        PackageInfo pkgInfo = new PackageInfo(project, isLaunchMode);
        try {
            for (PackageListener listener : this.packageListeners) {
                listener.preCreated(pkgInfo);
            }
        }
        catch (CoreException e) {
            String message = String.valueOf(e.getMessage()) + "\n\n" + CommonBuildMessages.FAIL_TO_BUILD_PACKAGE;
            LaunchUtils.newCoreException(message, e);
        }
    }

    public IDevice getDevice() {
        return this.device;
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }
}

