/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser;

import com.lowagie.text.Document;
import com.lowagie.text.List;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.util.HashMap;

public class RtfImportMgr {
    private HashMap importFontMapping = null;
    private HashMap importColorMapping = null;
    private HashMap importStylesheetListMapping = null;
    private HashMap importListMapping = null;
    private RtfDocument rtfDoc = null;
    private Document doc = null;

    public RtfImportMgr(RtfDocument rtfDocument, Document document) {
        this.rtfDoc = rtfDocument;
        this.doc = document;
        this.importFontMapping = new HashMap();
        this.importColorMapping = new HashMap();
        this.importStylesheetListMapping = new HashMap();
        this.importListMapping = new HashMap();
    }

    public boolean importFont(String string, String string2) {
        RtfFont rtfFont = new RtfFont(string2);
        rtfFont.setRtfDocument(this.rtfDoc);
        this.importFontMapping.put(string, Integer.toString(this.rtfDoc.getDocumentHeader().getFontNumber(rtfFont)));
        return true;
    }

    public boolean importFont(String string, String string2, int n) {
        RtfFont rtfFont = new RtfFont(string2);
        if (n >= 0) {
            rtfFont.setCharset(n);
        }
        rtfFont.setRtfDocument(this.rtfDoc);
        this.importFontMapping.put(string, Integer.toString(this.rtfDoc.getDocumentHeader().getFontNumber(rtfFont)));
        return true;
    }

    public boolean importFont(String string, String string2, String string3, int n) {
        RtfFont rtfFont = new RtfFont(string2);
        if (n >= 0) {
            rtfFont.setCharset(n);
        }
        if (string3 != null && string3.length() > 0) {
            rtfFont.setFamily(string3);
        }
        rtfFont.setRtfDocument(this.rtfDoc);
        this.importFontMapping.put(string, Integer.toString(this.rtfDoc.getDocumentHeader().getFontNumber(rtfFont)));
        return true;
    }

    public String mapFontNr(String string) {
        if (this.importFontMapping.containsKey(string)) {
            return (String)this.importFontMapping.get(string);
        }
        return "0";
    }

    public void importColor(String string, Color color) {
        RtfColor rtfColor = new RtfColor(this.rtfDoc, color);
        this.importColorMapping.put(string, Integer.toString(rtfColor.getColorNumber()));
    }

    public String mapColorNr(String string) {
        if (this.importColorMapping.containsKey(string)) {
            return (String)this.importColorMapping.get(string);
        }
        return "0";
    }

    public void importList(String string, String string2) {
        this.importListMapping.put(string, string2);
    }

    public String mapListNr(String string) {
        if (this.importListMapping.containsKey(string)) {
            return (String)this.importListMapping.get(string);
        }
        return null;
    }

    public boolean importStylesheetList(String string, List list) {
        RtfList rtfList = new RtfList(this.rtfDoc, list);
        rtfList.setRtfDocument(this.rtfDoc);
        return true;
    }

    public String mapStylesheetListNr(String string) {
        if (this.importStylesheetListMapping.containsKey(string)) {
            return (String)this.importStylesheetListMapping.get(string);
        }
        return "0";
    }
}

