/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common;

import org.tizen.common.util.Assert;

public enum Architecture {
    i386(new Object[]{Group.x86}),
    i486(new Object[]{Group.x86}),
    i586(new Object[]{Group.x86}),
    i686(new Object[]{Group.x86}),
    ia32(new Object[]{Group.x86}),
    armel(new Object[]{Group.arm}),
    armv7a(new Object[]{Group.arm, "ARMv7-a"}),
    armv7l(new Object[]{Group.arm});

    protected Object[] attributes;

    private Architecture(Object ... attributes) {
        Assert.notNull(attributes);
        this.attributes = attributes;
    }

    public Group getGroup() {
        Object[] objectArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Object attribute = objectArray[n2];
            if (attribute instanceof Group) {
                return (Group)((Object)attribute);
            }
            ++n2;
        }
        return Group.unknown;
    }

    public String getName() {
        Object[] objectArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Object attribute = objectArray[n2];
            if (attribute instanceof String) {
                return (String)attribute;
            }
            ++n2;
        }
        return this.name();
    }

    public static Group getGroup(String arch) {
        Architecture result = Architecture.valueOf(arch);
        return result != null ? result.getGroup() : Group.unknown;
    }

    public static enum Group {
        x86,
        arm,
        unknown;

    }
}

