/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.apihover.Item;
import org.tizen.nativecommon.apihover.ItemFunction;
import org.tizen.nativecommon.apihover.ItemMakro;
import org.tizen.nativecommon.apihover.ItemType;
import org.tizen.nativecommon.apihover.ItemVariable;

public class IndexExtractor
implements Serializable {
    @XStreamOmitField
    private static final long serialVersionUID = 1L;
    private String pathEntry;
    private String pathPrefix;
    private static final String PACKAGE_ALIAS = "packageAlias";
    @XStreamOmitField
    Map<String, String> fixedIncludes = null;
    private HashMap<String, Item> itemMap = new HashMap();
    @XStreamOmitField
    private HashMap<String, ItemType> classMap = new HashMap();
    @XStreamOmitField
    private List<ItemVariable> variableCandidate = new ArrayList<ItemVariable>();
    private boolean generatePrefixes = false;
    private int counter = 0;

    public void setGeneratePrefixes(boolean value) {
        this.generatePrefixes = value;
    }

    public boolean generatePrefixes() {
        return this.generatePrefixes;
    }

    public HashMap<String, Item> getItemMap() {
        return this.itemMap;
    }

    public HashMap<String, Item> addAnotherItemMap(HashMap<String, Item> add) {
        this.itemMap.putAll(add);
        return this.itemMap;
    }

    public HashMap<String, Item> addAnotherItemMap(IndexExtractor indexExtractor) {
        this.itemMap.putAll(indexExtractor.getItemMap());
        return this.itemMap;
    }

    public IndexExtractor(String pathPrefix, String pathEntry, Map<String, String> fixedIncludes) {
        this.pathEntry = pathEntry;
        this.pathPrefix = pathPrefix;
        this.fixedIncludes = fixedIncludes;
        this.parseAll();
    }

    protected IndexExtractor() {
    }

    private void parseAll() {
        this.parseDir(String.valueOf(this.pathPrefix) + "/" + this.pathEntry);
        for (ItemVariable v : this.variableCandidate) {
            if (this.classMap.get(v.getNamespace()) != null) continue;
            this.itemMap.put(v.getName(), v);
        }
        if (this.classMap != null) {
            for (Item item : this.itemMap.values()) {
                Item tmpNamespace = this.classMap.get(item.getNamespace());
                if (tmpNamespace == null) continue;
                this.itemMap.get(item.getName()).setNamespace(tmpNamespace.getNamespace());
            }
            this.itemMap.putAll(this.classMap);
            this.classMap.clear();
            this.variableCandidate.clear();
        }
        for (Item item : this.itemMap.values()) {
            String newNamespace;
            if (this.fixedIncludes == null || !this.fixedIncludes.containsKey(item.getName()) || (newNamespace = this.fixedIncludes.get(item.getName())) == null) continue;
            this.itemMap.get(item.getName()).setNamespace(newNamespace);
        }
        Iterator<Map.Entry<String, Item>> it = this.itemMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Item> e = it.next();
            if (!e.getKey().startsWith("_")) continue;
            it.remove();
        }
    }

    private void parseDir(String pEntry) {
        System.out.print("Parsing item: " + ++this.counter + "\r");
        String[] stringArray = new File(pEntry).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File tmpFile = new File(String.valueOf(pEntry) + "/" + file);
            if (tmpFile.isDirectory()) {
                this.parseDir(String.valueOf(pEntry) + "/" + file);
            } else if (file.endsWith(".html")) {
                this.parse(String.valueOf(pEntry) + "/" + file);
            }
            ++n2;
        }
    }

    public void serialize(String fName) {
        XStream xstream = new XStream();
        xstream.processAnnotations(IndexExtractor.class);
        xstream.aliasPackage(PACKAGE_ALIAS, this.getClass().getPackage().getName());
        try {
            FileOutputStream fs = new FileOutputStream(fName);
            xstream.toXML((Object)this, (OutputStream)fs);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static IndexExtractor unserialize(String fName) {
        XStream xstream = new XStream();
        IndexExtractor ie = new IndexExtractor();
        xstream.aliasPackage(PACKAGE_ALIAS, ie.getClass().getPackage().getName());
        try {
            FileInputStream fis = new FileInputStream(fName);
            xstream.fromXML((InputStream)fis, (Object)ie);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return ie;
    }

    public void serializeJava(String fName) {
        block6: {
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fName)));
                out.writeObject(this);
            }
            catch (FileNotFoundException e) {
                System.err.println("FileNotFoundException");
                e.printStackTrace();
                IOUtil.tryClose((Object[])new Object[]{out});
                break block6;
            }
            catch (IOException e) {
                try {
                    System.err.println("IOException");
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{out});
                    throw throwable;
                }
                IOUtil.tryClose((Object[])new Object[]{out});
                break block6;
            }
            IOUtil.tryClose((Object[])new Object[]{out});
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexExtractor unserializeJava(String fName) {
        ObjectInputStream in = null;
        IndexExtractor p = null;
        try {
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fName)));
                p = (IndexExtractor)in.readObject();
                return p;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (in == null) return p;
                try {
                    in.close();
                    return p;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return p;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (in == null) return p;
                try {
                    in.close();
                    return p;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return p;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if (in == null) return p;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                    return p;
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                return p;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static IndexExtractor unserializeJava(InputStream is) {
        IndexExtractor p = null;
        try {
            ObjectInputStream in = new ObjectInputStream(is);
            p = (IndexExtractor)in.readObject();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return p;
    }

    private List<String> getArgs(String s) {
        ArrayList<String> args = new ArrayList<String>();
        if (s.length() > 0) {
            String[] argsTab;
            Pattern pattern = Pattern.compile("\\((.*?)\\)");
            Matcher matcher = pattern.matcher(s);
            if (matcher.find()) {
                s = matcher.group();
                s = s.substring(1, s.length() - 1);
            }
            String[] stringArray = argsTab = s.split(", ");
            int n = argsTab.length;
            int n2 = 0;
            while (n2 < n) {
                String argsT = stringArray[n2];
                args.add(argsT);
                ++n2;
            }
        }
        return args;
    }

    private String getReturn(String s) {
        StringBuffer returnTypeOk = new StringBuffer();
        String[] splitReturn = s.split(" ");
        int i = 0;
        while (i < splitReturn.length - 1) {
            if (i > 0) {
                returnTypeOk.append(" ");
            }
            returnTypeOk.append(splitReturn[i]);
            ++i;
        }
        return returnTypeOk.toString().trim();
    }

    /*
     * Loose catch block
     */
    private void parse(String fileName) {
        block26: {
            System.out.print("Parsing item: " + ++this.counter + "\r");
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(fileName));
                Boolean read = false;
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!read.booleanValue() && (line.contains("synopsis") || line.contains("doxytag") || line.contains("refsect2"))) {
                        read = true;
                    }
                    if (!read.booleanValue()) continue;
                    sb.append(line);
                }
                Source source = new Source((CharSequence)sb.toString());
                Element testElement = source.getFirstElementByClass("refsect2");
                if (testElement != null) {
                    Pattern pattern;
                    Object matcher;
                    String nameSpace = null;
                    Element include = source.getFirstElementByClass("synopsis");
                    if (include != null && ((Matcher)(matcher = (pattern = Pattern.compile("#include &lt;(.*?)&gt;")).matcher(include.getContent().toString()))).find()) {
                        nameSpace = ((Matcher)matcher).group().replaceAll("#include &lt;", "").replaceAll("&gt;", "");
                    }
                    for (Element gtk : source.getAllElementsByClass("refsect2")) {
                        String nameItem;
                        StartTag t = gtk.getFirstStartTag("h3");
                        if (t == null || (nameItem = t.getElement().getContent().toString().replaceAll("<a(.*?)>", "").replaceAll("</a>", "").replaceAll("\\(", "").replaceAll("\\)", "").trim().replaceAll("\n", "")).split(" ").length > 1) continue;
                        StartTag tag = gtk.getFirstStartTag("a");
                        String attributeValue = null;
                        attributeValue = tag != null ? tag.getAttributeValue("name") : "";
                        String urlItem = String.valueOf(fileName.replaceFirst(this.pathPrefix, "")) + "#" + attributeValue;
                        Element prototype = gtk.getFirstElementByClass("programlisting");
                        String returnType = null;
                        if (prototype == null) continue;
                        returnType = prototype.getContent().toString().replaceAll("<a(.*?)>", "").replaceAll("</a>", "").replaceAll("<span(.*?)>", "").replaceAll("</span>", "").replaceAll("&nbsp;", " ").replaceAll("&quot;", "\"").replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#45;", "-").replaceAll("\n", "").replaceAll("\t", "").replaceAll("  ", "").replaceAll("<em(.*?)>", "").replaceAll("</em>", "").replaceAll("<code>", "").replaceAll("</code>", "");
                        if (returnType.toLowerCase().contains("#define")) {
                            this.itemMap.put(nameItem, new ItemMakro(nameItem, nameSpace, urlItem, this.getArgs(returnType)));
                            continue;
                        }
                        if (returnType.toLowerCase().trim().startsWith("typedef ") || returnType.toLowerCase().trim().startsWith("enum ") || returnType.toLowerCase().trim().startsWith("class ") || returnType.toLowerCase().trim().startsWith("struct ")) {
                            this.itemMap.put(nameItem, new ItemType(nameItem, nameSpace, urlItem));
                            continue;
                        }
                        if (returnType.contains("(")) {
                            this.itemMap.put(nameItem, new ItemFunction(nameItem, nameSpace, urlItem, this.getReturn(returnType.split("\\(")[0]), this.getArgs(returnType)));
                            continue;
                        }
                        this.itemMap.put(nameItem, new ItemVariable(nameItem, nameSpace, urlItem));
                    }
                } else {
                    for (Tag doxytag : source.getAllStartTags(StartTagType.COMMENT)) {
                        StartTag firstStartTag;
                        if (!doxytag.toString().contains("doxytag:")) continue;
                        String classAttribute = doxytag.parseAttributes().getValue("class");
                        Element nextElement = source.getNextElement(doxytag.getEnd());
                        if (nextElement == null) continue;
                        Element memitemElement = nextElement.getFirstElementByClass("memitem");
                        if (classAttribute != null) {
                            Element includeElement = source.getNextElement(doxytag.getEnd(), "code");
                            String include = null;
                            if (includeElement != null && includeElement.getContent().toString().contains("#include")) {
                                include = includeElement.getContent().toString().replaceAll("<a(.*?)>", "").replaceAll("</a>", "").replaceAll("&gt", "").replaceAll("&lt", "").split(";")[1];
                            }
                            this.classMap.put(classAttribute, new ItemType(classAttribute, include, fileName.replaceFirst(this.pathPrefix, "")));
                            continue;
                        }
                        if (memitemElement == null) continue;
                        String memberAttribute = doxytag.parseAttributes().getValue("member").replaceAll("&#45;", "-");
                        String urlItem = String.valueOf(fileName.replaceFirst(this.pathPrefix, "")) + "#" + doxytag.parseAttributes().getValue("ref");
                        String argsAttribute = doxytag.parseAttributes().getValue("args");
                        Element element = memitemElement.getFirstElementByClass("memname");
                        if (element == null || (firstStartTag = element.getFirstStartTag("td")) == null) continue;
                        String returnType = firstStartTag.getElement().getContent().toString().replaceAll("<a(.*?)>", "").replaceAll("</a>", "").replaceAll("&nbsp;", " ").replaceAll("&quot;", "\"").replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#45;", "-");
                        String nameItem = null;
                        String nameSpace = null;
                        String[] tmp = memberAttribute.split("::");
                        if (tmp != null && tmp.length == 1) {
                            nameItem = tmp[0];
                        } else if (tmp.length > 1) {
                            nameSpace = tmp[0];
                            nameItem = tmp[tmp.length - 1];
                        }
                        if (nameItem != null && nameItem.startsWith("@")) continue;
                        if (returnType.toLowerCase().contains("#define")) {
                            this.itemMap.put(nameItem, new ItemMakro(nameItem, nameSpace, urlItem, this.getArgs(argsAttribute)));
                            continue;
                        }
                        if (returnType.toLowerCase().trim().startsWith("typedef ") || returnType.toLowerCase().trim().startsWith("enum ") || returnType.toLowerCase().trim().startsWith("class ") || returnType.toLowerCase().trim().startsWith("struct ")) {
                            this.itemMap.put(nameItem, new ItemType(nameItem, nameSpace, urlItem));
                            continue;
                        }
                        if (argsAttribute.startsWith("(")) {
                            this.itemMap.put(nameItem, new ItemFunction(nameItem, nameSpace, urlItem, this.getReturn(returnType), this.getArgs(argsAttribute)));
                            continue;
                        }
                        this.variableCandidate.add(new ItemVariable(nameItem, nameSpace, urlItem));
                    }
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                IOUtil.tryClose((Object[])new Object[]{in});
                break block26;
            }
            catch (IOException e) {
                e.printStackTrace();
                IOUtil.tryClose((Object[])new Object[]{in});
                break block26;
            }
            catch (OutOfMemoryError e) {
                Runtime.getRuntime().gc();
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Object[])new Object[]{in});
                        throw throwable;
                    }
                }
                IOUtil.tryClose((Object[])new Object[]{in});
                break block26;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private static void help() {
        System.out.println("IndexExtractor help");
        System.out.println("Use java -jar IndexExtractor.jar prefixPath relaticeDocPath outIndexFile");
        System.out.println("\t\t prefixPath \t- path where docs/API_Document is located (example /opt/samsung_sdk)");
        System.out.println("\t\t docPath\t \t- path (relative to prefixPath) where documentation is located (example docs/API_Document/spl");
        System.out.println("\t\t outIndexFile \t- name of output index file");
        System.out.println("\t\t Example:\t \tjava -jar IndexExtractor.jar /opt/samsung_sdk docs/API_Document/docs.enlightenment.org/ecore ecore-index");
        System.out.println();
        System.out.println("or use java -jar IndexExtractor.jar prefixPath --default to parse definied documentation");
    }

    private static void defaultUsage(String pathApiDocs) {
        System.out.println("Default configuration used");
        String[] pathEntry = new String[]{"docs/API_Document/slp", "docs/API_Document/library.gnome.org/gtk-html-2.90.5", "docs/API_Document/library.gnome.org/glib-html-2.24.1", "docs/API_Document/docs.enlightenment.org/ecore", "docs/API_Document/docs.enlightenment.org/e_dbus", "docs/API_Document/docs.enlightenment.org/edje", "docs/API_Document/docs.enlightenment.org/eet", "docs/API_Document/docs.enlightenment.org/eina", "docs/API_Document/docs.enlightenment.org/embryo", "docs/API_Document/docs.enlightenment.org/epdf", "docs/API_Document/docs.enlightenment.org/ethumb", "docs/API_Document/docs.enlightenment.org/eupnp", "docs/API_Document/docs.enlightenment.org/evas", "docs/API_Document/docs.enlightenment.org/evil", "docs/API_Document/docs.enlightenment.org/exalt", "docs/API_Document/docs.enlightenment.org/eyelight"};
        File dbDir = new File(String.valueOf(pathApiDocs) + "/docs/API_Document/db/");
        if (!dbDir.exists()) {
            dbDir.mkdir();
        }
        String[] stringArray = pathEntry;
        int n = pathEntry.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String[] splitPath = path.split("/");
            String indexName = String.valueOf(pathApiDocs) + "/docs/API_Document/db/" + splitPath[splitPath.length - 1] + "-index";
            IndexExtractor ie = new IndexExtractor(pathApiDocs, path, null);
            ie.serialize(indexName);
            System.out.println("Documentation " + pathApiDocs + path + " parsed \n\t" + splitPath[splitPath.length - 1] + "-index generated \n\t ");
            ++n2;
        }
    }

    private static void fixInclude(String pathApiDocs) throws IOException {
        System.out.println("Default configuration used");
        String[] pathEntry = new String[]{"docs/API_Document/slp", "docs/API_Document/library.gnome.org/gtk-html-2.90.5", "docs/API_Document/library.gnome.org/glib-html-2.24.1", "docs/API_Document/docs.enlightenment.org/ecore", "docs/API_Document/docs.enlightenment.org/e_dbus", "docs/API_Document/docs.enlightenment.org/edje", "docs/API_Document/docs.enlightenment.org/eet", "docs/API_Document/docs.enlightenment.org/eina", "docs/API_Document/docs.enlightenment.org/embryo", "docs/API_Document/docs.enlightenment.org/epdf", "docs/API_Document/docs.enlightenment.org/ethumb", "docs/API_Document/docs.enlightenment.org/eupnp", "docs/API_Document/docs.enlightenment.org/evas", "docs/API_Document/docs.enlightenment.org/evil", "docs/API_Document/docs.enlightenment.org/exalt", "docs/API_Document/docs.enlightenment.org/eyelight"};
        File dbDir = new File(String.valueOf(pathApiDocs) + "/docs/API_Document/db/");
        if (!dbDir.exists()) {
            dbDir.mkdir();
        }
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            socket = new Socket("localhost", 1234);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        String[] stringArray = pathEntry;
        int n = pathEntry.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String[] splitPath = path.split("/");
            String indexName = String.valueOf(pathApiDocs) + "/docs/API_Document/db/" + splitPath[splitPath.length - 1] + "-index";
            IndexExtractor ie = new IndexExtractor(pathApiDocs, path, null);
            Set<Map.Entry<String, Item>> set = ie.getItemMap().entrySet();
            for (Map.Entry<String, Item> me : set) {
                String newNameSpace;
                if (me.getValue().getNamespace() == null || me.getValue().getNamespace().equals("gtk/gtk.h") || me.getValue().getNamespace().equals("glib.h") || me.getValue().getNamespace().endsWith(".c")) continue;
                String[] nameSpace = me.getValue().getNamespace().split("/");
                out.println("@%" + me.getValue().getName() + " " + nameSpace[nameSpace.length - 1] + "!^");
                char[] cbuf = new char[1024];
                in.read(cbuf, 0, 1024);
                if (String.copyValueOf(cbuf).startsWith("><") || (newNameSpace = String.copyValueOf(cbuf).substring(1).replaceAll("<(.*?)", "").trim()).equals(me.getValue().getNamespace())) continue;
                me.getValue().setNamespace(newNameSpace);
            }
            ie.serialize(indexName);
            System.out.println("Documentation " + pathApiDocs + path + " parsed \n\t" + splitPath[splitPath.length - 1] + "-index generated \n\t ");
            ++n2;
        }
        out.close();
        in.close();
        socket.close();
    }

    public static void main(String[] args) throws IOException {
        switch (args.length) {
            case 2: {
                if (args[1].equals("--default")) {
                    IndexExtractor.defaultUsage(args[0]);
                    break;
                }
                if (args[1].equals("--fixInclude")) {
                    IndexExtractor.fixInclude(args[0]);
                    break;
                }
                IndexExtractor.help();
                break;
            }
            case 3: {
                new IndexExtractor(args[0], args[1], null).serialize(args[2]);
                System.out.println("Documentation " + args[1] + " parsed \n\t" + args[2] + " generated \n\t ");
                break;
            }
            default: {
                IndexExtractor.help();
            }
        }
    }
}

