/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.sa.pages;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.tizen.common.ui.page.properties.model.Checker;
import org.tizen.common.ui.page.properties.model.CheckerSeverity;
import org.tizen.common.ui.page.properties.model.ICheckerElement;
import org.tizen.common.ui.page.properties.model.RootChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CheckersProfileManager {
    public static String CHECKERS_FILEPATH = String.valueOf(Platform.getInstallLocation().getURL().getPath()) + "Templates" + File.separator + "native" + File.separator + "sa_checkers" + File.separator;
    public static String CHECKERS_FILE_NAME = "checkers_llvm34.xml";
    public ICheckerElement baseProfile;
    public static String LLVM34 = "LLVM-3.4";
    public static String LLVM36 = "LLVM-3.6";
    public static String LLVM37 = "LLVM-3.7";
    public String toolChainName;

    public CheckersProfileManager(String toolchainName) {
        this.toolChainName = toolchainName;
        this.baseProfile = CheckersProfileManager.getXMLInput(this.toolChainName);
    }

    public static ICheckerElement getXMLInput(String toolChainName) {
        String fileName = null;
        if (toolChainName.equals(LLVM34)) {
            fileName = "checkers_llvm34.xml";
        } else if (toolChainName.equals(LLVM36) || toolChainName.equals(LLVM37)) {
            fileName = "checkers_llvm36.xml";
        }
        Element xmlRoot = null;
        RootChecker root = new RootChecker(null, null, null, null);
        File llvmCheckerFile = new File(String.valueOf(CHECKERS_FILEPATH) + fileName);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (!llvmCheckerFile.exists()) {
                return root;
            }
            Document document = builder.parse(new File(String.valueOf(CHECKERS_FILEPATH) + fileName));
            xmlRoot = document.getDocumentElement();
            Node module = xmlRoot.getFirstChild();
            while (module != null) {
                if (module.getNodeName().equals("Checker")) {
                    root.addChild(CheckersProfileManager.readNode(root, module));
                }
                module = module.getNextSibling();
            }
            CheckersProfileManager.setEncodingsUpdateCheckedStatus(root, "");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(root.getChildren(), new Comparator<ICheckerElement>(){

            @Override
            public int compare(ICheckerElement o1, ICheckerElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return root;
    }

    private static void setEncodingsUpdateCheckedStatus(ICheckerElement root, String encoding) {
        if (!encoding.isEmpty()) {
            root.setEncoding(String.valueOf(encoding) + "." + root.getEncoding());
        }
        for (ICheckerElement child : root.getChildren()) {
            CheckersProfileManager.setEncodingsUpdateCheckedStatus(child, root.getEncoding());
        }
    }

    static ICheckerElement readNode(ICheckerElement parent, Node node) {
        Checker root = null;
        if (node.getNodeName().equals("Checker")) {
            String name = null;
            String encoding = null;
            String description = null;
            String severity = CheckerSeverity.LOW.toString();
            boolean checked = false;
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("Name")) {
                    name = child.getFirstChild().getNodeValue().trim();
                }
                if (child.getNodeName().equals("Encoding")) {
                    encoding = child.getFirstChild().getNodeValue().trim();
                }
                if (child.getNodeName().equals("Description")) {
                    description = child.getFirstChild().getNodeValue().trim();
                }
                if (child.getNodeName().equals("Severity")) {
                    severity = child.getFirstChild().getNodeValue().trim();
                    String string = severity = severity == null || severity.isEmpty() ? CheckerSeverity.LOW.toString() : severity;
                }
                if (child.getNodeName().equals("Enable")) {
                    String enablexml = child.getFirstChild().getNodeValue().trim();
                    checked = enablexml.equals("Yes");
                }
                child = child.getNextSibling();
            }
            root = new Checker(name, encoding, checked, description, CheckerSeverity.valueOf(CheckerSeverity.class, severity));
            child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("CheckerList")) {
                    Node innerChecker = child.getFirstChild();
                    while (innerChecker != null) {
                        if (innerChecker.getNodeName().equals("Checker")) {
                            root.addChild(CheckersProfileManager.readNode(root, innerChecker));
                        }
                        innerChecker = innerChecker.getNextSibling();
                    }
                }
                child = child.getNextSibling();
            }
        }
        return root;
    }
}

